/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.Messages;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

class PrefsDialog
extends Dialog {
    private static final String DRE_CORE_PACKAGE_PATH = "jp.thisnor.dre.core";
    private DREFrame mainFrame;
    private PreferenceStore prefs;
    private Messages messages;
    private Shell shell;
    private TableViewer prefsTableViewer;
    private Button closeButton;
    private final IContentProvider PREFS_TABLE_CONTENT_PROVIDER = new ArrayContentProvider(){

        public Object[] getElements(Object inputElement) {
            Object[] prefKeys = PrefsDialog.this.prefs.preferenceNames();
            return prefKeys;
        }
    };
    private final CellLabelProvider PREFS_TABLE_KEY_LABEL_PROVIDER = new CellLabelProvider(){

        public void update(ViewerCell cell) {
            String key = (String)cell.getElement();
            if (key.startsWith(PrefsDialog.DRE_CORE_PACKAGE_PATH)) {
                key = key.substring(PrefsDialog.DRE_CORE_PACKAGE_PATH.length() + 1);
            }
            cell.setText(key);
        }
    };
    private final CellLabelProvider PREFS_TABLE_VALUE_LABEL_PROVIDER = new CellLabelProvider(){

        public void update(ViewerCell cell) {
            String key = (String)cell.getElement();
            cell.setText(PrefsDialog.this.prefs.getString(key));
        }
    };
    private final MouseListener PREFS_TABLE_CELL_CLICKED_LISTENER = new MouseAdapter(){

        public void mouseDown(MouseEvent event) {
            Table t = PrefsDialog.this.prefsTableViewer.getTable();
            int i = 0;
            while (i < t.getItemCount()) {
                TableItem item = t.getItem(i);
                int j = 0;
                while (j < t.getColumnCount()) {
                    if (item.getBounds(j).contains(event.x, event.y)) {
                        PrefsDialog.this.prefsTableViewer.editElement(item.getData(), 1);
                        return;
                    }
                    ++j;
                }
                ++i;
            }
        }
    };
    private final ViewerSorter PREFS_TABLE_VIEWER_SORTER = new ViewerSorter(){

        public int category(Object element) {
            return ((String)element).startsWith(PrefsDialog.DRE_CORE_PACKAGE_PATH) ? 0 : 1;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 == (cat2 = this.category(e2))) {
                return ((String)e1).compareTo((String)e2);
            }
            return cat1 < cat2 ? -1 : 1;
        }
    };
    private final SelectionListener CLOSE_BUTTON_SELECTION_LISTENER = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            PrefsDialog.this.shell.close();
        }
    };

    PrefsDialog(DREFrame mainFrame) {
        super(mainFrame.getShell(), 0);
        this.mainFrame = mainFrame;
        this.prefs = mainFrame.getPreferences();
        this.messages = mainFrame.getMessages();
    }

    void open() {
        Display display = this.mainFrame.getShell().getDisplay();
        this.createContents();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (!display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents() {
        this.shell = new Shell(this.mainFrame.getShell(), 67680);
        this.shell.setText(this.messages.getString("PrefsDialog.TITLE"));
        FormLayout l = new FormLayout();
        l.marginHeight = 8;
        l.marginWidth = 8;
        l.spacing = 8;
        this.shell.setLayout((Layout)l);
        this.prefsTableViewer = new TableViewer((Composite)this.shell, 0x10000900);
        this.prefsTableViewer.getTable().setHeaderVisible(true);
        this.prefsTableViewer.setContentProvider(this.PREFS_TABLE_CONTENT_PROVIDER);
        this.prefsTableViewer.setSorter(this.PREFS_TABLE_VIEWER_SORTER);
        this.prefsTableViewer.getTable().addMouseListener(this.PREFS_TABLE_CELL_CLICKED_LISTENER);
        this.prefsTableViewer.setInput((Object)this.prefs);
        l = new TableLayout();
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        this.prefsTableViewer.getTable().setLayout((Layout)l);
        TableViewerColumn keyColumn = new TableViewerColumn(this.prefsTableViewer, 0);
        keyColumn.getColumn().setText(this.messages.getString("PrefsDialog.COLUMN.KEY"));
        keyColumn.setLabelProvider(this.PREFS_TABLE_KEY_LABEL_PROVIDER);
        TableViewerColumn valueColumn = new TableViewerColumn(this.prefsTableViewer, 0);
        valueColumn.getColumn().setText(this.messages.getString("PrefsDialog.COLUMN.VALUE"));
        valueColumn.setLabelProvider(this.PREFS_TABLE_VALUE_LABEL_PROVIDER);
        valueColumn.setEditingSupport((EditingSupport)new PrefsTableEditingSupport());
        this.closeButton = new Button((Composite)this.shell, 8);
        this.closeButton.setText(this.messages.getString("PrefsDialog.CLOSE_BUTTON_TEXT"));
        this.closeButton.addSelectionListener(this.CLOSE_BUTTON_SELECTION_LISTENER);
        this.prefsTableViewer.getTable().setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).bottom((Control)this.closeButton).build());
        this.closeButton.setLayoutData((Object)new FormDataBuilder().width(120).right(100).height(30).bottom(100).build());
    }

    private class PrefsTableEditingSupport
    extends EditingSupport {
        private PrefsTableEditingSupport() {
            super((ColumnViewer)PrefsDialog.this.prefsTableViewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)PrefsDialog.this.prefsTableViewer.getTable());
        }

        protected Object getValue(Object element) {
            return PrefsDialog.this.prefs.getString((String)element);
        }

        protected void setValue(Object element, Object value) {
            PrefsDialog.this.prefs.setValue((String)element, String.valueOf(value));
            PrefsDialog.this.prefsTableViewer.refresh(element);
        }
    }
}

