/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.File;
import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.Messages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class PathInputViewer {
    private Messages messages;
    private Composite rootComp;
    private Text pathText;
    private Button openButton;
    private final SelectionListener OPEN_BUTTON_SELECTED = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            String fpath;
            int posSep;
            String currentPath = PathInputViewer.this.getPath();
            if (!new File(currentPath).exists() && (posSep = currentPath.lastIndexOf(File.separatorChar)) >= 0) {
                currentPath = currentPath.substring(0, posSep);
            }
            DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
            if (currentPath != null) {
                dialog.setFilterPath(currentPath);
            }
            if ((fpath = dialog.open()) != null) {
                PathInputViewer.this.pathText.setText(fpath);
            }
        }
    };

    PathInputViewer(DREFrame frame) {
        this.messages = frame.getMessages();
    }

    Control getControl() {
        return this.rootComp;
    }

    String getPath() {
        return this.pathText.getText();
    }

    void setPath(String path) {
        this.pathText.setText(path);
    }

    void addModifyListener(ModifyListener l) {
        this.pathText.addModifyListener(l);
    }

    void setEnabled(boolean enabled) {
        this.rootComp.setEnabled(enabled);
        this.pathText.setEnabled(enabled);
        this.openButton.setEnabled(enabled);
    }

    void createContents(Composite parent) {
        this.rootComp = new Composite(parent, 0);
        FormLayout l = new FormLayout();
        this.rootComp.setLayout((Layout)l);
        this.pathText = new Text(this.rootComp, 2048);
        this.openButton = new Button(this.rootComp, 8);
        this.openButton.setText(this.messages.getString("PathInputViewer.OPEN_BUTTON_TEXT"));
        this.openButton.addSelectionListener(this.OPEN_BUTTON_SELECTED);
        this.pathText.setLayoutData((Object)new FormDataBuilder().left(0).right((Control)this.openButton).bottom(100).build());
        this.openButton.setLayoutData((Object)new FormDataBuilder().right(100).bottom(100).build());
    }
}

