/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import jp.thisnor.dre.app.DREFrame;
import jp.thisnor.dre.app.FormDataBuilder;
import jp.thisnor.dre.app.ImageUtils;
import jp.thisnor.dre.app.Messages;
import jp.thisnor.dre.app.OptionTableViewer;
import jp.thisnor.dre.core.MeasurerPackage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class PackageViewer {
    private static final String DEFAULT_PACKAGE_ICON_PATH = "res/icon/image_multi32.png";
    private DREFrame frame;
    private Messages messages;
    private Composite rootComp;
    private Composite descComp;
    private Label nameLabel;
    private Label infoLabel;
    private Text descText;
    private Label packageIcon;
    private OptionTableViewer optionTableViewer;
    private Font boldFont;
    private Image defaultPackageIcon;

    PackageViewer(DREFrame frame) {
        this.frame = frame;
        this.messages = frame.getMessages();
    }

    void createContents(Composite parent) {
        FontData systemFontData = Display.getCurrent().getSystemFont().getFontData()[0];
        this.boldFont = new Font((Device)Display.getCurrent(), systemFontData.getName(), systemFontData.getHeight(), 1);
        this.defaultPackageIcon = ImageUtils.loadImage(DEFAULT_PACKAGE_ICON_PATH);
        this.rootComp = new Composite(parent, 0);
        FormLayout l = new FormLayout();
        l.spacing = 8;
        this.rootComp.setLayout((Layout)l);
        this.descComp = new Composite(this.rootComp, 0);
        l = new FormLayout();
        l.spacing = 8;
        this.descComp.setLayout((Layout)l);
        this.packageIcon = new Label(this.descComp, 262144);
        Composite descTextComp = new Composite(this.descComp, 0);
        descTextComp.setLayout((Layout)new FormLayout());
        this.nameLabel = new Label(descTextComp, 0);
        this.nameLabel.setFont(this.boldFont);
        this.infoLabel = new Label(descTextComp, 0);
        this.descText = new Text(descTextComp, 2634);
        this.nameLabel.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).build());
        this.infoLabel.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top((Control)this.nameLabel).build());
        this.descText.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top((Control)this.infoLabel).bottom(0, 100).build());
        this.packageIcon.setLayoutData((Object)new FormDataBuilder().left(0).right(0, 32).top(0).bottom(0, 32).build());
        descTextComp.setLayoutData((Object)new FormDataBuilder().left((Control)this.packageIcon).right(100).top(0).bottom(100).build());
        Composite optionTableComp = new Composite(this.rootComp, 0);
        optionTableComp.setLayout((Layout)new FormLayout());
        Label optionTableLabel = new Label(optionTableComp, 0);
        optionTableLabel.setText(this.messages.getString("PackageViewer.OPTION_TABLE_CAPTION"));
        this.optionTableViewer = new OptionTableViewer(this.frame);
        this.optionTableViewer.createContents(optionTableComp);
        optionTableLabel.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).build());
        this.optionTableViewer.getTableViewer().getTable().setLayoutData((Object)new FormDataBuilder().left(0).right(100).top((Control)optionTableLabel).bottom(100).build());
        this.descComp.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top(0).build());
        optionTableComp.setLayoutData((Object)new FormDataBuilder().left(0).right(100).top((Control)this.descComp).bottom(100).build());
    }

    Control getControl() {
        return this.rootComp;
    }

    void setActivePackage(MeasurerPackage handlerPackage) {
        if (handlerPackage == null) {
            this.nameLabel.setText("");
            this.infoLabel.setText("");
            this.descText.setText("");
            this.packageIcon.setImage(null);
        } else {
            this.nameLabel.setText(handlerPackage.getName() != null ? handlerPackage.getName() : "(Untitled handler)");
            this.infoLabel.setText(String.valueOf(handlerPackage.getVersion() != null ? "version " + handlerPackage.getVersion() : "") + ", " + (handlerPackage.getAuthor() != null ? handlerPackage.getAuthor() : "(Unknown author)"));
            this.descText.setText(handlerPackage.getDescription() != null ? handlerPackage.getDescription() : "");
            this.packageIcon.setImage(handlerPackage.getImage() != null ? handlerPackage.getImage() : this.defaultPackageIcon);
            this.optionTableViewer.setOptionMap(handlerPackage.getOptionMap());
        }
        this.descComp.layout();
    }
}

