/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import jp.thisnor.dre.app.ImageUtils;
import jp.thisnor.dre.core.MeasurerPackage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class PackageListViewer {
    private static final String DEFAULT_PACKAGE_ICON_PATH = "res/icon/image_multi32.png";
    private MeasurerPackage[] packages;
    private Table packageList;
    private Font systemFont;
    private Font boldFont;
    private Image defaultPackageIcon;
    private final Listener PACKAGE_LIST_MEASURE_ITEM_LISTENER = new Listener(){

        public void handleEvent(Event event) {
            event.height = Math.max(event.height, 40);
        }
    };
    private final Listener PACKAGE_LIST_ERASE_ITEM_LISTENER = new Listener(){

        public void handleEvent(Event event) {
            event.detail &= 0xFFFFFFEF;
        }
    };
    private final Listener PACKAGE_LIST_PAINT_ITEM_LISTENER = new Listener(){

        public void handleEvent(Event event) {
            TableItem item = (TableItem)event.item;
            MeasurerPackage pack = (MeasurerPackage)item.getData();
            Image icon = pack.getImage() != null ? pack.getImage() : PackageListViewer.this.defaultPackageIcon;
            String name = pack.getName();
            String caption = pack.getCaption();
            GC gc = event.gc;
            gc.drawImage(icon, 0, 0, icon.getImageData().width, icon.getImageData().height, event.x + 4, event.y + 4, 32, 32);
            gc.setFont(PackageListViewer.this.boldFont);
            gc.drawText(name, event.x + 48, event.y + 0, true);
            gc.setFont(PackageListViewer.this.systemFont);
            gc.drawText(caption, event.x + 48, event.y + 20, true);
        }
    };

    PackageListViewer(MeasurerPackage[] packages) {
        this.packages = packages;
    }

    void createContents(Composite parent) {
        this.systemFont = Display.getCurrent().getSystemFont();
        FontData systemFontData = this.systemFont.getFontData()[0];
        this.boldFont = new Font((Device)Display.getCurrent(), systemFontData.getName(), systemFontData.getHeight(), 1);
        this.defaultPackageIcon = ImageUtils.loadImage(DEFAULT_PACKAGE_ICON_PATH);
        this.packageList = new Table(parent, 0x10000A00);
        this.packageList.addListener(41, this.PACKAGE_LIST_MEASURE_ITEM_LISTENER);
        this.packageList.addListener(40, this.PACKAGE_LIST_ERASE_ITEM_LISTENER);
        this.packageList.addListener(42, this.PACKAGE_LIST_PAINT_ITEM_LISTENER);
        TableLayout l = new TableLayout();
        l.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.packageList.setLayout((Layout)l);
        new TableColumn(this.packageList, 0);
        MeasurerPackage[] measurerPackageArray = this.packages;
        int n = this.packages.length;
        int n2 = 0;
        while (n2 < n) {
            MeasurerPackage pack = measurerPackageArray[n2];
            TableItem item = new TableItem(this.packageList, 0);
            item.setData((Object)pack);
            ++n2;
        }
    }

    Table getTable() {
        return this.packageList;
    }

    MeasurerPackage getActivePackage() {
        return this.packageList.getSelectionCount() > 0 ? (MeasurerPackage)this.packageList.getSelection()[0].getData() : null;
    }
}

