/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.app;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import jp.thisnor.dre.app.Application;
import jp.thisnor.dre.app.InputStreamUtils;
import jp.thisnor.dre.core.FileEntry;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageUtils {
    private ImageUtils() {
    }

    /*
     * Loose catch block
     */
    public static Image loadImage(String path) {
        if (Application.isInJar()) {
            InputStream in;
            block20: {
                in = null;
                in = ClassLoader.getSystemResourceAsStream(path);
                if (in != null) break block20;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            Image image = new Image((Device)Display.getDefault(), in);
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return image;
            catch (SWTException e) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        try {
            return new Image((Device)Display.getCurrent(), path);
        }
        catch (SWTException e) {
            return null;
        }
    }

    public static Image loadImage(FileEntry entry) {
        InputStream in = null;
        try {
            in = entry.open();
            Image image = new Image((Device)Display.getCurrent(), in);
            return image;
        }
        catch (IOException e) {
            return null;
        }
        catch (SWTException e) {
            return null;
        }
        finally {
            InputStreamUtils.close(in);
        }
    }

    public static ImageSize getImageSize(FileEntry file) {
        InputStream in = null;
        try {
            in = file.open();
            ImageInputStream iin = ImageIO.createImageInputStream(in);
            Iterator<ImageReader> it = ImageIO.getImageReaders(iin);
            if (!it.hasNext()) {
                return null;
            }
            ImageReader reader = it.next();
            reader.setInput(iin);
            ImageSize imageSize = new ImageSize(reader.getWidth(0), reader.getHeight(0));
            return imageSize;
        }
        catch (IOException e) {
            return null;
        }
        finally {
            InputStreamUtils.close(in);
        }
    }

    public static class ImageSize {
        public final int width;
        public final int height;

        public ImageSize(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

