/*
 * Decompiled with CFR 0.152.
 */
package jp.thisnor.dre.pixeldup;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.imageio.ImageIO;
import jp.thisnor.dre.core.FileEntry;
import jp.thisnor.dre.core.MeasureOptionEntry;
import jp.thisnor.dre.core.Measurer;
import jp.thisnor.dre.pixeldup.PixelDupData;

public class PixelDupMeasurer
implements Measurer {
    private static final File CACHE_DIR = new File("cache");
    private static final File CACHE_FILE = new File("cache/jp.thisnor.dre.pixeldup.cache.sqlite3");
    private static final String TABLE_NAME = "pixeldup_cache";
    private volatile String algorithm;
    private volatile boolean useCache;
    private Queue<CacheEntry> storeCacheQueue;
    private static final int PREF_QUEUE_SIZE = 64;

    @Override
    public void init(Map<String, MeasureOptionEntry> optionMap) {
        this.algorithm = optionMap.get("hashAlgorithm").getValue();
        this.useCache = optionMap.get("useCache").getValue().equals("true");
        if (this.useCache) {
            this.initDB();
            this.storeCacheQueue = new ConcurrentLinkedQueue<CacheEntry>();
        }
        MeasureOptionEntry thresholdOption = new MeasureOptionEntry("threshold");
        thresholdOption.setValue("1");
        optionMap.put("threshold", thresholdOption);
    }

    @Override
    public Object convert(FileEntry fileEntry) throws Exception {
        PixelDupData data;
        if (this.useCache && (data = this.loadCache(fileEntry)) != null) {
            return data;
        }
        BufferedImage srcImage = null;
        InputStream in = null;
        try {
            try {
                in = fileEntry.open();
                srcImage = ImageIO.read(in);
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to read image file: %s.", fileEntry.getPath()), e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (srcImage == null) {
            throw new IOException(String.format("Failed to read image file: %s.", fileEntry.getPath()));
        }
        ColorModel cm = srcImage.getColorModel();
        SampleModel sm = srcImage.getSampleModel();
        if (!cm.getColorSpace().isCS_sRGB() || !(sm instanceof PixelInterleavedSampleModel) || sm.getDataType() != 0) {
            BufferedImage tmpImage = new BufferedImage(srcImage.getWidth(), srcImage.getHeight(), 5);
            Graphics2D g2 = tmpImage.createGraphics();
            g2.drawImage((Image)srcImage, 0, 0, null);
            g2.dispose();
            srcImage = tmpImage;
        }
        byte[] srcPixelBytes = new byte[srcImage.getWidth() * srcImage.getHeight() * ((ComponentSampleModel)srcImage.getSampleModel()).getPixelStride()];
        srcImage.getRaster().getDataElements(0, 0, srcImage.getWidth(), srcImage.getHeight(), srcPixelBytes);
        MessageDigest md = MessageDigest.getInstance(this.algorithm);
        md.update(srcPixelBytes);
        byte[] hash = md.digest();
        PixelDupData data2 = new PixelDupData(hash);
        if (this.useCache) {
            this.storeCacheQueue.offer(new CacheEntry(fileEntry, data2));
            if (this.storeCacheQueue.size() >= 64) {
                this.storeCaches();
            }
        }
        return data2;
    }

    @Override
    public int measure(Object o1, Object o2, int threshold) {
        PixelDupData data1 = (PixelDupData)o1;
        PixelDupData data2 = (PixelDupData)o2;
        int len = Math.min(data1.hash.length, data2.hash.length);
        int sum = 0;
        int i = 0;
        while (i < len) {
            int d = data1.hash[i] - data2.hash[i];
            if ((sum += Math.abs(d)) > threshold) break;
            ++i;
        }
        return sum;
    }

    @Override
    public void dispose() {
        if (this.useCache) {
            this.storeCaches();
        }
    }

    private void initDB() {
        try {
            Class.forName("org.sqlite.JDBC");
            if (!CACHE_DIR.exists()) {
                CACHE_DIR.mkdirs();
            }
            Connection conn = null;
            try {
                conn = DriverManager.getConnection("jdbc:sqlite:" + CACHE_FILE.getPath());
                Statement stat = conn.createStatement();
                stat.execute("CREATE TABLE IF NOT EXISTS pixeldup_cache(name TEXT, date INTEGER, hash BLOB);");
                stat.execute("CREATE INDEX IF NOT EXISTS id_date_size on pixeldup_cache(name, date);");
                conn.close();
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (Exception e) {
            this.useCache = false;
        }
    }

    /*
     * Loose catch block
     */
    private PixelDupData loadCache(FileEntry entry) {
        byte[] hash;
        Connection conn;
        block22: {
            ResultSet res;
            block21: {
                conn = null;
                conn = DriverManager.getConnection("jdbc:sqlite:" + CACHE_FILE.getPath());
                Statement stat = conn.createStatement();
                res = stat.executeQuery(String.format("SELECT hash FROM %s WHERE name = %s AND date = %s;", TABLE_NAME, entry.getName(), entry.getLastModified()));
                if (res.next()) break block21;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return null;
            }
            hash = res.getBytes(1);
            if (!res.next()) break block22;
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return null;
        }
        PixelDupData pixelDupData = new PixelDupData(hash);
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return pixelDupData;
        catch (SQLException e) {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return null;
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void storeCaches() {
        Connection conn = null;
        try {
            try {
                conn = DriverManager.getConnection("jdbc:sqlite:" + CACHE_FILE.getPath());
                conn.setAutoCommit(false);
                CacheEntry cacheEntry = null;
                while ((cacheEntry = this.storeCacheQueue.poll()) != null) {
                    PreparedStatement stat = conn.prepareStatement(String.format("INSERT INTO %s VALUES(%s, %s, ?);", TABLE_NAME, cacheEntry.fileEntry.getName(), cacheEntry.fileEntry.getLastModified()));
                    stat.setBytes(1, ((CacheEntry)cacheEntry).data.hash);
                    stat.executeUpdate();
                }
                conn.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private static class CacheEntry {
        private final FileEntry fileEntry;
        private final PixelDupData data;

        private CacheEntry(FileEntry fileEntry, PixelDupData data) {
            this.fileEntry = fileEntry;
            this.data = data;
        }
    }
}

