<?php
/*
  ◆文武王 (step_vampire)
  ○仕様
  ・処刑投票：感染者付加 (確率)
*/
RoleLoader::LoadFile('vampire');
class Role_step_vampire extends Role_vampire {
  public $mix_in = array('step_mage');
  public $action = VoteAction::STEP_VAMPIRE;
  public $submit = VoteAction::VAMPIRE;

  protected function GetStackVoteKillType() {
    return RoleStackVoteKill::INIT;
  }

  public function VoteKillAction() {
    foreach ($this->GetStack() as $uname => $target_uname) {
      if ($this->IsVoted($uname) || ! Lottery::Percent(30)) continue;
      $user = DB::$USER->ByRealUname($target_uname);
      if ($user->IsDead(true)) continue;

      //吸血鬼判定
      if ($user->IsMainGroup(CampGroup::VAMPIRE) ||
	  (RoleUser::IsDelayCopy($user) && $user->IsCamp(Camp::VAMPIRE))) {
	continue;
      }
      $user->AddRole(DB::$USER->ByUname($uname)->GetID('infected'));
    }
  }

  protected function IsVoteCheckboxLive($live) {
    return true;
  }

  protected function GetVoteCheckboxType() {
    return OptionFormType::CHECKBOX;
  }

  public function CheckVoteNightTarget(array $list) {
    return $this->CheckStepVoteNightTarget($list);
  }
}
