<%@ taglib uri='/WEB-INF/templates/jsp/tld/template.tld' prefix='jetspeed' %>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page errorPage="wiki-error.jsp" %>
<%@ page import = "jp.mobster.webapp.wiki.*" %>
<%@ page import = "jp.mobster.util.*" %>
<%
    WebUtil.setCurrentURL( (String)request.getAttribute("current.page") );

	Wiki wiki = new Wiki(request, response, config);
	request.setAttribute("wiki", wiki);
	
	String pid = wiki.getPageName();
	String paramPid = WebUtil.encodeURL(pid);
    WebUtil.setCurrentPage( pid );
	
	String action = wiki.getAction();
	
	final String mymsg;
	if(action.equals("save")) {
			mymsg = wiki.getParameter("mymsg");
			wiki.setText(mymsg);
	} else {
			mymsg = wiki.getText();
	}
	
	String orderType = request.getParameter("orderType");
	if(orderType == null || orderType.length() == 0) {
		orderType = "title";
	}
	
	String order = request.getParameter("order");
	if(order == null || order.length() == 0) {
		order = "asc";
	}
	String text = wiki.getParameter("text");
	text = (text == null ? "" : text);
	
	WikiData[] datas = wiki.getWikiDatas(orderType, order, text);
%>

<jsp:include page="wiki-head.jsp" flush="true" />
<h1 class="header">
	MobWiki List
</h1>
<%
	if(text != null && text.length() > 0) {
%>
検索文字 : <%= text %>&nbsp;<%=datas.length%>ページHit
<%
	}
%>

<br>
<form action="<%= WebUtil.getCurrentURL() %>" method="POST">
    <input type="hidden" name="eventSubmit_doWiki_search" value="action"/>
	<input type="text" name="text" value="<%= text %>">
	<input type="submit" name="submiy" value="検索">
</form>
<table class="table-list">
	<tr>
		<td align="center" class="td-list">
			<% if(orderType.equals("date")) { %>
				<b>日付</b>
				<% if(order.equals(WikiComparator.ASC)) { %>
					<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=date&order=<%= WikiComparator.DESC %>&text=<%= WebUtil.encodeURL(text) %>">
						<img src="images/down.gif">
					</a>
				<% } else { %>
					<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=date&order=<%= WikiComparator.ASC %>&text=<%= WebUtil.encodeURL(text) %>">
						<img src="images/up.gif">
					</a>
				<% } %>
			<% } else { %>
				<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=date&order=<%= WikiComparator.DESC %>&text=<%= WebUtil.encodeURL(text) %>">
					日付
				</a>
			<% } %>
		</td>
		<td align="center" class="td-list">
			<% if(orderType.equals("title")) { %>
				<b>タイトル</b>
				<% if(order.equals(WikiComparator.ASC)) { %>
					<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=title&order=<%= WikiComparator.DESC %>&text=<%= WebUtil.encodeURL(text) %>">
						<img src="images/down.gif">
					</a>
				<% } else { %>
					<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=title&order=<%= WikiComparator.ASC %>&text=<%= WebUtil.encodeURL(text) %>">
						<img src="images/up.gif">
					</a>
				<% } %>
			<% } else { %>
				<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=title&order=<%= WikiComparator.DESC %>&text=<%= WebUtil.encodeURL(text) %>">
					タイトル
				</a>
			<% } %>
		</td>
		<td align="center" class="td-list">
			<% if(orderType.equals("subtitle")) { %>
				<b>サブタイトル</b>
				<% if(order.equals(WikiComparator.ASC)) { %>
					<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=subtitle&order=<%= WikiComparator.DESC %>&text=<%= WebUtil.encodeURL(text) %>">
						<img src="images/down.gif">
					</a>
				<% } else { %>
					<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=subtitle&order=<%= WikiComparator.ASC %>&text=<%= WebUtil.encodeURL(text) %>">
						<img src="images/up.gif">
					</a>
				<% } %>
			<% } else { %>
				<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_search=action&pid=<%= paramPid %>&orderType=subtitle&order=<%= WikiComparator.DESC %>&text=<%= WebUtil.encodeURL(text) %>">
					サブタイトル
				</a>
			<% } %>
		</td>
	</tr>
<%
	for(int i = 0 ; i < datas.length ; i++) {
%>
	<tr>
		<td class="td-list" style="font-family : monospace;" nowrap>
			<%= datas[i].getLastModifiedAsString() %>
		</td>
		<td class="td-list">
			<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_index=action&pid=<%=WebUtil.encodeURL(datas[i].getTitle())%>">
				<%= datas[i].getTitle() %>
			</a>
		</td>
		<td class="td-list">
			<%= datas[i].getSubtitle().equals("") ? "&nbsp;" : datas[i].getSubtitle() %>
		</td>
	</tr>
<%
	}
%>
</table>
<jsp:include page="wiki-tail.jsp" flush="true" />
