<%@ taglib uri='/WEB-INF/templates/jsp/tld/template.tld' prefix='jetspeed' %>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page errorPage="wiki-error.jsp" %>
<%@ page import = "jp.mobster.webapp.wiki.*" %>
<%@ page import = "jp.mobster.util.*" %>
<%
    WebUtil.setCurrentURL( (String)request.getAttribute("current.page") );

	Wiki wiki = new Wiki(request, response, config);
	request.setAttribute("wiki", wiki);
	
	String pid = wiki.getPageName();
	String paramPid = WebUtil.encodeURL(pid);
    WebUtil.setCurrentPage( pid );

	String action = wiki.getAction();

	final String mymsg;
	if(action.equals("save")) {
			mymsg = wiki.getParameter("mymsg");
			wiki.setText(mymsg);
	} else {
			mymsg = wiki.getText();
	}
%>

<jsp:include page="wiki-head.jsp" flush="true" />
<h1 class="header">
	<!--a title="" href="index.jsp?pid=<%=paramPid%>"-->
		<!-- <%=pid%> -->
        <%= wiki.getParameter("pid") %>
	<!--/a-->
	<%=wiki.getSubtitle()%>
</h1>
<%
//	if(wiki.getParameter("img", request.getAttribute("img")) != null && wiki.getParameter("img", request.getAttribute("img")).length() > 0) {
	if(request.getAttribute("img") != null && request.getAttribute("img") instanceof String && ((String)request.getAttribute("img")).length() > 0) {
%>
	<img src="/wiki/upload/<%= WebUtil.encodeURL((String)request.getAttribute("img")) %>"> <%= WebUtil.encodeURL((String)request.getAttribute("img")) %><br><br>
<%
	}
	
	if(action.equals("edit") || action.equals("create") || action.equals("preview")) {
%>
	<form name="myForm" action="<%= WebUtil.getCurrentURL() %>" method="POST">
    <!-- <input type="hidden" name="pid" value="<%=paramPid%>"/> -->
    <input type="hidden" name="pid" value="<%= wiki.getParameter("pid") %>"/>
    <input type="hidden" name="eventSubmit_doWiki_index" value="action"/>

<% if(wiki.isLockedPage()) { %>
		<p>
			<!--
			<strong>
				ページを凍結するにはパスワードが必要です。
			</strong>
			-->
		</p>
		パスワード 
		<input type="password" name="mypassword" value="" size="10"><br>
<% } %>

		<input type="hidden" name="myLastModified" value="Wed Aug 28 22:50">
		<textarea name="mymsg" cols=80 rows=20 wrap=off><%=mymsg%></textarea>
		<br>
		<input type="checkbox" name="mytouch" value="true" checked="checked">
		タイムスタンプを更新<br>
		<input type="hidden" name="wiki_action" value="edit_regist">
		<input type="hidden" name="lastModified" value="<%=wiki.getLastModified()%>">
		<input type="submit" name="action_preview" value="プレビュー">
		<input type="submit" name="action_save" value="保存する">
	</form>
	<p>
	</p>
	
<%
	}
%>

<% if(action.equals("preview")) { %>
<div class="preview">
	<%=wiki.getContentsByString(mymsg)%>
</div>
<% } %>

<%
	if(action.equals("edit") || action.equals("create") || action.equals("preview")) {
%>
<div>
	<%=wiki.getFormatContents()%>
</div>
<% } %>


<% if(action.equals("new")) { %>
	<form action="<%= WebUtil.getCurrentURL() %>" method="POST">
        <input type="hidden" name="eventSubmit_doWiki_index" value="action"/>
		<input type="hidden" name="wiki_action" value="create">
		<strong>新しいページの名前を入力してください。</strong><br>
		<input type="text" name="pid" value="" size="20">
		<input type="submit" value="新規作成"><br>
	</form>
<% } %>

<% if(action.equals("save")) { %>
	<% if(wiki.isDeletable()) { %>
	<p><strong>削除しました。</strong></p>
	<p>
		もう一度作りたいときは次のリンクをたどってください:  
		<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_index=action&pid=<%=paramPid%>&wiki_action=create">?</a><%=pid%>
	</p>
	<% } else { %>
	<p><strong>保存しました。</strong></p>
	<p>
		次のリンクをたどってください:  
		<a href="<%= WebUtil.getCurrentURL() %>?eventSubmit_doWiki_index=action&pid=<%=paramPid%>"><%=pid%></a>
	</p>	
	<% } %>
<% } %>


<% if(action.equals("")) { %>
	<%=wiki.getContents()%>
<% } %>

<jsp:include page="wiki-tail.jsp" flush="true" />
