package jp.mobster.webapp.wiki.transform;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import jp.mobster.util.CacheProperties;
import jp.mobster.util.ExtensionFilter;
import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;

import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;

/**
 * Wiki ǡ̾ HTML Ѵ
 * 
 * @see DataLine, DataLineCreator
 */
public class WikiTransformer
{
    String basePath_, str_;
    File[] files_;
    CacheProperties properties_;
    Map lineMap_ = new HashMap();
    String[] keywords_;
    String[] dataTags_;

    /**
     * 󥹥ȥ饯
     * 
     * @param str Wikiǡʸ
     * @param files 󥯥Ѵ뤿Υե
     **/
    public WikiTransformer(String basePath, String str, File[] files)
    {
        basePath_ = basePath;
        str_ = str;
        files_ = files;

        init();
    }

    /**
     * 
     * 
     * @see DataLineComparator
     **/
    private void init()
    {
        final String configPath = basePath_ + "WEB-INF/conf/wiki-tag.properties";
        properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");

        //ɤĹǥȤMap
        //keyɡvalue:饹̾
        //lineMap_ = new TreeMap(new DataLineComparator());
        String keyword;
        for (Iterator i = properties_.keySet().iterator(); i.hasNext();)
        {
            keyword = (String) i.next();
            if (keyword.indexOf("tag.") == -1)
            {
                //
                lineMap_.put(keyword, properties_.getProperty(keyword));
            }
        }
        keywords_ = (String[]) lineMap_.keySet().toArray(new String[0]);
        Arrays.sort(keywords_, new DataLineComparator());

        dataTags_ = properties_.getPropertyArray("tag");
    }

    /**
     * Wikiڡʸ¾WikiڡؤΥ󥯥ɲ
     * @param str Wikiǡʸ
     * @return ѴѤߥǡ
     */
    private String addWikiTagURLEscape(String src)
    {
        String tmp = src;
        Perl5Util util = new Perl5Util();

        // Wikiڡ¸ߤ
        // 󥯥ղ
        String pageName;
        for (int i = 0; i < files_.length; i++)
        {
            pageName = ExtensionFilter.removeExtention(files_[i].getName());

            if (isAutoLink(pageName))
            {
                tmp = util.substitute("s!([^=^\\\"]|^)(" + pageName + ")!$1ENCODE{$2}ENCODE!g", tmp);
                tmp = util.substitute("s!([^=^\\\"]|^)\\[\\[(ENCODE{" + pageName + "}ENCODE)\\]\\]!$1$2!g", tmp);
            }
            else
            {
                tmp = util.substitute("s!([^=^\\\"]|^)\\[\\[(" + pageName + ")\\]\\]!$1ENCODE{$2}ENCODE!g", tmp);
            }

            tmp = util.substitute("s!([^=^\\\"]|^)\\[\\[" + pageName + "\\]\\]!$1ENCODE{$2}ENCODE!g", tmp);
        }

        // Wikiڡ¸ߤʤ
        // "?"ղáڡؤΥ
        PatternMatcherInput input = new PatternMatcherInput(tmp);
        while (util.match("m!\\[\\[(.*)\\]\\]!", input))
        {
            pageName = util.group(1);
            tmp = util.substitute("s!([^=^\\\"]|^)\\[\\[(" + pageName + ")\\]\\]!$1ENCODE2{$2}ENCODE2!g", tmp);
        }

        return tmp;
    }

    static boolean isAutoLink(String pageName)
    {
        if (!StringUtil.containsChar(pageName, "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"))
            return false;
        int upper = 0;
        //		int lower = 0;
        for (int i = 0; i < pageName.length(); i++)
        {
            char c = pageName.charAt(i);
            if (c >= 'A' && c <= 'Z')
            {
                //				if(upper != 0 && lower == 0) return false;
                upper++;
                //				lower = 0;
                //			} else {
                //				lower++;
            }
        }
        return (upper > 1);
    }

    /**
     * Wikiڡʸ¾WikiڡؤΥ󥯥ɲ
     * @param str Wikiǡʸ
     * @return ѴѤߥǡ
     */
    private String addWikiTagURL(String src)
    {
        String tmp = src;
        Perl5Util util = new Perl5Util();

        // Wikiڡ¸ߤ
        // 󥯥ղ
        String pageName;
        for (int i = 0; i < files_.length; i++)
        {
            pageName = ExtensionFilter.removeExtention(files_[i].getName());
            tmp =
                util.substitute(
                    "s!(ENCODE{"
                        + pageName
                        + "}ENCODE)!<a href="
                        + WebUtil.getCurrentURL()
                        + "?pid="
                        + WebUtil.encodeURL(pageName)
                        + ">"
                        + pageName
                        + "</a>!g",
                    tmp);
        }

        // Wikiڡ¸ߤʤ
        // "?"ղáڡؤΥ
        PatternMatcherInput input = new PatternMatcherInput(tmp);
        while (util.match("m!\\ENCODE2{(.*)}ENCODE2!", input))
        {
            pageName = util.group(1);
            tmp =
                util.substitute(
                    "s!ENCODE2{("
                        + pageName
                        + ")}ENCODE2!<a href="
                        + WebUtil.getCurrentURL()
                        + "?wiki_action=create&pid="
                        + WebUtil.encodeURL(pageName)
                        + ">?</a>$1"
                        + "!g",
                    tmp);
        }

        return tmp;
    }

    /**
     * ñʥ֤ǡ
     * 
     * оݥ
     * ''' : <em>ǡ</em>
     * '' : <b>ǡ</b>
     * 
     * @return ñʥ֤ǡ
     **/
    private String getReplacedSimpleTags()
    {
        try
        {
            Perl5Util perl = new Perl5Util();
            String tmp = str_ + "\n"; // Ū֡ǽԤĤͭˤ뤿

            for (int i = 0; i < dataTags_.length; i++)
            {
                tmp = createDataTag(dataTags_[i]).get(tmp);
                //ɤĤä顢б DataLine 饹
            }
            return tmp;
        }
        catch (Exception e)
        {
            //Exception νê夲
            //ɤޤΤ뤫̤
            return e.getMessage();
        }
    }

    /**
     * DataTag 饹.
     * 
     * @param dataTag 饹̾
     * @return DataTag 饹
     **/
    private DataTag createDataTag(String dataTag)
        throws InstantiationException, IllegalAccessException, ClassNotFoundException
    {
        return (DataTag) ((Class.forName(dataTag)).newInstance());
    }

    /**
     * WikiǡHTMLؤΥǡѴ
     * 
     * @return ѴѤߥǡ
     **/
    public String transform()
    {
        try
        {
            final StringBuffer buf = new StringBuffer();
            str_ = addWikiTagURLEscape(str_);

            final String[] datas = StringUtil.split(getReplacedSimpleTags(), "\n");

            String data;
            DataLine dataLine = new BasicDataLine(), newLine;
            dataLine.init("");
            for (int i = 0; i < datas.length; i++)
            {
                data = datas[i];

                newLine = getDataLine(data);
                buf.append(dataLine.closeTag(newLine));

                buf.append(newLine.openTag(dataLine));
                dataLine = newLine;

                buf.append(dataLine.get());
            }

            return addWikiTagURL(buf.toString());
        }
        catch (Exception e)
        {
            //Exception νê夲
            //ɤޤΤ뤫̤
            return e.getMessage();
        }
    }

    /**
     * ɤб DataLine 
     **/
    private DataLine getDataLine(String data)
        throws InstantiationException, IllegalAccessException, ClassNotFoundException
    {

        String keyword;
        for (int i = 0; i < keywords_.length; i++)
        {
            keyword = keywords_[i];
            //ɤĤä顢б DataLine 饹
            if (fastIndex(data, keyword))
            {
                DataLine dataLine = createDataLine((String) lineMap_.get(keyword));
                dataLine.init(data);

                return dataLine;
            }
        }

        //̾ǡ
        DataLine dataLine = new BasicDataLine();
        dataLine.init(data);

        return dataLine;
    }

    /**
     * DataLine 饹.
     * 
     * @param dataLine 饹̾
     * @return DataLine 饹
     **/
    private DataLine createDataLine(String dataLine)
        throws InstantiationException, IllegalAccessException, ClassNotFoundException
    {
        return (DataLine) ((Class.forName(dataLine)).newInstance());
    }

    /**
     * ʸƬ˥ɤ뤫ɤ
     * 
     * @param str оʸ
     * @param keyword 
     * @return true ɤꡢfalse ɤʤ
     **/
    private static boolean fastIndex(String str, String keyword)
    {
        int index = str.indexOf(keyword);
        return (index == 0 ? true : false);
    }
}
