package jp.mobster.webapp.wiki.transform;

import jp.mobster.util.StringUtil;

/**
 * ɡ:פ
 * 
 * , : <dl><dt>[̾ʸ]</dt><dd>[̾ʸ]</dd></dl>
 * 
 * @see DataLineCreator
 */
public class DefinitionDataLine implements DataLine
{
        private String keyword_ = ":", //ɡ֤оݡ
        lineData_, //ǡ
        dataHoldTag_ = "", //ǡΤϤॿ
    outerHoldTag_ = "dl"; //ǡγ¦Ϥॿ

    /**
     * 
     * 
     * @param lineData ԥǡʥʬ
     **/
    public void init(String lineData)
    {
        // :[Ѹ]:[ʸ]ȤʤäƤΤǥʬ
        String[] cells = StringUtil.split(lineData.substring(1), ":");
        StringBuffer buf = new StringBuffer();
        if (cells.length > 0)
        {
            buf.append("<dt>" + cells[0] + "</dt>");
        }
        if (cells.length > 1)
        {
            buf.append("<dd>" + cells[1] + "</dd>");
        }
        lineData_ = buf.toString();
    }

    /**
     * Ƭɼ
     * 
     * @return Ƭ
     **/
    public String getKeyword()
    {
        return keyword_;
    }

    /**
     * ǡγ¦򶴤೫ϥ<dl>˼
     * 
     * @param oldLine ιԥǡ
     * @return <dl>
     **/
    public String openTag(DataLine oldLine)
    {
        if (oldLine != null && oldLine instanceof DefinitionDataLine)
        {
            //ιԤʸǡξ<dl>Ϥʤ
            return "";
        }
        else
        {
            return "<" + outerHoldTag_ + ">\n";
        }
    }

    /**
     * ǡγ¦򶴤ཪλ</dl>˼
     * 
     * @param newLine ιԥǡ
     * @return </dl>
     **/
    public String closeTag(DataLine newLine)
    {
        if (newLine != null && !(newLine instanceof DefinitionDataLine))
        {
            return "</" + outerHoldTag_ + ">\n";
        }
        else
        {
            //ιԤʸǡξ</dl>Ϥʤ
            return "";
        }
    }

    /**
     * ԥǡ
     * 
     * @return ԥǡ
     **/
    public String get()
    {
        return lineData_ + "\n";
    }
}
