package jp.mobster.webapp.wiki.tag;

import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;
import jp.mobster.webapp.wiki.transform.DataTag;

/**
 * ShortCut Data Tag
 * Ƭ#NOSHORTCUTդ̵
 * usage    : *A **b  to
 * <ul>
 *   <li>
 *     <a href="#i0">a</a>
 *   </li>
 *   <ul>
 *     <a href="#i1">b</a>
 *   </ul>
 * </ul>
 * <a name=i0"> </a>
 * <h1>a</h1>
 * <a name=i0"> </a>
 * <h2>b</h2>
 * @author <a href="mailto:agata@mobster.jp">Toshitaka Agata</a>
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:22:56 $
 */
public class ShortCutDataTag implements DataTag
{
    /**
     * @see jp.mobster.webapp.wiki.transform.DataTag#get()
     */
    public String get(String pageData)
    {
        StringBuffer buffer = new StringBuffer();
        String[] datas = StringUtil.split(pageData, "\n");
        int count = 0;
        for (int i = 0; i < datas.length; i++)
        {
            if (fastIndex(datas[i], "#NOSHORTCUT"))
            {
                datas = removeArray(datas, i);
                return StringUtil.join(datas, "\n");
            }
            else if (fastIndex(datas[i], "**"))
            {
                String name = "i" + count;
                buffer.append("--" + makeShortCutAnchorTag(name, datas[i].substring(2)) + "\n");
                datas[i] = datas[i] + makeAnchorNameTag(name);
                count++;
            }
            else if (fastIndex(datas[i], "*"))
            {
                String name = "i" + count;
                buffer.append("-" + makeShortCutAnchorTag(name, datas[i].substring(1)) + "\n");
                datas[i] = datas[i] + makeAnchorNameTag(name);
                count++;
            }
        }
        buffer.append(StringUtil.join(datas, "\n"));
        return buffer.toString();
    }
    /**
     * Method removeArray.
     * @param datas
     * @param i
     * @return String[]
     */
    private String[] removeArray(String[] src, int pos)
    {
        String[] dest = new String[src.length - 1];
        for (int i = 0, index = 0; i < src.length; i++)
        {
            if (i != pos)
            {
                dest[index] = src[i];
                index++;
            }
        }

        return dest;
    }
    /**
     * Method makeShortCutAnchorTag.
     * @param name
     * @param string
     * @return String
     */
    private String makeShortCutAnchorTag(String name, String text)
    {
        return "<a href=\""
            + WebUtil.getCurrentURL()
            + "?pid="
            + WebUtil.encodeURL(WebUtil.getCurrentPage())
            + "#"
            + name
            + "\">"
            + text
            + "</a>";
    }
    /**
     * Method makeAnchorNameTag.
     * @param name
     * @return String
     */
    private String makeAnchorNameTag(String name)
    {
        return "<a name=\"" + name + "\"> </a>";
    }
    /**
     * ʸƬ˥ɤ뤫ɤ
     * 
     * @param str оʸ
     * @param keyword 
     * @return true ɤꡢfalse ɤʤ
     **/
    private static boolean fastIndex(String str, String keyword)
    {
        int index = str.indexOf(keyword);
        return (index == 0 ? true : false);
    }
}
