package jp.mobster.webapp.wiki.tag;

import org.apache.oro.text.perl.Perl5Util;

import jp.mobster.util.StringUtil;
import jp.mobster.webapp.wiki.transform.DataTag;

/**
 * Color Data Tag
 * @author <a href="mailto:masanori@mobster.jp">Masanori Hashimoto</a>
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:22:56 $
 */
public class ColorDataTag implements DataTag
{

    private static final String REGULAR_EXPRESSION = "s!COLOR\\(([^:]*):([^)]*)\\)!<font color=\\\"$1\\\">$2</font>!g";

    /**
     * @see jp.mobster.webapp.wiki.transform.DataTag#get()
     */
    public String get(String pageData)
    {
        Perl5Util perl = new Perl5Util();
        //		StringBuffer buffer = new StringBuffer();
        //		String[] datas = StringUtil.split(pageData, "\n");
        //		for(int i = 0; i < datas.length; i++) {
        //			datas[i] = perl.substitute(REGULAR_EXPRESSION, pageData);
        //		}

        // font color
        return perl.substitute(REGULAR_EXPRESSION, pageData);
    }

}
