package jp.mobster.webapp.wiki;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;

import jp.mobster.util.ExtensionFilter;
import jp.mobster.util.WebUtil;

/**
 * Wiki Utility Class
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:22:20 $
 */
public class WikiUtil
{
    private static final String SEP = File.separator;
    private static final int WIKI_NAME_MIN_LENGTH = 1;

    /**
     * WikiWord̾Ȥͭե̾ȤƻȤʤʪ
     * @param wikiWorkName WikiWord̾
     */
    public static boolean validWikiWordName(String name)
    {

        if (name == null)
            return false;

        if (name.length() < WIKI_NAME_MIN_LENGTH)
            return false;

        if (name.indexOf('\\') != -1)
            return false;
        if (name.indexOf('/') != -1)
            return false;
        if (name.indexOf('.') != -1)
            return false;

        return (true);

    }
    /**
     * оݥǥ쥯ȥΥƥȥեʤθ
     * textե⤫ե̾˴ޤեΰֵѡ
     * @param dir оݥǥ쥯ȥ
     * @param text ʸ
     * @return File[] ̤Υեꥹ
     * @throws IOException 
     */
    public static File[] grep(File dir, String text) throws IOException
    {
        ExtensionFilter filter = new ExtensionFilter("txt");

        File[] files = dir.listFiles(filter);
        return grep(files, text);
    }
    /**
     * оݥǥ쥯ȥΥƥȥեʤθ
     * textե⤫ե̾˴ޤեΰֵѡ
     * @param text ʸ
     * @return File[] ̤Υեꥹ
     * @throws IOException 
     */
    public static File[] grep(File[] files, String text)
    {
        ArrayList list = new ArrayList();
        for (int i = 0; i < files.length; i++)
        {
            File file = files[i];
            if (find(file, text))
            {
                list.add(file);
            }
        }
        return (File[]) list.toArray(new File[0]);
    }
    /**
     * եΥƥȤ򸡺Ƚꡣ
     * եʸ󡦥ե̾textޤtrue֤ޤ
     * @param file ե
     * @param text ʸ
     * @return boolean оʸޤեʤtrue, ʳfalse
     * @throws IOException
     */
    public static boolean find(File file, String text)
    {
        // ե̾оʸ󤬴ޤޤƤtrue
        if (find(file.getName(), text))
            return true;

        boolean flg = false;
        try
        {
            flg = find(new InputStreamReader(new FileInputStream(file), WebUtil.SHIFT_JIS), text);

        }
        catch (IOException ex)
        {
            ex.printStackTrace();
        }

        return flg;
    }
    /**
     * ꡼ΥƥȤ򸡺Ƚꡣ
     * ꡼ʸtextޤtrue֤ޤ
     * @param reader ꡼
     * @param text ʸ
     * @return boolean оʸޤtrue, ʳfalse
     * @throws IOException
     */
    public static boolean find(Reader reader, String text) throws IOException
    {

        if (text == null || text.equals(""))
            return false;

        BufferedReader in = null;
        try
        {
            in = new BufferedReader(reader);
            String str = null;
            while ((str = in.readLine()) != null)
            {
                if (find(str, text))
                    return true;
            }
        }
        finally
        {
            if (in != null)
            {
                in.close();
            }
        }
        return false;
    }
    /**
     * ʸstrtext̵ɤȽꡣ
     * @param str ʸ
     * @param text ʸ
     * @return boolean true - textޤ, false - textޤޤʤ
     */
    public static boolean find(String str, String text)
    {
        return find(str, text, true);
    }
    /**
     * ʸstrtext̵ɤȽꡣ
     * @param str ʸ
     * @param text ʸ
     * @param flg ʸʸ̤ʤɤ true=̤ʤ,false=̤
     * @return boolean true - textޤ, false - textޤޤʤ
     */
    public static boolean find(String str, String text, boolean flg)
    {
        if (text == null || text.equals(""))
            return false;

        if (flg)
        {
            if (str.toUpperCase().indexOf(text.toUpperCase()) != -1)
                return true;
            else
                return false;
        }
        else
        {
            if (str.indexOf(text) != -1)
                return true;
            else
                return false;
        }
    }
    /**
     * StackTrace
     */
    public static String getStackTrace(Throwable ex) throws IOException
    {

        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        String str = writer.getBuffer().toString();
        str = WebUtil.addBrTag(str);
        str = WebUtil.escapeSpace(str);

        return str;
    }
}