package jp.mobster.webapp.wiki;

import java.io.File;
import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.capability.CapabilityMapFactory;
import org.apache.jetspeed.om.registry.MediaTypeEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.resources.JetspeedResources;

import jp.mobster.util.CacheProperties;
import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;
import jp.mobster.webapp.wiki.transform.WikiTransformer;

/**
 * Wiki Main Class
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:22:20 $
 */
public class Wiki
{
    public static final String KEY_ADMIN_PASSWORD = "admin.password";
    public static final String KEY_FIXEDPAGE = "fixedpage";
    public static final String KEY_LOCKEDPAGE = "lockedpage";
    public static final String KEY_DEFAULT_STYLE = "default.style";
    public static final String DEFAULT_SYSTEM_ENCODING = System.getProperty("file.encoding");

    private HttpServletRequest request_;
    private HttpServletResponse response_;

    private String base_;
    private final String pageName_;
    private final CacheProperties properties_;

    //եǡ֥
    private final WikiData pageData_; //ڡΥǡ֥

    // Page Encoding
    private String pageEncoding;

    //local Test
    public Wiki(String pageName)
    {
        base_ = "d:/project/wiki/";
        String configPath = base_ + "WEB-INF/conf/wiki-config.properties";
        properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
        pageName_ = pageName;

        pageData_ = new WikiData(base_, getPageName(), properties_);
    }

    //Yamane's local Test
    public Wiki(int dummy, String pageName)
    {
        base_ = "D:/eclipse-SDK-2.0.1-win32/eclipse/workspace/wiki/";
        String configPath = base_ + "WEB-INF/conf/wiki-config.properties";
        properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");
        pageName_ = pageName;

        pageData_ = new WikiData(base_, pageName, properties_);
    }

    /**
     * 󥹥ȥ饯
     */
    public Wiki(HttpServletRequest request, HttpServletResponse response, ServletConfig config) throws WikiException
    {
        request_ = request;
        response_ = response;
        base_ = config.getServletContext().getRealPath("/");
        if (!base_.substring(base_.length() - 1).equals(File.separator))
        {
            base_ += File.separator;
        }

        String configPath = base_ + "WEB-INF/conf/wiki-config.properties";
        properties_ = CacheProperties.getInstance(new File(configPath), "UTF-8");

        // get encoding info
        pageEncoding = JetspeedResources.getString(JetspeedResources.CONTENT_ENCODING_KEY, "US-ASCII");
        CapabilityMap cm = CapabilityMapFactory.getCapabilityMap(request.getHeader("User-Agent"));
        String mimeCode = cm.getPreferredType().getCode();
        if (mimeCode != null)
        {
            MediaTypeEntry media = (MediaTypeEntry) Registry.getEntry(Registry.MEDIA_TYPE, mimeCode);
            if (media != null && media.getCharacterSet() != null)
            {
                pageEncoding = media.getCharacterSet();
            }
        }
        WebUtil.setPageEncoding(pageEncoding);

        pageName_ = getPageName();
        if (!WikiUtil.validWikiWordName(pageName_))
        {
            throw new WikiException(properties_.getProperty("error.file.valid"));
        }
        pageData_ = new WikiData(base_, pageName_, properties_);

        if (getAction().equals("create") && pageData_.isExists())
        {
            throw new WikiException(properties_.getProperty("error.file.exists"));
        }

    }

    public WikiData[] getWikiDatas(String orderType, String order, String text)
    {
        return WikiData.getWikiDatas(base_, properties_, orderType, order, text);
    }

    /**
     * ꥯȤڡID
     * ڡIDʤХǥեȥڡIDfrontpageˤ֤
     * 
     * @return ڡID
     */
    public String getPageName()
    {
        if (getParameter("wiki_action").equals("create"))
        {
            return getParameter("pid");
        }
        else
        {
            Object obj = request_.getAttribute("pid");
            if (obj != null && obj instanceof String)
            {
                return (String) obj;
            }
            else
            {
                return WebUtil.getParameter(request_, "pid", getFrontPage(), pageEncoding);
            }
            //            return WebUtil.getParameter(request_, "pid", getFrontPage(), DEFAULT_SYSTEM_ENCODING);

        }
    }

    /**
     * ץѥƥեȥڡIDμ
     * ʥեȥڡID = ǥեȥڡID
     * 
     * @return եȥڡID
     **/
    private String getFrontPage()
    {
        return properties_.getProperty("frontpage");
    }

    /**
     * ڡƥȤ¸
     * 
     * @exception WikiException 
     */
    public void setText(String text) throws IOException, WikiException
    {
        if (isFixedPage(pageName_))
            return;

        if (isLockedPage() && !getParameter("mypassword").equals(properties_.getProperty("password")))
        {
            throw new WikiException(properties_.getProperty("error.password"));
        }

        if (!isUpdatable())
        {
            throw new WikiException(properties_.getProperty("error.updated"));
        }

        if (isDeletable())
        {
            pageData_.deleteFile(); // Delete
        }
        else
        {
            boolean updateTime = Boolean.valueOf(getParameter("mytouch")).booleanValue();
            pageData_.setText(text, updateTime); // Save
        }

    }

    /**
     * ᥤ
     * WikiѤ˥ڡƥȤùHTMLʸ
     */
    public String replaceWiki(String str) throws IOException
    {
        File[] files = pageData_.getContentsFileList();
        WikiTransformer trans = new WikiTransformer(base_, str, files);
        String tmp = trans.transform();

        return tmp;
    }

    /**
     * Խǽʥڡɤ
     * 
     * @return true:Խǽʥڡfalse:ԽǤʤڡ
     **/
    public boolean isFixedPage()
    {
        return isFixedPage(pageName_);
    }

    /**
     * Խǽʥڡɤ
     * 
     * @param pageName ȽоݤΥڡ
     * @return true:Խǽʥڡfalse:ԽǤʤڡ
     **/
    private boolean isFixedPage(String pageName)
    {
        String[] fixedPages = StringUtil.split(properties_.getProperty(KEY_FIXEDPAGE));

        for (int i = 0; i < fixedPages.length; i++)
        {
            if (fixedPages[i].equals(pageName))
                return true;
        }

        return false;
    }
    /**
     * ѥɤɬפʥڡɤ
     * 
     * @return true:ѥɤɬפʥڡfalse:ѥɤɬפʤڡ
     **/
    public boolean isLockedPage()
    {
        return isLockedPage(pageName_);
    }
    /**
     * ѥɤɬפʥڡɤ
     * 
     * @param pageName ȽоݤΥڡ
     * @return true:ѥɤɬפʥڡfalse:ѥɤɬפʤڡ
     **/
    private boolean isLockedPage(String pageName)
    {
        String[] lockedPages = StringUtil.split(properties_.getProperty(KEY_LOCKEDPAGE));

        for (int i = 0; i < lockedPages.length; i++)
        {
            if (lockedPages[i].equals(pageName))
                return true;
        }

        return false;
    }

    /**
     * ꥯȤѥ᡼μʸ
     */
    public String getParameter(String paramName)
    {
        //        return WebUtil.getParameter(request_, paramName, WebUtil.JIS_AUTO_DETECT);
        return WebUtil.getParameter(request_, paramName, pageEncoding);
    }
    /**
     * ꥯȤѥ᡼μʸ
     */
    public String getParameter(String paramName, String defaultStr)
    {
        //      return WebUtil.getParameter(request_, paramName, defaultStr, WebUtil.JIS_AUTO_DETECT);
        return WebUtil.getParameter(request_, paramName, defaultStr, pageEncoding);
    }
    /**
     * ڡʸʥڡIDư
     */
    public String getContents() throws IOException
    {
        if (isEditable() || isDeletable())
        {
            return "";
        }
        else
        {
            return getContentsByString(pageData_.getText());
        }
    }

    /**
     * եޥåȥڡʸ
     **/
    public String getFormatContents() throws IOException
    {
        //format ǡ WikiData
        WikiData formatData = new WikiData(base_, "format", properties_);

        return getContentsByString(formatData.getText());
    }

    /**
     * ڡʸʸ
     */
    public String getContentsByString(String str) throws IOException
    {
        return replaceWiki(str);
    }

    /**
    * ڡʸʥڡID
    */
    public String getText() throws IOException
    {
        if (isEditable() || isDeletable())
        {
            return getParameter("mymsg");
        }
        else
        {
            return pageData_.getText();
        }
    }

    /**
    * DiffʸʥڡID
    */
    public String getDiffText() throws IOException
    {
        if (isEditable() || isDeletable())
        {
            return getParameter("mymsg");
        }
        else
        {
            return MobWikiDiffPrint.diffHtml(getText(), pageData_.getDiffText());
        }
    }

    /**
     * ڡʸ
     */
    public String getStylePath() throws IOException
    {
        String fileName = properties_.getProperty(KEY_DEFAULT_STYLE);
        return "css/" + fileName + ".css";
    }

    /**
     * ֥ȥ
     */
    public String getSubtitle() throws IOException
    {
        if (isEditable() || isDeletable())
        {
            return "";
        }
        else
        {
            return pageData_.getSubtitle();
        }
    }

    public String getLastModified()
    {
        return pageData_.getLastModified();
    }

    /**
     * Actionμ
     */
    public String getAction()
    {
        String action = getParameter("wiki_action");
        String action_preview = getParameter("action_preview");
        String action_save = getParameter("action_save");
        if (!action_preview.equals(""))
        {
            action = "preview";
        }
        else if (!action_save.equals(""))
        {
            action = "save";
        }
        return action;
    }
    public boolean isEditable()
    {
        if (getAction().equals("create") || getAction().equals("new") || getAction().equals("preview"))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    public boolean isDeletable() throws IOException
    {
        if (getAction().equals("save") && getParameter("mymsg").equals(""))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    // ǽ
    public boolean isUpdatable() throws WikiException
    {
        String lastModified = getParameter("lastModified");
        String fileLastModified = String.valueOf(pageData_.getLastModified());
        return lastModified.equals(fileLastModified);
    }
    /**
     * Returns the properties.
     * @return CacheProperties
     */
    public String getProperty(String name)
    {
        return properties_.getProperty(name);
    }

}
