package jp.mobster.webapp.wiki;
import java.io.IOException;

import org.apache.commons.jrcs.diff.Diff;

import jp.mobster.util.StringUtil;
import jp.mobster.util.WebUtil;

public class MobWikiDiffPrint
{

    public static String diff(String str1, String str2) throws Exception
    {
        String[] a = StringUtil.split(str1, "\n");
        String[] b = StringUtil.split(str2, "\n");

        return diff(a, b);
    }
    public static String diff(String[] a, String[] b) throws Exception
    {
        String result = Diff.diff(a, b).toString();
        result = StringUtil.replace(result, "\r\n", "\n");
        return result;
    }

    public static String diffHtml(String str2, String diff)
    {
        String datas[] = StringUtil.split(diff, "\n");
        String[] newStrings = StringUtil.split(str2, "\n");
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        boolean isFirst = true;
        for (int i = 0; i < datas.length; i++)
        {
            String data = datas[i];
            if (data == null || data.length() == 0)
                continue;
            char c = data.charAt(0);
            if (c == '>')
            {
                buffer.append("<span class=\"add\">");
                buffer.append(WebUtil.escapeChar(data));
                buffer.append("</span>");
                buffer.append("<br>\n");
                isFirst = false;
            }
            else if (c == '<')
            {
                buffer.append("<span class=\"delete\">");
                buffer.append(WebUtil.escapeChar(data));
                buffer.append("</span>");
                buffer.append("<br>\n");
            }
            else if (c == '-')
            {
                // ⤷ʤ
            }
            else
            {
                String[] line = null;
                if (data.indexOf('c') != -1)
                {
                    line = StringUtil.split(data, "c");
                }
                else if (data.indexOf('d') != -1)
                {
                    line = StringUtil.split(data, "d");
                }
                else if (data.indexOf("a") != -1)
                {
                    line = StringUtil.split(data, "a");
                }
                String[] oldTextIndexs = StringUtil.split(line[0], ",");
                String[] newTextIndexs = StringUtil.split(line[1], ",");
                int changeOldStartLine = Integer.parseInt(oldTextIndexs[0].trim());
                int changeStartLine = Integer.parseInt(newTextIndexs[0].trim());
                int max = changeStartLine;
                //				if(changeOldStartLine != 0) {
                //						isFirst = false;
                //				}
                if (changeOldStartLine > 1)
                {
                    if (isFirst && changeOldStartLine != 0)
                    {
                        max = max + 1;
                        isFirst = false;
                    }
                    for (int j = index; j < max - 1; j++)
                    {
                        buffer.append(newStrings[j]);
                        buffer.append("<br>\n");
                    }
                }
                index = newTextIndexs.length == 1 ? changeStartLine : Integer.parseInt(newTextIndexs[1].trim());
            }
        }
        for (int j = index; j < newStrings.length; j++)
        {
            buffer.append(newStrings[j]);
            buffer.append("<br>\n");
        }
        return buffer.toString();
    }

    public static void main(String[] argv) throws IOException
    {
        String str1 = "1\n2\n3\n4\n5\n6\n7\n8";
        String str2 = "1\n4\nadd1\n5\n6\n7mod\n8";
        String diff = "";
        try
        {
            diff = diff(str1, str2);
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        System.out.println(diff);
        String html = diffHtml(str2, diff);
        System.out.println("--------------------------------");
        System.out.println(html);
    }

    /**
     * Method parseLineNumber.
     * @param string
     * @return int[]
     */
    private static int[] parseLineNumber(String line)
    {
        String[] linesStr = StringUtil.split(line, ",");
        int[] lines = new int[linesStr.length];
        for (int i = 0; i < linesStr.length; i++)
        {
            lines[i] = Integer.parseInt(linesStr[i]);
        }
        return lines;
    }

}