package jp.mobster.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * TimeUtil
 * 
 * @author <a href="mailto:uqn87055@alles.or.jp">Takashi Kodama</a>
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:23:46 $
 */
public class TimeUtil
{

    /** ʸ󥿥 ڤʸ */
    public final static String SEP_COLON = ":";
    /** ʸ󥿥 ڤʸ */
    public final static String SEP_SPACE = " ";
    /** ʸ󥿥 ڤʸ */
    public final static String SEP_BAR = "-";
    /** ʸ󥿥 ڤʸ */
    public final static String SEP_SLASH = "/";

    /** ʸ󥿥 :ʬ: */
    public final static int HHMMSS_COLON = 0;
    /** ʸ󥿥 /ʬ/ */
    public final static int HHMMSS_SLASH = 1;
    /** ʸ󥿥 -ʬ- */
    public final static int HHMMSS_BAR = 2;
    /** ʸ󥿥  ʬ  */
    public final static int HHMMSS_SPACE = 3;
    /** ʸ󥿥 :ʬ: */
    public final static int HHMMSS = HHMMSS_COLON;

    /** ʸ󥿥 ǯ(4):: */
    public final static int YYYYMMDD_COLON = 10;
    /** ʸ󥿥 ǯ(4)// */
    public final static int YYYYMMDD_SLASH = 11;
    /** ʸ󥿥 ǯ(4)-- */
    public final static int YYYYMMDD_BAR = 12;
    /** ʸ󥿥 ǯ(4)   */
    public final static int YYYYMMDD_SPACE = 13;
    /** ʸ󥿥 ǯ(4)// */
    public final static int YYYYMMDD = YYYYMMDD_SLASH;

    /** ʸ󥿥 ǯ(4):: :ʬ: */
    public final static int YYYYMMDD_HHMMSS_COLON = 20;
    /** ʸ󥿥 ǯ(4)// /ʬ/ */
    public final static int YYYYMMDD_HHMMSS_SLASH = 21;
    /** ʸ󥿥 ǯ(4)-- -ʬ- */
    public final static int YYYYMMDD_HHMMSS_BAR = 22;
    /** ʸ󥿥 ǯ(4)    ʬ  */
    public final static int YYYYMMDD_HHMMSS_SPACE = 23;
    /** ʸ󥿥 ǯ(4)// :ʬ: */
    public final static int YYYYMMDD_HHMMSS = 24;

    /**
     * ߤդTimestampǼ
     */
    static public Timestamp getNowTimestamp()
    {
        Calendar cal = Calendar.getInstance();
        return new Timestamp(_getTimeInMillis(cal));
    }

    /**
     * ߤդCalendarǼ
     */
    static public Calendar getNowCalendar()
    {
        return Calendar.getInstance();
    }

    /**
     * ߤդDateǼ
     */
    static public Date getNowDate()
    {
        Calendar cal = Calendar.getInstance();
        return cal.getTime();
    }

    /**
     * ߤդTimeǼ
     */
    static public Time getNowTime()
    {
        Calendar cal = Calendar.getInstance();
        long lTime = _getTimeInMillis(cal);
        return new Time(lTime);
    }

    /**
     * Timestamp  Date Ѵ
     */
    static public Date Timestamp2Date(Timestamp time)
    {
        long lTime = time.getTime();
        return new Date(lTime);
    }

    /**
     * Timestamp  Time Ѵ
     */
    static public Time Timestamp2Time(Timestamp time)
    {
        long lTime = time.getTime();
        return new Time(lTime);
    }

    /**
     * Timestamp  Calendar Ѵ
     */
    static public Calendar Timestamp2Calendar(Timestamp time)
    {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time.getTime()));
        return cal;
    }

    /**
     *  Date  Timestamp Ѵ
     */
    static public Timestamp Date2Timestamp(Date date)
    {
        long lTime = date.getTime();
        return new Timestamp(lTime);
    }

    /**
     *  Date  Calendar Ѵ
     */
    static public Calendar Date2Calendar(Date date)
    {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    /**
     *  Date  Time Ѵ
     */
    static public Time Date2Time(Date date)
    {
        long lTime = date.getTime();
        return new Time(lTime);
    }

    /**
     *  Calendar  Timestamp Ѵ
     */
    static public Timestamp Calendar2Timestamp(Calendar cal)
    {
        return new Timestamp(_getTimeInMillis(cal));
    }

    /**
     *  Calendar  DateѴ
     */
    static public Date Calendar2Date(Calendar cal)
    {
        return cal.getTime();
    }

    /**
     *  Calendar  Time Ѵ
     */
    static public Time Calendar2Time(Calendar cal)
    {
        return new Time(_getTimeInMillis(cal));
    }

    /**
     *  Time  Timestamp Ѵ
     */
    static public Timestamp Time2Timestamp(Time time)
    {
        return new Timestamp(time.getTime());
    }

    /**
     *  Time  DateѴ (Time  Date ηѾ Ѵ᥽åɬפʤ)
     */
    static public Date Time2Date(Time time)
    {
        return time;
    }

    /**
     *  Time  Calendar Ѵ
     */
    static public Calendar Time2Calendar(Time time)
    {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return cal;
    }

    static public String getString(Time time, int type)
    {
        return getString(Time2Calendar(time), type);
    }

    static public String getString(Timestamp timestamp, int type)
    {
        return getString(Timestamp2Calendar(timestamp), type);
    }

    static public String getString(Date date, int type)
    {
        return getString(Date2Calendar(date), type);
    }

    static public String getString(Calendar cal, int type)
    {
        return getStringFromType(
            type,
            cal.get(Calendar.YEAR),
            cal.get(Calendar.MONTH),
            cal.get(Calendar.DAY_OF_MONTH),
            cal.get(Calendar.HOUR_OF_DAY),
            cal.get(Calendar.MINUTE),
            cal.get(Calendar.SECOND));
    }

    /**
     * եޥåȤ򸵤 ֤ʸ롣
     *   format {0}:ǯ {1}: {2}: {3}: {4}:ʬ {5}: {6}:
     * @param cal     
     * @param format  Ѵեޥåʸ
     * @return   եޥåȤ˱äʸ
     */
    static public String getString(Calendar cal, String format)
    {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(createTimeString(cal));
    }

    /**
     * եޥåȤ򸵤 ֤ʸ롣
     *   format {0}:ǯ {1}: {2}: {3}: {4}:ʬ {5}: {6}:
     * @param date     Date
     * @param format  Ѵեޥåʸ
     * @return   եޥåȤ˱äʸ
     */
    static public String getString(Date date, String format)
    {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(createTimeString(Date2Calendar(date)));
    }

    /**
     * եޥåȤ򸵤 ֤ʸ롣
     *   format {0}:ǯ {1}: {2}: {3}: {4}:ʬ {5}: {6}:
     * @param time     Time
     * @param format  Ѵեޥåʸ
     * @return   եޥåȤ˱äʸ
     */
    static public String getString(Time time, String format)
    {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(createTimeString(Time2Calendar(time)));
    }

    /**
     * եޥåȤ򸵤 ֤ʸ롣
     *   format {0}:ǯ {1}: {2}: {3}: {4}:ʬ {5}: {6}:
     * @param stamp     Timestamp
     * @param format  Ѵեޥåʸ
     * @return   եޥåȤ˱äʸ
     */
    static public String getString(Timestamp stamp, String format)
    {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(createTimeString(Timestamp2Calendar(stamp)));
    }

    /**
     * եޥåȤ򸵤 ֤ʸ롣
     *   format {0}:ǯ {1}: {2}: {3}: {4}:ʬ {5}: {6}:
     * @param cal     
     * @param format  Ѵեޥåʸ
     * @param nWeekType    (0:ʸ 1:ƬʸΤʸ 2:άʸ)
     * @return   եޥåȤ˱äʸ
     */
    static public String getString(Calendar cal, String format, int nWeekType)
    {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(createTimeString(cal, nWeekType));
    }

    /**
     * եޥåȤ򸵤 ֤ʸ롣
     *   format {0}:ǯ {1}: {2}: {3}: {4}:ʬ {5}: {6}:
     * @param date     Date
     * @param format  Ѵեޥåʸ
     * @param nWeekType    (0:ʸ 1:ƬʸΤʸ 2:άʸ)
     * @return   եޥåȤ˱äʸ
     */
    static public String getString(Date date, String format, int nWeekType)
    {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(createTimeString(Date2Calendar(date), nWeekType));
    }

    /**
     * եޥåȤ򸵤 ֤ʸ롣
     *   format {0}:ǯ {1}: {2}: {3}: {4}:ʬ {5}: {6}:
     * @param time     Time
     * @param format  Ѵեޥåʸ
     * @param nWeekType    (0:ʸ 1:ƬʸΤʸ 2:άʸ)
     * @return   եޥåȤ˱äʸ
     */
    static public String getString(Time time, String format, int nWeekType)
    {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(createTimeString(Time2Calendar(time), nWeekType));
    }

    /**
     * եޥåȤ򸵤 ֤ʸ롣
     *   format {0}:ǯ {1}: {2}: {3}: {4}:ʬ {5}: {6}:
     * @param stamp     Timestamp
     * @param format  Ѵեޥåʸ
     * @param nWeekType    (0:ʸ 1:ƬʸΤʸ 2:άʸ)
     * @return   եޥåȤ˱äʸ
     */
    static public String getString(Timestamp stamp, String format, int nWeekType)
    {
        MessageFormat mesg = new MessageFormat(format);
        return mesg.format(createTimeString(Timestamp2Calendar(stamp), nWeekType));
    }

    /**
     * ֤ (ƬʸΤʸǼ)
     * @param cal         饹
     * @return ֤ʸ
     */
    private final static String[] createTimeString(Calendar cal)
    {
        return createTimeString(cal, 1);
    }

    /**
     * ֤
     * @param cal         饹
     * @param nWeekType    (0:ʸ 1:ƬʸΤʸ 2:άʸ)
     * @return ֤ʸ
     */
    private final static String[] createTimeString(Calendar cal, int nWeekType)
    {
        String[] timeString = new String[7];
        timeString[0] = String.valueOf(cal.get(Calendar.YEAR));
        timeString[1] = String.valueOf(cal.get(Calendar.MONTH));
        timeString[2] = String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
        timeString[3] = String.valueOf(cal.get(Calendar.HOUR_OF_DAY));
        timeString[4] = String.valueOf(cal.get(Calendar.MINUTE));
        timeString[5] = String.valueOf(cal.get(Calendar.SECOND));
        timeString[6] = getWeekString(cal.get(Calendar.DAY_OF_WEEK), nWeekType);
        return timeString;
    }

    /**
     * οʸǸ
     * @param type  ʸ  0:ʸ 1:ƬʸΤʸ 2:άʸ
     * @return  ʸ
     */
    public static String getWeekString(int nWeek, int type)
    {
        String sWeek = new String();
        switch (nWeek)
        {
            case 1 :
                sWeek = (type == 0) ? "SUNDAY" : (type == 1) ? "Sunday" : "Sun";
                break;
            case 2 :
                sWeek = (type == 0) ? "MONDAY" : (type == 1) ? "Monday" : "Mon";
                break;
            case 3 :
                sWeek = (type == 0) ? "TUESDAY" : (type == 1) ? "Tuesday" : "Tue";
                break;
            case 4 :
                sWeek = (type == 0) ? "WEDNSDAY" : (type == 1) ? "Wednsday" : "Wed";
                break;
            case 5 :
                sWeek = (type == 0) ? "THURSDAY" : (type == 1) ? "Thursday" : "Thu";
                break;
            case 6 :
                sWeek = (type == 0) ? "FRIDAY" : (type == 1) ? "Friday" : "Fri";
                break;
            case 7 :
                sWeek = (type == 0) ? "SATURDAY" : (type == 1) ? "Saturday" : "Sat";
                break;
        }

        return sWeek;

    }

    /**
     * 롣
     *     12/15-12/15  1Ȥ롣
     *     12/15-12/16  2Ȥ롣
     * @param start Calendar 
     * @param end   Calendar λ
     * @return int  
     */
    static public int getDays(Calendar start, Calendar end)
    {

        Calendar startC = Calendar.getInstance();
        startC.set(start.get(Calendar.YEAR), start.get(Calendar.MONTH), start.get(Calendar.DAY_OF_MONTH));

        Calendar endC = Calendar.getInstance();
        endC.set(end.get(Calendar.YEAR), end.get(Calendar.MONTH), end.get(Calendar.DAY_OF_MONTH));

        // ׻
        long nTime = endC.getTime().getTime() - startC.getTime().getTime();
        return (int) (nTime / (1000 * 60 * 60 * 24)) + 1;
    }

    private final static String getStringFromType(int nType, int year, int mon, int day, int h, int min, int sec)
    {
        StringBuffer dateString = new StringBuffer();
        int[] nYear = new int[3];
        int[] nDate = new int[3];
        switch (nType)
        {
            case HHMMSS_BAR :
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_BAR));
                break;
            case HHMMSS_COLON :
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_COLON));
                break;
            case HHMMSS_SLASH :
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_SLASH));
                break;
            case HHMMSS_SPACE :
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_SPACE));
                break;
            case YYYYMMDD_COLON :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_COLON));
                break;
            case YYYYMMDD_SLASH :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_SLASH));
                break;
            case YYYYMMDD_SPACE :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_SPACE));
                break;
            case YYYYMMDD_BAR :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_BAR));
                break;
            case YYYYMMDD_HHMMSS :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_SLASH));
                dateString.append(" ");
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_COLON));
                break;
            case YYYYMMDD_HHMMSS_COLON :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_COLON));
                dateString.append(" ");
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_COLON));
                break;
            case YYYYMMDD_HHMMSS_BAR :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_BAR));
                dateString.append(" ");
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_BAR));
                break;
            case YYYYMMDD_HHMMSS_SLASH :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_SLASH));
                dateString.append(" ");
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_SLASH));
                break;
            case YYYYMMDD_HHMMSS_SPACE :
                nYear[0] = year;
                nYear[1] = mon;
                nYear[2] = day;
                dateString.append(getStringSep(nYear, SEP_SPACE));
                dateString.append(" ");
                nDate[0] = h;
                nDate[1] = min;
                nDate[2] = sec;
                dateString.append(getStringSep(nDate, SEP_SPACE));
                break;
        }

        return dateString.toString();
    }

    /**
     * int ѥ졼Ϣ뤷String֤
     */
    private final static String getStringSep(int[] value, String sep)
    {
        StringBuffer buf = new StringBuffer();
        for (int count = 0; count < value.length; count++)
        {
            if (count != 0)
                buf.append(sep);
            buf.append(String.valueOf(value[count]));
        }
        return buf.toString();
    }

    /**
     * Calendar to long
     * @param cal
     * @return long
     */
    private static long _getTimeInMillis(Calendar cal)
    {
        return cal.getTime().getTime();
    }

}
