package jp.mobster.util;

import java.util.ArrayList;

/**
 * ʸϤΥ桼ƥƥ饹
 * 
 * @author <a href="mailto:agata@mobster.jp">Toshitaka Agata</a>
 * @author T.Yoshikai
 * @version $Revision: 1.1 $ $Date: 2003/09/10 14:23:46 $
 */

public class StringUtil
{
    /** ǥեȶڤʸ */
    private static final String DEFAULT_DELIM = ",";

    // join
    //--------------------------------------------------------------------------
    /**
     * ʸηʥ޶ڤǷ
     * @param str оʸ
     * @return ʸ
     */
    public static String join(String[] list)
    {

        return (join(list, DEFAULT_DELIM));

    }
    /**
     * ʸϢstrdelimϢ롣
     */
    public static String join(String[] str, String delim)
    {
        final int length = str.length;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; i++)
        {
            buf.append(str[i]);
            if (i != length - 1)
            {
                buf.append(delim);
            }
        }
        return new String(buf);
    }

    // repeat
    //--------------------------------------------------------------------------
    /**
     * strrepeatϢ뤷ʸֵ
     * @param str ʸ
     * @param repeat ʸϢ
     * @return Ϣʸ
     */
    public static String repeat(String str, int repeat)
    {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < repeat; i++)
        {
            buf.append(str);
        }
        return buf.toString();
    }
    /**
     * crepeatϢ뤷ʸֵ
     * @param c ʸ
     * @param repeat ʸϢ
     * @return Ϣʸ
     */
    public static String repeat(char c, int repeat)
    {
        return repeat(String.valueOf(c), repeat);
    }
    // spllit
    //--------------------------------------------------------------------------

    /**
     * ʸʬ(޶ڤ)
     * @param str оʸ
     * @return ʬʸ
     */
    public static String[] split(String str)
    {

        return (split(str, DEFAULT_DELIM));

    }
    /**
     * ʸʬʶڤʸ
     * @param str оʸ
     * @param str ڤʸ
     * @return ʬʸ
     */
    public static String[] split(String str, String delim)
    {

        final int delimLength = delim.length();
        int pos = 0;
        int index = 0;
        ArrayList list = new ArrayList();

        while ((index = str.indexOf(delim, pos)) != -1)
        {
            list.add(str.substring(pos, index));
            pos = index + delimLength;
        }
        list.add(str.substring(pos));

        return ((String[]) list.toArray(new String[0]));

    }

    // replaceNull
    //--------------------------------------------------------------------------
    /**
     * nullζʸؤִ<br>
     * ʸnullξ硢""ʶʸˤ֤ޤ
     * ʸnullǤʤ硢ʸ֤ޤ
     * @param str оݤʸ
     * @return ִʸ
     */
    public static String replaceNull(String str)
    {
        return (replaceNull(str, ""));
    }

    /**
     * nullλʸؤִ<br>
     * strnullξ硢newStr֤ޤ
     * ʸnullǤʤ硢str򤽤Τޤ֤ޤ
     * @param str оݤʸ
     * @param rep оݤʸ
     * @return ִʸ
     */
    public static String replaceNull(String str, String repStr)
    {
        return (str == null ? replaceNull(repStr) : str);
    }

    // ʬʸμФ
    //--------------------------------------------------------------------------
    /**
     * ʸαü顢ʸʬʸޤ<br>
     * @param str оݤʸ
     * @param n ʸ
     * @return ʸαünʬʸ
     */
    public static String right(String str, int n)
    {
        return str.substring(str.length() - n);
    }

    /**
     * ʸκü顢ʸʬʸޤ<br>
     * @param str оݤʸ
     * @param n ʸ
     * @return ʸκünʬʸ
     */
    public static String left(String str, int n)
    {
        return str.substring(0, n);
    }

    /**
     * ʸλ֤ˡ̤ʸޤ<br>
     * @param str оݤʸ
     * @param offset 
     * @param insertStr ʸ
     * @return ʸ
     */
    public static String insert(String str, int offset, String insertStr)
    {
        StringBuffer buffer = new StringBuffer(str);
        buffer.insert(offset, insertStr);
        return buffer.toString();
    }

    // trim
    //--------------------------------------------------------------------------
    /**
     * ʸ󤫤0ޤ<br>
     * @param str оݤʸ
     * @return ʸ
     */
    public static String trimZero(String str)
    {
        return trim(str, '0');
    }

    /**
     * ʸtrim򤪤ʤޤ<br>
     * @param str оݤʸ
     * @param c ʸ
     * @return ʸ
     */
    public static String trim(String str, char c)
    {
        int startIndex = 0;
        while (str.charAt(startIndex) == c)
        {
            startIndex++;
        }

        int lastIndex = str.length() - 1;
        while (str.charAt(lastIndex) == c)
        {
            lastIndex--;
        }
        return str.substring(startIndex, lastIndex + 1);
    }

    /**
     * strƤoldStrʸnewStrִޤ<br>
     * @param str оݤʸ
     * @param oldStr ִоʸ
     * @param newStr ִʸ
     * @return ʸ
     */
    public static String replace(String str, String oldStr, String newStr)
    {
        return replace(str, oldStr, newStr, 0, str.length());
    }

    /**
     * ʸλϰʸ֤Ԥޤ
     * ʸ֤оʸ󤬤ʤʸĹ֤оݤȤ
     * startOffset礭ϤΤޤ޸ʸ֤ޤ
     * @param str Ȥʤʸ
     * @param oldStr ֤оʸ
     * @param newStr ֤ʸ
     * @param int startOffset ִϰ
     * @param int endOffset ִλ
     */
    public static String replace(String str, String oldStr, String newStr, int startOffset, int endOffset)
    {
        final String subStr = str.substring(0, endOffset);
        StringBuffer buffer = new StringBuffer(str.substring(0, startOffset));
        int pos = startOffset;
        int oldPos = pos;
        while (oldPos <= endOffset && (pos = subStr.indexOf(oldStr, oldPos)) != -1)
        {
            buffer.append(subStr.substring(oldPos, pos));
            buffer.append(newStr);
            oldPos = pos + oldStr.length();
        }
        buffer.append(str.substring(oldPos));
        return buffer.toString();
    }

    // ʸ¸ߤ뤫ɤΥå
    //--------------------------------------------------------------------------
    /**
     * ʸ¸ߤ뤫ɤΥå<p>
     * ʸstr2Υ饯ʸstr1ˣʸǤޤޤƤ
     * true֤ޤ
     * @param str1 оݤʸ
     * @param str2 åʸ
     * @return ¸ߤtrue, ʳfalse
     */
    public static boolean containsChar(String str1, String str2)
    {
        for (int i = 0; i < str2.length(); i++)
        {
            if (str1.indexOf(str2.charAt(i)) != -1)
            {
                return true;
            }
        }
        return false;
    }
    /**
     * ʸ¸ߤ뤫ɤΥå<p>
     * 饯ʸʸstr1ˣʸǤޤޤƤ
     * true֤ޤ
     * @param str оݤʸ
     * @param c åʸ
     * @return ¸ߤtrue, ʳfalse
     */
    public static boolean containsChar(String str, char[] c)
    {
        for (int i = 0; i < c.length; i++)
        {
            if (str.indexOf(c[i]) != -1)
            {
                return true;
            }
        }
        return false;
    }

    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    /**
     * ե٥åȤΤߤǹʸ󤫤ɤȽ<p>
     * @param str оݤʸ
     * @return ե٥åȤΤߤʤtrue, ʳfalse
     */
    public static boolean isAlpha(String str)
    {
        for (int i = 0; i < str.length(); i++)
        {
            if (ALPHA.indexOf(str.charAt(i)) == -1)
            {
                return false;
            }
        }
        return true;
    }
    /**
     * ʸstrʸʲʤС˥ڡղä롣
     * @param str оݤʸ
     * @param length ʸ
     * @return ʸĹlengthȰ
     */
    public static String fillChar(String str, int length, char c)
    {
        final int count = length - str.length();
        if (count > 0)
        {
            return str + repeat(c, count);
        }
        else
        {
            return str;
        }
    }
    /**
     * ʸstrʸʲʤС˥ڡղä롣
     * @param str оݤʸ
     * @param length ʸ
     * @return ʸĹlengthȰ
     */
    public static String fillSpace(String str, int length)
    {
        return fillChar(str, length, ' ');
    }
    /**
     * ե̾å
     * ʸ˥ե̾ȤʸޤޤƤtrue֤ޤ<p>
     * @param str оݤʸ
     * @param str2 åʸ
     * @return ¸ߤtrue, ʳfalse
     */
    //	public static boolean isBadFileName(String str) {
    //		return false;
    //	}
}