package jp.mobster.util;

import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:agata@mobster.jp">Toshitaka Agata</a>
 * @author <a href="mailto:masanori@mobster.jp">Masanori Hashimoto</a>
 */
public class PageList
{

    private List list_ = new ArrayList();
    private int position_;
    private int max_;
    private int total_;

    /**
     * Constructor for pageList.
     */
    public PageList()
    {
    }

    /**
     * Method add Data.
     * @param bugData
     */
    public void addData(Object data)
    {
        list_.add(data);
    }

    /**
     * Returns the max.
     * @return int
     */
    public int getMax()
    {
        return max_;
    }

    /**
     * Returns the position.
     * @return int
     */
    public int getPosition()
    {
        return position_;
    }

    /**
     * Returns the total.
     * @return int
     */
    public int getTotal()
    {
        return total_;
    }

    /**
     * Sets the max.
     * @param max The max to set
     */
    public void setMax(int max)
    {
        max_ = max;
    }

    /**
     * Sets the position.
     * @param position The position to set
     */
    public void setPosition(int position)
    {
        position_ = position;
    }

    /**
     * Sets the total.
     * @param total The total to set
     */
    public void setTotal(int total)
    {
        total_ = total;
    }

    /**
     * Method size.
     * @return int
     */
    public int size()
    {
        return list_.size();
    }

    /**
     * Method isNext.
     * @return boolean
     */
    public boolean isNext()
    {
        return (position_ + max_ < total_ ? true : false);
    }

    /**
     * Method getNextPositon.
     * @return int
     */
    public int getNextPosition()
    {
        if (!isNext())
            return -1;
        return position_ + max_;
    }

    /**
     * Method isPrev.
     * @return boolean
     */
    public boolean isPrev()
    {
        if (total_ == 0 || position_ == 0)
            return false;
        return true;
    }

    /**
     * Method getPrevPositon.
     * @return int
     */
    public int getPrevPosition()
    {
        if (!isPrev())
            return -1;
        int prevPos = position_ - max_;
        return (prevPos > 0 ? prevPos : 0);
    }

    /**
     * Method get Data.
     * @return Object[]
     */
    public Object[] getData()
    {
        return list_.toArray(new Object[0]);
    }

    /**
     * Method get Data.
     * @return  data
     */
    public Object getData(int index)
    {
        return list_.get(index);
    }
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append("[size=" + list_.size() + "]");
        buffer.append("[position=" + position_ + "]");
        buffer.append("[max=" + max_ + "]");
        buffer.append("[total=" + total_ + "]");
        buffer.append("]");
        return buffer.toString();
    }

}
