/* ====================================================================================
 * Copyright (c) 2003, jetspeed-japan.sourceforge.jp
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright notice,
 *     * this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *     * notice, this list of conditions and the following disclaimer in the
 *     * documentation and/or other materials provided with the distribution.
 *     * Neither the name of the jetspeed-japan.sourceforge.jp nor the names 
 *       of its contributors
 *     * may be used to endorse or promote products derived from this software
 *     * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================================
 */
package com.marevol.portlet.modules.actions.portlets;

import org.apache.jetspeed.modules.actions.portlets.JspPortletAction;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;

import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;

import com.marevol.portlet.wiki.services.WikiUploadService;
import com.marevol.portlet.wiki.util.WikiUtil;

/**
 * This class is the portlet action to edit the Web Log messages.
 * 
 * @author <a href="mailto:shinsuke@yahoo.co.jp">Shinsuke Sugaya</a>
 */
public class WikiPortletAction extends JspPortletAction
{
    /**
     * Static initialization of the logger for this class
     */
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(WikiPortletAction.class.getName());

    /** 
     * Default behavior for the portlet action
     */
    protected void buildNormalContext(Portlet portlet, RunData rundata)
    {
        String url = DynamicURI.toString(rundata);
        int pos = url.indexOf("?");
        if (pos > -1)
        {
            rundata.getRequest().setAttribute(WikiUtil.CURRENT_PAGE, url.substring(0, pos));
        }
        else
        {
            rundata.getRequest().setAttribute(WikiUtil.CURRENT_PAGE, url);
        }
    }

    /**
     * Default Action for this portlet.
     * 
     * @param rundata
     * @param context
     */
    public void doWiki_index(RunData rundata, Portlet portlet)
    {
        setTemplate(rundata, WikiUtil.WIKI_INDEX_TEMPLATE);
    }

    /**
     * Search Action for this portlet.
     * 
     * @param rundata
     * @param context
     */
    public void doWiki_search(RunData rundata, Portlet portlet)
    {
        setTemplate(rundata, WikiUtil.WIKI_SEARCH_TEMPLATE);
    }

    /**
     * Diff Action for this portlet.
     * 
     * @param rundata
     * @param context
     */
    public void doWiki_diff(RunData rundata, Portlet portlet)
    {
        setTemplate(rundata, WikiUtil.WIKI_DIFF_TEMPLATE);
    }

    /**
     * Upload Action for this portlet.
     * 
     * @param rundata
     * @param context
     */
    public void doWiki_upload(RunData rundata, Portlet portlet)
    {
        setTemplate(rundata, WikiUtil.WIKI_UPLOAD_TEMPLATE);
    }

    /**
     * Upload Action for this portlet.
     * 
     * @param rundata
     * @param context
     */
    public void doWiki_store(RunData rundata, Portlet portlet)
    {
        if (!WikiUploadService.isInit())
        {
            WikiUploadService.init(rundata);
        }
        WikiUploadService.store(rundata);
        setTemplate(rundata, WikiUtil.WIKI_INDEX_TEMPLATE);
    }

}
