/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine.phases;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;

public class Collect
extends InstallableUnitPhase {
    private static final String PHASE_ID = "collect";
    public static final String PARM_ARTIFACT_REQUESTS = "artifactRequests";

    public Collect(int weight) {
        super(PHASE_ID, weight);
        this.prePerformWork = 0;
        this.mainPerformWork = 100;
        this.postPerformWork = 1000;
    }

    protected boolean isApplicable(InstallableUnitOperand op) {
        return op.second() != null && !op.second().equals((Object)op.first());
    }

    protected ProvisioningAction[] getActions(InstallableUnitOperand operand) {
        IInstallableUnit unit = operand.second();
        ProvisioningAction[] parsedActions = this.getActions(unit, this.phaseId);
        if (parsedActions != null) {
            return parsedActions;
        }
        ITouchpointType type = unit.getTouchpointType();
        if (type == null || type == ITouchpointType.NONE) {
            return null;
        }
        String actionId = this.getActionManager().getTouchpointQualifiedActionId(this.phaseId, type);
        ProvisioningAction action = this.getActionManager().getAction(actionId, null);
        if (action == null) {
            return null;
        }
        return new ProvisioningAction[]{action};
    }

    protected String getProblemMessage() {
        return Messages.Phase_Collect_Error;
    }

    protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        List artifactRequests = (List)parameters.get(PARM_ARTIFACT_REQUESTS);
        ProvisioningContext context = (ProvisioningContext)parameters.get("context");
        DownloadManager dm = new DownloadManager(context);
        Iterator it = artifactRequests.iterator();
        while (it.hasNext()) {
            IArtifactRequest[] requests = (IArtifactRequest[])it.next();
            dm.add(requests);
        }
        return dm.start(monitor);
    }

    protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map parameters) {
        parameters.put(PARM_ARTIFACT_REQUESTS, new ArrayList());
        return null;
    }
}

