/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.internal.p2.garbagecollector.MarkSet;
import org.eclipse.equinox.internal.p2.garbagecollector.MarkSetProvider;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Activator;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.WhatIsRunning;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.Feature;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseMarkSetProvider
extends MarkSetProvider {
    private static final String ARTIFACT_CLASSIFIER_OSGI_BUNDLE = "osgi.bundle";
    private static final String ARTIFACT_CLASSIFIER_FEATURE = "org.eclipse.update.feature";
    private Collection artifactKeyList = null;
    static /* synthetic */ Class class$0;

    public MarkSet[] getMarkSets(IProfile inProfile) {
        this.artifactKeyList = new HashSet();
        IFileArtifactRepository repositoryToGC = Util.getBundlePoolRepository(inProfile);
        if (repositoryToGC == null) {
            return new MarkSet[0];
        }
        this.addArtifactKeys(inProfile);
        IProfile currentProfile = this.getCurrentProfile();
        if (currentProfile != null && inProfile.getProfileId().equals(currentProfile.getProfileId())) {
            this.addRunningBundles((IArtifactRepository)repositoryToGC);
            this.addRunningFeatures(inProfile, (IArtifactRepository)repositoryToGC);
        }
        return new MarkSet[]{new MarkSet(this.artifactKeyList.toArray(new IArtifactKey[0]), (IArtifactRepository)repositoryToGC)};
    }

    private void addRunningFeatures(IProfile profile, IArtifactRepository repositoryToGC) {
        try {
            List allFeatures = this.getAllFeatures(Configuration.load(new File(Util.getConfigurationFolder(profile), "org.eclipse.update/platform.xml"), null));
            Iterator iterator = allFeatures.iterator();
            while (iterator.hasNext()) {
                Feature f = (Feature)iterator.next();
                IArtifactKey match = this.searchArtifact(f.getId(), new Version(f.getVersion()), ARTIFACT_CLASSIFIER_FEATURE, repositoryToGC);
                if (match == null) continue;
                this.artifactKeyList.add(match);
            }
        }
        catch (ProvisionException provisionException) {}
    }

    private List getAllFeatures(Configuration cfg) {
        if (cfg == null) {
            return Collections.EMPTY_LIST;
        }
        List sites = cfg.getSites();
        ArrayList<Feature> result = new ArrayList<Feature>();
        Iterator iterator = sites.iterator();
        while (iterator.hasNext()) {
            Site object = (Site)iterator.next();
            Feature[] features = object.getFeatures();
            int i = 0;
            while (i < features.length) {
                result.add(features[i]);
                ++i;
            }
        }
        return result;
    }

    private IProfile getCurrentProfile() {
        ServiceReference sr;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((sr = bundleContext.getServiceReference(clazz.getName())) == null) {
            return null;
        }
        IProfileRegistry pr = (IProfileRegistry)Activator.getContext().getService(sr);
        if (pr == null) {
            return null;
        }
        Activator.getContext().ungetService(sr);
        return pr.getProfile("_SELF_");
    }

    private void addArtifactKeys(IProfile aProfile) {
        Iterator installableUnits = aProfile.query((Query)InstallableUnitQuery.ANY, new Collector(), null).iterator();
        while (installableUnits.hasNext()) {
            IArtifactKey[] keys = ((IInstallableUnit)installableUnits.next()).getArtifacts();
            if (keys == null) continue;
            int i = 0;
            while (i < keys.length) {
                this.artifactKeyList.add(keys[i]);
                ++i;
            }
        }
    }

    public IArtifactRepository getRepository(IProfile aProfile) {
        return Util.getBundlePoolRepository(aProfile);
    }

    private void addRunningBundles(IArtifactRepository repo) {
        this.artifactKeyList.addAll(this.findCorrespondinArtifacts(new WhatIsRunning().getBundlesBeingRun(), repo));
    }

    private IArtifactKey searchArtifact(String searchedId, Version searchedVersion, String classifier, IArtifactRepository repo) {
        IArtifactKey[] keys = repo.getArtifactKeys();
        int i = 0;
        while (i < keys.length) {
            if (keys[i].getClassifier().equals(classifier)) {
                String id = keys[i].getId();
                Version v = keys[i].getVersion();
                if (id != null && id.equals(searchedId) && v != null && v.equals((Object)searchedVersion)) {
                    return keys[i];
                }
            }
            ++i;
        }
        return null;
    }

    private ArrayList findCorrespondinArtifacts(BundleInfo[] bis, IArtifactRepository repo) {
        ArrayList<IArtifactKey> toRetain = new ArrayList<IArtifactKey>();
        int i = 0;
        while (i < bis.length) {
            IArtifactKey match = this.searchArtifact(bis[i].getSymbolicName(), new Version(bis[i].getVersion()), ARTIFACT_CLASSIFIER_OSGI_BUNDLE, repo);
            if (match != null) {
                toRetain.add(match);
            }
            ++i;
        }
        return toRetain;
    }
}

