/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.director;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.osgi.framework.BundleContext;

public class ProfileChangeRequest
implements Cloneable {
    private final IProfile profile;
    private ArrayList iusToRemove = null;
    private ArrayList iusToAdd = null;
    private ArrayList propertiesToRemove = null;
    private HashMap propertiesToAdd = null;
    private HashMap iuPropertiesToAdd = null;
    private HashMap iuPropertiesToRemove = null;
    static /* synthetic */ Class class$0;

    public static ProfileChangeRequest createByProfileId(String profileId) {
        IProfileRegistry profileRegistry;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName())) == null) {
            throw new IllegalStateException(Messages.Planner_no_profile_registry);
        }
        IProfile profile = profileRegistry.getProfile(profileId);
        if (profile == null) {
            throw new IllegalArgumentException("Profile id " + profileId + " is not registered.");
        }
        return new ProfileChangeRequest(profile);
    }

    public ProfileChangeRequest(IProfile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("Profile cannot be null.");
        }
        this.profile = profile;
    }

    public IProfile getProfile() {
        return this.profile;
    }

    public Map getProfileProperties() {
        HashMap result = new HashMap(this.profile.getProperties());
        if (this.propertiesToRemove != null) {
            Iterator it = this.propertiesToRemove.iterator();
            while (it.hasNext()) {
                result.remove(it.next());
            }
        }
        if (this.propertiesToAdd != null) {
            result.putAll(this.propertiesToAdd);
        }
        return result;
    }

    public void addInstallableUnits(IInstallableUnit[] toInstall) {
        if (this.iusToAdd == null) {
            this.iusToAdd = new ArrayList(toInstall.length);
        }
        int i = 0;
        while (i < toInstall.length) {
            this.iusToAdd.add(toInstall[i]);
            ++i;
        }
    }

    public void removeInstallableUnits(IInstallableUnit[] toUninstall) {
        if (this.iusToRemove == null) {
            this.iusToRemove = new ArrayList(toUninstall.length);
        }
        int i = 0;
        while (i < toUninstall.length) {
            this.iusToRemove.add(toUninstall[i]);
            ++i;
        }
    }

    public void setProfileProperty(String key, Object value) {
        if (this.propertiesToAdd == null) {
            this.propertiesToAdd = new HashMap();
        }
        this.propertiesToAdd.put(key, value);
    }

    public void removeProfileProperty(String key) {
        if (this.propertiesToRemove == null) {
            this.propertiesToRemove = new ArrayList(1);
        }
        this.propertiesToRemove.add(key);
    }

    public void setInstallableUnitProfileProperty(IInstallableUnit iu, String key, Object value) {
        HashMap<String, Object> properties;
        if (this.iuPropertiesToAdd == null) {
            this.iuPropertiesToAdd = new HashMap();
        }
        if ((properties = (HashMap<String, Object>)this.iuPropertiesToAdd.get(iu)) == null) {
            properties = new HashMap<String, Object>();
            this.iuPropertiesToAdd.put(iu, properties);
        }
        properties.put(key, value);
    }

    public void removeInstallableUnitProfileProperty(IInstallableUnit iu, String key) {
        ArrayList<String> keys;
        if (this.iuPropertiesToRemove == null) {
            this.iuPropertiesToRemove = new HashMap();
        }
        if ((keys = (ArrayList<String>)this.iuPropertiesToRemove.get(iu)) == null) {
            keys = new ArrayList<String>();
            this.iuPropertiesToRemove.put(iu, keys);
        }
        keys.add(key);
    }

    public IInstallableUnit[] getRemovedInstallableUnits() {
        if (this.iusToRemove == null) {
            return new IInstallableUnit[0];
        }
        return this.iusToRemove.toArray(new IInstallableUnit[this.iusToRemove.size()]);
    }

    public IInstallableUnit[] getAddedInstallableUnits() {
        if (this.iusToAdd == null) {
            return new IInstallableUnit[0];
        }
        return this.iusToAdd.toArray(new IInstallableUnit[this.iusToAdd.size()]);
    }

    public String[] getPropertiesToRemove() {
        if (this.propertiesToRemove == null) {
            return new String[0];
        }
        return this.propertiesToRemove.toArray(new String[this.propertiesToRemove.size()]);
    }

    public Map getPropertiesToAdd() {
        if (this.propertiesToAdd == null) {
            return Collections.EMPTY_MAP;
        }
        return this.propertiesToAdd;
    }

    public Map getInstallableUnitProfilePropertiesToRemove() {
        if (this.iuPropertiesToRemove == null) {
            return Collections.EMPTY_MAP;
        }
        return this.iuPropertiesToRemove;
    }

    public Map getInstallableUnitProfilePropertiesToAdd() {
        if (this.iuPropertiesToAdd == null) {
            return Collections.EMPTY_MAP;
        }
        return this.iuPropertiesToAdd;
    }

    public void setInstallableUnitInclusionRules(IInstallableUnit iu, String value) {
        HashMap<String, String> properties;
        if (this.iuPropertiesToAdd == null) {
            this.iuPropertiesToAdd = new HashMap();
        }
        if ((properties = (HashMap<String, String>)this.iuPropertiesToAdd.get(iu)) == null) {
            properties = new HashMap<String, String>();
            this.iuPropertiesToAdd.put(iu, properties);
        }
        properties.put("org.eclipse.equinox.p2.internal.inclusion.rules", value);
    }

    public void removeInstallableUnitInclusionRules(IInstallableUnit iu) {
        ArrayList<String> keys;
        if (this.iuPropertiesToRemove == null) {
            this.iuPropertiesToRemove = new HashMap();
        }
        if ((keys = (ArrayList<String>)this.iuPropertiesToRemove.get(iu)) == null) {
            keys = new ArrayList<String>();
            this.iuPropertiesToRemove.put(iu, keys);
        }
        keys.add("org.eclipse.equinox.p2.internal.inclusion.rules");
    }

    public Object clone() {
        ProfileChangeRequest result = new ProfileChangeRequest(this.profile);
        result.iusToRemove = this.iusToRemove == null ? null : (ArrayList)this.iusToRemove.clone();
        result.iusToAdd = this.iusToAdd == null ? null : (ArrayList)this.iusToAdd.clone();
        result.propertiesToRemove = this.propertiesToRemove == null ? null : (ArrayList)this.propertiesToRemove.clone();
        result.propertiesToAdd = this.propertiesToAdd == null ? null : (HashMap)this.propertiesToAdd.clone();
        result.iuPropertiesToAdd = this.iuPropertiesToAdd == null ? null : (HashMap)this.iuPropertiesToAdd.clone();
        result.iuPropertiesToRemove = this.iuPropertiesToRemove == null ? null : (HashMap)this.iuPropertiesToRemove.clone();
        return result;
    }
}

