/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MCHITTESTINFO;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SYSTEMTIME;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    boolean doubleClick;
    boolean ignoreSelection;
    SYSTEMTIME lastSystemTime;
    SYSTEMTIME time = new SYSTEMTIME();
    static final long DateTimeProc;
    static final TCHAR DateTimeClass;
    static final long CalendarProc;
    static final TCHAR CalendarClass;
    static final int MARGIN = 4;
    static final int MAX_DIGIT = 9;
    static final int MAX_DAY = 31;
    static final int MAX_12HOUR = 12;
    static final int MAX_24HOUR = 24;
    static final int MAX_MINUTE = 60;
    static final int MONTH_DAY_YEAR = 0;
    static final int DAY_MONTH_YEAR = 1;
    static final int YEAR_MONTH_DAY = 2;
    static final char SINGLE_QUOTE = '\'';
    static final char DAY_FORMAT_CONSTANT = 'd';
    static final char MONTH_FORMAT_CONSTANT = 'M';
    static final char YEAR_FORMAT_CONSTANT = 'y';
    static final char HOURS_FORMAT_CONSTANT = 'h';
    static final char MINUTES_FORMAT_CONSTANT = 'm';
    static final char SECONDS_FORMAT_CONSTANT = 's';
    static final char AMPM_FORMAT_CONSTANT = 't';
    static final int[] MONTH_NAMES;

    static {
        DateTimeClass = new TCHAR(0, "SysDateTimePick32", true);
        CalendarClass = new TCHAR(0, "SysMonthCal32", true);
        INITCOMMONCONTROLSEX icex = new INITCOMMONCONTROLSEX();
        icex.dwSize = INITCOMMONCONTROLSEX.sizeof;
        icex.dwICC = 256;
        OS.InitCommonControlsEx(icex);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, DateTimeClass, lpWndClass);
        DateTimeProc = lpWndClass.lpfnWndProc;
        long hInstance = OS.GetModuleHandle(null);
        long hHeap = OS.GetProcessHeap();
        lpWndClass.hInstance = hInstance;
        lpWndClass.style &= 0xFFFFBFFF;
        lpWndClass.style |= 8;
        int byteCount = DateTimeClass.length() * TCHAR.sizeof;
        long lpszClassName = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(lpszClassName, DateTimeClass, byteCount);
        lpWndClass.lpszClassName = lpszClassName;
        OS.RegisterClass(lpWndClass);
        OS.HeapFree(hHeap, 0, lpszClassName);
        lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, CalendarClass, lpWndClass);
        CalendarProc = lpWndClass.lpfnWndProc;
        hInstance = OS.GetModuleHandle(null);
        hHeap = OS.GetProcessHeap();
        lpWndClass.hInstance = hInstance;
        lpWndClass.style &= 0xFFFFBFFF;
        lpWndClass.style |= 8;
        byteCount = CalendarClass.length() * TCHAR.sizeof;
        lpszClassName = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(lpszClassName, CalendarClass, byteCount);
        lpWndClass.lpszClassName = lpszClassName;
        OS.RegisterClass(lpWndClass);
        OS.HeapFree(hHeap, 0, lpszClassName);
        MONTH_NAMES = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
    }

    public DateTime(Composite parent, int style) {
        super(parent, DateTime.checkStyle(style));
        if ((this.style & 0x8000) != 0) {
            String buffer = (this.style & 0x20) != 0 ? this.getCustomShortDateFormat() : this.getCustomShortTimeFormat();
            TCHAR lpszFormat = new TCHAR(0, buffer, true);
            OS.SendMessage(this.handle, OS.DTM_SETFORMAT, 0L, lpszFormat);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.CallWindowProc(this.windowProc(), hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFFCFF;
        style = DateTime.checkBits(style, 32, 128, 1024, 0, 0, 0);
        if (((style = DateTime.checkBits(style, 65536, 32768, 0x10000000, 0, 0, 0)) & 0x20) == 0) {
            style &= 0xFFFFFFFB;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1 || hHint == -1) {
            if ((this.style & 0x400) != 0) {
                RECT rect = new RECT();
                OS.SendMessage(this.handle, 4105, 0L, rect);
                width = rect.right;
                height = rect.bottom;
            } else {
                TCHAR buffer = new TCHAR(this.getCodePage(), 128);
                long oldFont = 0L;
                long hDC = OS.GetDC(this.handle);
                long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
                if (newFont != 0L) {
                    oldFont = OS.SelectObject(hDC, newFont);
                }
                RECT rect = new RECT();
                int flags = 11264;
                SYSTEMTIME systime = new SYSTEMTIME();
                if ((this.style & 0x20) != 0) {
                    int size;
                    systime.wMonth = 1;
                    systime.wDay = 1;
                    int widest = 0;
                    int secondWidest = 0;
                    int thirdWidest = 0;
                    int i = 0;
                    while (i <= 9) {
                        systime.wYear = (short)(2000 + i);
                        int size2 = OS.GetDateFormat(1024, 1, systime, null, buffer, buffer.length());
                        if (size2 == 0) {
                            buffer = new TCHAR(this.getCodePage(), size2);
                            OS.GetDateFormat(1024, 1, systime, null, buffer, buffer.length());
                        }
                        rect.bottom = 0;
                        rect.right = 0;
                        rect.top = 0;
                        rect.left = 0;
                        OS.DrawText(hDC, buffer, size2, rect, flags);
                        if (rect.right - rect.left >= width) {
                            width = rect.right - rect.left;
                            thirdWidest = secondWidest;
                            secondWidest = widest;
                            widest = i;
                        }
                        height = Math.max(height, rect.bottom - rect.top);
                        ++i;
                    }
                    widest = widest > 1 ? widest * 1000 + widest * 100 + widest * 10 + widest : (secondWidest > 1 ? secondWidest * 1000 + widest * 100 + widest * 10 + widest : thirdWidest * 1000 + widest * 100 + widest * 10 + widest);
                    systime.wYear = (short)widest;
                    widest = 0;
                    width = 0;
                    i = 0;
                    while (i < MONTH_NAMES.length) {
                        int name = MONTH_NAMES[i];
                        size = OS.GetLocaleInfo(1024, name, buffer, buffer.length());
                        if (size == 0) {
                            buffer = new TCHAR(this.getCodePage(), size);
                            OS.GetLocaleInfo(1024, name, buffer, buffer.length());
                        }
                        rect.bottom = 0;
                        rect.right = 0;
                        rect.top = 0;
                        rect.left = 0;
                        OS.DrawText(hDC, buffer, size, rect, flags);
                        if (rect.right - rect.left > width) {
                            width = rect.right - rect.left;
                            widest = i;
                        }
                        height = Math.max(height, rect.bottom - rect.top);
                        i = (short)(i + 1);
                    }
                    systime.wMonth = (short)(widest + 1);
                    int dwFlags = (this.style & 0x10000) != 0 ? 1 : ((this.style & 0x8000) != 0 ? 8 : 2);
                    width = 0;
                    int i2 = 1;
                    while (i2 <= 31) {
                        systime.wDay = (short)i2;
                        size = OS.GetDateFormat(1024, dwFlags, systime, null, buffer, buffer.length());
                        if (size == 0) {
                            buffer = new TCHAR(this.getCodePage(), size);
                            OS.GetDateFormat(1024, dwFlags, systime, null, buffer, buffer.length());
                        }
                        rect.bottom = 0;
                        rect.right = 0;
                        rect.top = 0;
                        rect.left = 0;
                        OS.DrawText(hDC, buffer, size, rect, flags);
                        width = Math.max(width, rect.right - rect.left);
                        height = Math.max(height, rect.bottom - rect.top);
                        if ((this.style & 0x8000) == 0) {
                            i2 = (short)(i2 + 1);
                            continue;
                        }
                        break;
                    }
                } else if ((this.style & 0x80) != 0) {
                    int size;
                    int dwFlags = (this.style & 0x8000) != 0 ? 2 : 0;
                    int widest = 0;
                    int max = this.is24HourTime() ? 24 : 12;
                    int i = 0;
                    while (i < max) {
                        systime.wHour = (short)i;
                        size = OS.GetTimeFormat(1024, dwFlags, systime, null, buffer, buffer.length());
                        if (size == 0) {
                            buffer = new TCHAR(this.getCodePage(), size);
                            OS.GetTimeFormat(1024, dwFlags, systime, null, buffer, buffer.length());
                        }
                        rect.bottom = 0;
                        rect.right = 0;
                        rect.top = 0;
                        rect.left = 0;
                        OS.DrawText(hDC, buffer, size, rect, flags);
                        if (rect.right - rect.left > width) {
                            width = rect.right - rect.left;
                            widest = i;
                        }
                        height = Math.max(height, rect.bottom - rect.top);
                        i = (short)(i + 1);
                    }
                    systime.wHour = widest;
                    widest = 0;
                    width = 0;
                    i = 0;
                    while (i < 60) {
                        systime.wMinute = (short)i;
                        size = OS.GetTimeFormat(1024, dwFlags, systime, null, buffer, buffer.length());
                        if (size == 0) {
                            buffer = new TCHAR(this.getCodePage(), size);
                            OS.GetTimeFormat(1024, dwFlags, systime, null, buffer, buffer.length());
                        }
                        rect.bottom = 0;
                        rect.right = 0;
                        rect.top = 0;
                        rect.left = 0;
                        OS.DrawText(hDC, buffer, size, rect, flags);
                        if (rect.right - rect.left > width) {
                            width = rect.right - rect.left;
                            widest = i;
                        }
                        height = Math.max(height, rect.bottom - rect.top);
                        i = (short)(i + 1);
                    }
                    systime.wMinute = widest;
                    systime.wSecond = widest;
                    int size3 = OS.GetTimeFormat(1024, dwFlags, systime, null, buffer, buffer.length());
                    if (size3 == 0) {
                        buffer = new TCHAR(this.getCodePage(), size3);
                        OS.GetTimeFormat(1024, dwFlags, systime, null, buffer, buffer.length());
                    }
                    rect.bottom = 0;
                    rect.right = 0;
                    rect.top = 0;
                    rect.left = 0;
                    OS.DrawText(hDC, buffer, size3, rect, flags);
                    width = rect.right - rect.left;
                    height = Math.max(height, rect.bottom - rect.top);
                }
                if (newFont != 0L) {
                    OS.SelectObject(hDC, oldFont);
                }
                OS.ReleaseDC(this.handle, hDC);
                int upDownWidth = OS.GetSystemMetrics(2);
                int upDownHeight = OS.GetSystemMetrics(20);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    upDownHeight += 7;
                    if ((this.style & 4) != 0) {
                        upDownWidth += 16;
                    }
                }
                width += upDownWidth + 4;
                height = Math.max(height, upDownHeight);
            }
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if ((this.style & 0x800) == 0) {
            int bits = OS.GetWindowLong(this.handle, -20);
            OS.SetWindowLong(this.handle, -20, bits &= 0xFFFDFDFF);
        }
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    String getComputeSizeString() {
        if ((this.style & 0x20) != 0) {
            if ((this.style & 0x8000) != 0) {
                return this.getCustomShortDateFormat();
            }
            if ((this.style & 0x10000) != 0) {
                return this.getShortDateFormat();
            }
            if ((this.style & 0x10000000) != 0) {
                return this.getLongDateFormat();
            }
        }
        if ((this.style & 0x80) != 0) {
            if ((this.style & 0x8000) != 0) {
                return this.getCustomShortTimeFormat();
            }
            return this.getTimeFormat();
        }
        return "";
    }

    String getCustomShortDateFormat() {
        TCHAR tchar = new TCHAR(this.getCodePage(), 80);
        int size = OS.GetLocaleInfo(1024, 4102, tchar, 80);
        return size != 0 ? tchar.toString(0, size - 1) : "M/yyyy";
    }

    String getCustomShortTimeFormat() {
        StringBuffer buffer = new StringBuffer(this.getTimeFormat());
        int length = buffer.length();
        boolean inQuotes = false;
        int start = 0;
        int end = 0;
        while (start < length) {
            char ch = buffer.charAt(start);
            if (ch == '\'') {
                inQuotes = !inQuotes;
            } else if (ch == 's' && !inQuotes) {
                end = start + 1;
                while (end < length && buffer.charAt(end) == 's') {
                    ++end;
                }
                while (start > 0 && buffer.charAt(start) != 'm') {
                    --start;
                }
                ++start;
                break;
            }
            ++start;
        }
        if (start < end) {
            buffer.delete(start, end);
        }
        return buffer.toString();
    }

    String getLongDateFormat() {
        TCHAR tchar = new TCHAR(this.getCodePage(), 80);
        int size = OS.GetLocaleInfo(1024, 32, tchar, 80);
        return size > 0 ? tchar.toString(0, size - 1) : "dddd, MMMM dd, yyyy";
    }

    String getShortDateFormat() {
        TCHAR tchar = new TCHAR(this.getCodePage(), 80);
        int size = OS.GetLocaleInfo(1024, 31, tchar, 80);
        return size > 0 ? tchar.toString(0, size - 1) : "M/d/yyyy";
    }

    int getShortDateFormatOrdering() {
        TCHAR tchar = new TCHAR(this.getCodePage(), 4);
        int size = OS.GetLocaleInfo(1024, 33, tchar, 4);
        if (size > 0) {
            String number = tchar.toString(0, size - 1);
            return Integer.parseInt(number);
        }
        return 0;
    }

    String getTimeFormat() {
        TCHAR tchar = new TCHAR(this.getCodePage(), 80);
        int size = OS.GetLocaleInfo(1024, 4099, tchar, 80);
        return size > 0 ? tchar.toString(0, size - 1) : "h:mm:ss tt";
    }

    boolean is24HourTime() {
        TCHAR tchar = new TCHAR(this.getCodePage(), 4);
        int size = OS.GetLocaleInfo(1024, 35, tchar, 4);
        if (size > 0) {
            String number = tchar.toString(0, size - 1);
            return Integer.parseInt(number) != 0;
        }
        return true;
    }

    public int getDay() {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wDay;
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wHour;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wHour;
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wMinute;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wMinute;
    }

    public int getMonth() {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wMonth - 1;
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? String.valueOf(this.getHours()) + ":" + this.getMinutes() + ":" + this.getSeconds() : String.valueOf(this.getMonth() + 1) + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.time.wSecond;
        }
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wSecond;
    }

    public int getYear() {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        return systime.wYear;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.lastSystemTime = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setDate(int year, int month, int day) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wYear = (short)year;
        systime.wMonth = (short)(month + 1);
        systime.wDay = (short)day;
        OS.SendMessage(this.handle, msg, 0L, systime);
        this.lastSystemTime = null;
    }

    public void setDay(int day) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wDay = (short)day;
        OS.SendMessage(this.handle, msg, 0L, systime);
        this.lastSystemTime = null;
    }

    public void setHours(int hours) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wHour = (short)hours;
        OS.SendMessage(this.handle, msg, 0L, systime);
        if ((this.style & 0x400) != 0 && hours >= 0 && hours <= 23) {
            this.time.wHour = (short)hours;
        }
    }

    public void setMinutes(int minutes) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wMinute = (short)minutes;
        OS.SendMessage(this.handle, msg, 0L, systime);
        if ((this.style & 0x400) != 0 && minutes >= 0 && minutes <= 59) {
            this.time.wMinute = (short)minutes;
        }
    }

    public void setMonth(int month) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wMonth = (short)(month + 1);
        OS.SendMessage(this.handle, msg, 0L, systime);
        this.lastSystemTime = null;
    }

    public void setSeconds(int seconds) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wSecond = (short)seconds;
        OS.SendMessage(this.handle, msg, 0L, systime);
        if ((this.style & 0x400) != 0 && seconds >= 0 && seconds <= 59) {
            this.time.wSecond = (short)seconds;
        }
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wHour = (short)hours;
        systime.wMinute = (short)minutes;
        systime.wSecond = (short)seconds;
        OS.SendMessage(this.handle, msg, 0L, systime);
        if ((this.style & 0x400) != 0 && hours >= 0 && hours <= 23 && minutes >= 0 && minutes <= 59 && seconds >= 0 && seconds <= 59) {
            this.time.wHour = (short)hours;
            this.time.wMinute = (short)minutes;
            this.time.wSecond = (short)seconds;
        }
    }

    public void setYear(int year) {
        this.checkWidget();
        SYSTEMTIME systime = new SYSTEMTIME();
        int msg = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, msg, 0L, systime);
        msg = (this.style & 0x400) != 0 ? 4098 : 4098;
        systime.wYear = (short)year;
        OS.SendMessage(this.handle, msg, 0L, systime);
        this.lastSystemTime = null;
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x10000;
        if ((this.style & 0x400) != 0) {
            return bits | 0x10;
        }
        bits &= 0xFDFFFFFF;
        if ((this.style & 0x80) != 0) {
            bits |= 9;
        }
        if ((this.style & 0x20) != 0) {
            bits |= (this.style & 0x10000) != 0 ? 12 : 4;
            if ((this.style & 4) == 0) {
                bits |= 1;
            }
        }
        return bits;
    }

    TCHAR windowClass() {
        return (this.style & 0x400) != 0 ? CalendarClass : DateTimeClass;
    }

    long windowProc() {
        return (this.style & 0x400) != 0 ? CalendarProc : DateTimeProc;
    }

    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -753: {
                this.display.captureChanged = true;
                break;
            }
            case -749: {
                if (this.ignoreSelection) break;
                SYSTEMTIME systime = new SYSTEMTIME();
                OS.SendMessage(this.handle, 4097, 0L, systime);
                this.postEvent(13);
                break;
            }
            case -759: {
                SYSTEMTIME systime = new SYSTEMTIME();
                OS.SendMessage(this.handle, 4097, 0L, systime);
                if (this.lastSystemTime != null && systime.wDay == this.lastSystemTime.wDay && systime.wMonth == this.lastSystemTime.wMonth && systime.wYear == this.lastSystemTime.wYear) break;
                this.postEvent(13);
                if ((this.style & 0x80) != 0) break;
                this.lastSystemTime = systime;
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }

    LRESULT WM_CHAR(long wParam, long lParam) {
        LRESULT result = super.WM_CHAR(wParam, lParam);
        if (result != null) {
            return result;
        }
        switch ((int)wParam) {
            case 13: {
                this.postEvent(14);
            }
            case 9: 
            case 27: {
                return LRESULT.ZERO;
            }
        }
        return result;
    }

    LRESULT WM_LBUTTONDBLCLK(long wParam, long lParam) {
        LRESULT result = super.WM_LBUTTONDBLCLK(wParam, lParam);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if ((this.style & 0x400) != 0) {
            MCHITTESTINFO pMCHitTest = new MCHITTESTINFO();
            pMCHitTest.cbSize = MCHITTESTINFO.sizeof;
            POINT pt = new POINT();
            pt.x = OS.GET_X_LPARAM(lParam);
            pt.y = OS.GET_Y_LPARAM(lParam);
            pMCHitTest.pt = pt;
            long code = OS.SendMessage(this.handle, 4110, 0L, pMCHitTest);
            if ((code & 0x20001L) == 131073L) {
                this.doubleClick = true;
            }
        }
        return result;
    }

    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        LRESULT result = super.WM_LBUTTONDOWN(wParam, lParam);
        if (result == LRESULT.ZERO) {
            return result;
        }
        this.doubleClick = false;
        if ((this.style & 0x400) != 0 && (this.style & 0x80000) == 0) {
            OS.SetFocus(this.handle);
        }
        return result;
    }

    LRESULT WM_LBUTTONUP(long wParam, long lParam) {
        LRESULT result = super.WM_LBUTTONUP(wParam, lParam);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (this.doubleClick) {
            this.postEvent(14);
        }
        this.doubleClick = false;
        return result;
    }

    LRESULT WM_TIMER(long wParam, long lParam) {
        LRESULT result = super.WM_TIMER(wParam, lParam);
        if (result != null) {
            return result;
        }
        this.ignoreSelection = true;
        long code = this.callWindowProc(this.handle, 275, wParam, lParam);
        this.ignoreSelection = false;
        return code == 0L ? LRESULT.ZERO : new LRESULT(code);
    }
}

