/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.scribe.utils.Preconditions;
import org.scribe.utils.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUtils {
    private static final String EMPTY_STRING = "";
    private static final String PAIR_SEPARATOR = "=";
    private static final String PARAM_SEPARATOR = "&";

    public static final Map<String, String> sort(Map<String, String> map) {
        Preconditions.checkNotNull(map, "Cannot sort a null object.");
        LinkedHashMap<String, String> sorted = new LinkedHashMap<String, String>();
        for (String key : MapUtils.getSortedKeys(map)) {
            sorted.put(key, map.get(key));
        }
        return sorted;
    }

    private static List<String> getSortedKeys(Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        return keys;
    }

    public static void decodeAndAppendEntries(Map<String, String> source, Map<String, String> target) {
        for (String key : source.keySet()) {
            target.put(URLUtils.percentEncode(key), URLUtils.percentEncode(source.get(key)));
        }
    }

    public static String concatSortedPercentEncodedParams(Map<String, String> params) {
        StringBuilder result = new StringBuilder();
        for (String key : params.keySet()) {
            result.append(key).append(PAIR_SEPARATOR);
            result.append(params.get(key)).append(PARAM_SEPARATOR);
        }
        return result.toString().substring(0, result.length() - 1);
    }

    public static Map<String, String> queryStringToMap(String queryString) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (queryString != null && queryString.length() > 0) {
            for (String param : queryString.split(PARAM_SEPARATOR)) {
                String[] pair = param.split(PAIR_SEPARATOR);
                String key = URLUtils.formURLDecode(pair[0]);
                String value = pair.length > 1 ? URLUtils.formURLDecode(pair[1]) : EMPTY_STRING;
                result.put(key, value);
            }
        }
        return result;
    }
}

