/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.Platform;
import com.jogamp.nativewindow.impl.windows.RGBQUAD32;
import com.jogamp.nativewindow.impl.windows.RGBQUAD64;
import java.nio.ByteBuffer;

public abstract class RGBQUAD {
    StructAccessor accessor;

    public static int size() {
        if (Platform.is32Bit()) {
            return RGBQUAD32.size();
        }
        return RGBQUAD64.size();
    }

    public static RGBQUAD create() {
        return RGBQUAD.create(Buffers.newDirectByteBuffer((int)RGBQUAD.size()));
    }

    public static RGBQUAD create(ByteBuffer byteBuffer) {
        if (Platform.is32Bit()) {
            return new RGBQUAD32(byteBuffer);
        }
        return new RGBQUAD64(byteBuffer);
    }

    RGBQUAD(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public abstract RGBQUAD setRgbBlue(byte var1);

    public abstract byte getRgbBlue();

    public abstract RGBQUAD setRgbGreen(byte var1);

    public abstract byte getRgbGreen();

    public abstract RGBQUAD setRgbRed(byte var1);

    public abstract byte getRgbRed();

    public abstract RGBQUAD setRgbReserved(byte var1);

    public abstract byte getRgbReserved();
}

