/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.impl;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLExtensionNames;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.opengl.impl.Debug;
import com.jogamp.opengl.impl.ExtensionAvailabilityCache;
import com.jogamp.opengl.impl.GLBufferSizeTracker;
import com.jogamp.opengl.impl.GLBufferStateTracker;
import com.jogamp.opengl.impl.GLContextLock;
import com.jogamp.opengl.impl.GLContextShareSet;
import com.jogamp.opengl.impl.GLDrawableImpl;
import com.jogamp.opengl.impl.GLDynamicLookupHelper;
import com.jogamp.opengl.impl.GLStateTracker;
import com.jogamp.opengl.impl.GLVersionNumber;
import com.jogamp.opengl.impl.GLWorkerThread;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class GLContextImpl
extends GLContext {
    protected static final boolean DEBUG = Debug.debug("GLContext");
    protected GLContextLock lock = new GLContextLock();
    private String contextFQN;
    protected ExtensionAvailabilityCache extensionAvailability;
    private ProcAddressTable glProcAddressTable;
    private GLBufferSizeTracker bufferSizeTracker;
    private GLBufferStateTracker bufferStateTracker = new GLBufferStateTracker();
    private GLStateTracker glStateTracker = new GLStateTracker();
    protected GLDrawableImpl drawable;
    protected GLDrawableImpl drawableRead;
    protected GL gl;
    protected static final Object mappedContextTypeObjectLock = new Object();
    protected static final HashMap mappedExtensionAvailabilityCache = new HashMap();
    protected static final HashMap mappedGLProcAddress = new HashMap();
    protected static final HashMap mappedGLXProcAddress = new HashMap();
    protected int currentSwapInterval = -1;
    protected boolean hasNativeES2Methods = false;

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        if (gLContext != null) {
            GLContextShareSet.registerSharing(this, gLContext);
        }
        GLContextShareSet.registerForBufferObjectSharing(gLContext, this);
        this.drawable = gLDrawableImpl;
        this.drawableRead = gLDrawableImpl;
    }

    protected void resetStates() {
        if (this.bufferSizeTracker != null) {
            this.bufferSizeTracker.clearCachedBufferSizes();
        }
        if (this.bufferStateTracker != null) {
            this.bufferStateTracker.clearBufferObjectState();
        }
        if (this.glStateTracker != null) {
            this.glStateTracker.clearStates(false);
        }
        this.extensionAvailability = null;
        this.glProcAddressTable = null;
        this.gl = null;
        this.contextFQN = null;
        super.resetStates();
    }

    public final void setGLReadDrawable(GLDrawable gLDrawable) {
        if (null != gLDrawable && this.drawable != gLDrawable && !this.isGLReadDrawableAvailable()) {
            throw new GLException("GL Read Drawable not available");
        }
        boolean bl = this.lock.isHeld();
        if (bl) {
            this.release();
        }
        GLDrawableImpl gLDrawableImpl = this.drawableRead = null != gLDrawable ? (GLDrawableImpl)gLDrawable : this.drawable;
        if (bl) {
            this.makeCurrent();
        }
    }

    public final GLDrawable getGLReadDrawable() {
        return this.drawableRead;
    }

    public final GLDrawable getGLDrawable() {
        return this.drawable;
    }

    public final GLDrawableImpl getDrawableImpl() {
        return (GLDrawableImpl)this.getGLDrawable();
    }

    public final GL getGL() {
        return this.gl;
    }

    public GL setGL(GL gL) {
        if (DEBUG) {
            String string = null != this.gl ? this.gl.getClass().toString() + ", " + this.gl.toString() : "<null>";
            String string2 = null != gL ? gL.getClass().toString() + ", " + gL.toString() : "<null>";
            Exception exception = new Exception("Info: setGL (OpenGL " + this.getGLVersion() + "): " + Thread.currentThread() + ", " + string + " -> " + string2);
            exception.printStackTrace();
        }
        this.gl = gL;
        return gL;
    }

    protected void update() throws GLException {
    }

    public boolean isSynchronized() {
        return !this.lock.getFailFastMode();
    }

    public void setSynchronized(boolean bl) {
        this.lock.setFailFastMode(!bl);
    }

    public abstract Object getPlatformGLExtensions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws GLException {
        if (!this.lock.isHeld()) {
            throw new GLException("Context not current on current thread");
        }
        GLContextImpl.setCurrent(null);
        try {
            this.releaseImpl();
        }
        finally {
            if (this.drawable.isSurfaceLocked()) {
                this.drawable.unlockSurface();
            }
            this.lock.unlock();
        }
    }

    protected abstract void releaseImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        block8: {
            if (this.lock.isHeld()) {
                this.release();
            }
            this.lock.lock();
            try {
                if (this.contextHandle == 0L) break block8;
                int n = this.drawable.lockSurface();
                if (1 == n) {
                    throw new GLException("Surface not ready to lock: " + this.drawable);
                }
                try {
                    this.destroyImpl();
                    this.contextHandle = 0L;
                    GLContextShareSet.contextDestroyed(this);
                }
                finally {
                    this.drawable.unlockSurface();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.resetStates();
    }

    protected abstract void destroyImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copy(GLContext gLContext, int n) throws GLException {
        if (gLContext.getHandle() == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (this.getHandle() == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        int n2 = this.drawable.lockSurface();
        if (1 == n2) {
            throw new GLException("Surface not ready to lock");
        }
        try {
            this.copyImpl(gLContext, n);
        }
        finally {
            this.drawable.unlockSurface();
        }
    }

    protected abstract void copyImpl(GLContext var1, int var2) throws GLException;

    public int makeCurrent() throws GLException {
        GLContext gLContext = GLContextImpl.getCurrent();
        if (gLContext != null) {
            if (gLContext == this) {
                this.update();
                return 1;
            }
            gLContext.release();
        }
        if (GLWorkerThread.isStarted() && !GLWorkerThread.isWorkerThread()) {
            GLWorkerThread.invokeLater(new Runnable(){

                public void run() {
                }
            });
        }
        if (!this.isCreated() && null == this.getGLDrawable().getChosenGLCapabilities()) {
            throw new GLException("drawable has no chosen GLCapabilities: " + this.getGLDrawable());
        }
        this.lock.lock();
        int n = 0;
        try {
            n = this.makeCurrentLocking();
        }
        catch (GLException gLException) {
            this.lock.unlock();
            throw gLException;
        }
        if (n == 0) {
            this.lock.unlock();
        } else {
            if (n == 2) {
                this.getGLDrawable().getGLProfile().verifyEquality(this.gl.getGLProfile());
            }
            GLContextImpl.setCurrent(this);
        }
        return n;
    }

    protected final int makeCurrentLocking() throws GLException {
        boolean bl = false;
        int n = this.drawable.lockSurface();
        try {
            if (1 == n) {
                int n2 = 0;
                return n2;
            }
            if (2 == n) {
                this.drawable.updateHandle();
            }
            if (0L == this.drawable.getHandle()) {
                throw new GLException("drawable has invalid handle: " + this.drawable);
            }
            boolean bl2 = false;
            if (!this.isCreated()) {
                GLProfile.initProfiles(this.getGLDrawable().getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration().getScreen().getDevice());
                bl2 = this.createImpl();
                if (DEBUG) {
                    if (bl2) {
                        System.err.println(GLContextImpl.getThreadName() + ": !!! Create GL context OK: " + GLContextImpl.toHexString(this.contextHandle) + " for " + this.getClass().getName());
                    } else {
                        System.err.println(GLContextImpl.getThreadName() + ": !!! Create GL context FAILED for " + this.getClass().getName());
                    }
                }
                if (!bl2) {
                    int n3 = 0;
                    return n3;
                }
                GLContextShareSet.contextCreated(this);
            }
            this.makeCurrentImpl(bl2);
            int n4 = bl2 ? 2 : 1;
            return n4;
        }
        finally {
            if (bl) {
                this.drawable.unlockSurface();
            }
        }
    }

    protected abstract void makeCurrentImpl(boolean var1) throws GLException;

    protected abstract boolean createImpl() throws GLException;

    protected abstract long createContextARBImpl(long var1, boolean var3, int var4, int var5, int var6);

    protected abstract void destroyContextARBImpl(long var1);

    protected final long createContextARB(long l, boolean bl, int[] nArray, int[] nArray2, int[] nArray3) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! createContextARB: mappedVersionsAvailableSet(" + abstractGraphicsDevice.getConnection() + "): " + GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice));
        }
        this.mapGLVersions(abstractGraphicsDevice);
        int n = gLProfile.isGL4() ? 4 : (gLProfile.isGL3() ? 3 : 2);
        boolean bl2 = gLProfile.isGL2();
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        long l2 = 0L;
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, n, bl2 ? 2 : 4, nArray4, nArray5, nArray6) && 0L != (l2 = this.createContextARBImpl(l, bl, nArray6[0], nArray4[0], nArray5[0]))) {
            this.setGLFunctionAvailability(true, nArray4[0], nArray5[0], nArray6[0]);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mapGLVersions(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice)) {
            HashMap hashMap = GLContext.deviceVersionAvailable;
            synchronized (hashMap) {
                this.createContextARBMapVersionsAvailable(4, false);
                this.createContextARBMapVersionsAvailable(4, true);
                this.createContextARBMapVersionsAvailable(3, false);
                this.createContextARBMapVersionsAvailable(3, true);
                this.createContextARBMapVersionsAvailable(2, true);
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
            }
        } else if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": no mapping, all versions set " + abstractGraphicsDevice.getConnection());
        }
    }

    private final void createContextARBMapVersionsAvailable(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.resetStates();
        int n6 = bl ? 2 : 4;
        int n7 = 37;
        if (bl) {
            n7 &= 0xFFFFFFFB;
            n7 |= 2;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (4 == n) {
            n5 = 4;
            n4 = GLContext.getMaxMinor(n5);
            n3 = 4;
            n2 = 0;
        } else if (3 == n) {
            n5 = 3;
            n4 = GLContext.getMaxMinor(n5);
            n3 = 3;
            n2 = 1;
        } else {
            n5 = 3;
            n4 = 0;
            n3 = 1;
            n2 = 1;
        }
        long l = this.createContextARBVersions(0L, true, n7, n5, n4, n3, n2, nArray, nArray2);
        if (0L == l && !bl) {
            n7 &= 0xFFFFFFFD;
            n7 |= 4;
            n7 &= 0xFFFFFFDF;
            l = this.createContextARBVersions(0L, true, n7 |= 0x10, n5, n4, n3, n2, nArray, nArray2);
            if (0L == l) {
                n7 &= 0xFFFFFFFB;
                n7 |= 2;
                n7 &= 0xFFFFFFEF;
                l = this.createContextARBVersions(0L, true, n7 |= 0x20, n5, n4, n3, n2, nArray, nArray2);
            }
        }
        if (0L != l) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration().getScreen().getDevice();
            GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n, n6, nArray[0], nArray2[0], n7);
            this.setGLFunctionAvailability(true, nArray[0], nArray2[0], n7);
            this.destroyContextARBImpl(l);
            this.resetStates();
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": !!! createContextARBMapVersionsAvailable HAVE: " + GLContext.getAvailableGLVersionAsString(abstractGraphicsDevice, n, n6));
            }
        } else if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! createContextARBMapVersionsAvailable NOPE: " + n + "." + n6);
        }
    }

    private final long createContextARBVersions(long l, boolean bl, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        nArray[0] = n2;
        nArray2[0] = n3;
        long l2 = 0L;
        while (0L == l2 && GLContext.isValidGLVersion(nArray[0], nArray2[0]) && (nArray[0] > n4 || nArray[0] == n4 && nArray2[0] >= n5)) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions: share " + l + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0]);
            }
            if (0L != (l2 = this.createContextARBImpl(l, bl, n, nArray[0], nArray2[0])) || GLContext.decrementGLVersion(nArray, nArray2)) continue;
            break;
        }
        return l2;
    }

    private final void setContextVersion(int n, int n2, int n3) {
        if (0 == n3) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
        }
        if (n > 0 || n2 > 0) {
            if (!GLContext.isValidGLVersion(n, n2)) {
                GLException gLException = new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
                throw gLException;
            }
            this.ctxMajorVersion = n;
            this.ctxMinorVersion = n2;
            this.ctxOptions = n3;
            this.ctxVersionString = GLContextImpl.getGLVersion(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, this.getGL().glGetString(7938));
            return;
        }
        if (n == 0 && n2 == 0) {
            String string = this.getGL().glGetString(7938);
            if (null == string) {
                throw new GLException("GL_VERSION is NULL: " + this);
            }
            this.ctxOptions = n3;
            GLVersionNumber gLVersionNumber = new GLVersionNumber(string);
            if (gLVersionNumber.isValid()) {
                this.ctxMajorVersion = gLVersionNumber.getMajor();
                this.ctxMinorVersion = gLVersionNumber.getMinor();
                if ((this.ctxMajorVersion > 3 || this.ctxMajorVersion == 3 && this.ctxMinorVersion >= 1) && 0 == (this.ctxOptions & 1)) {
                    this.ctxMajorVersion = 3;
                    this.ctxMinorVersion = 0;
                }
                this.ctxVersionString = GLContextImpl.getGLVersion(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, string);
                return;
            }
        }
    }

    private Object createInstance(GLProfile gLProfile, String string, Class[] classArray, Object[] objectArray) {
        return ReflectionUtil.createInstance((String)(gLProfile.getGLImplBaseClassName() + string), (Class[])classArray, (Object[])objectArray, (ClassLoader)this.getClass().getClassLoader());
    }

    private boolean verifyInstance(GLProfile gLProfile, String string, Object object) {
        return ReflectionUtil.instanceOf((Object)object, (String)(gLProfile.getGLImplBaseClassName() + string));
    }

    protected GL createGL(GLProfile gLProfile) {
        GL gL = (GL)this.createInstance(gLProfile, "Impl", new Class[]{GLProfile.class, GLContextImpl.class}, new Object[]{gLProfile, this});
        return gL;
    }

    public final ProcAddressTable getGLProcAddressTable() {
        return this.glProcAddressTable;
    }

    public abstract ProcAddressTable getPlatformExtProcAddressTable();

    public abstract void bindPbufferToTexture();

    public abstract void releasePbufferFromTexture();

    public abstract ByteBuffer glAllocateMemoryNV(int var1, float var2, float var3, float var4);

    public final void setSwapInterval(int n) {
        GLContext gLContext = GLContextImpl.getCurrent();
        if (gLContext != this) {
            throw new GLException("This context is not current. Current context: " + gLContext + ", this context " + this);
        }
        this.setSwapIntervalImpl(n);
    }

    protected void setSwapIntervalImpl(int n) {
    }

    public int getSwapInterval() {
        return this.currentSwapInterval;
    }

    protected String mapToRealGLFunctionName(String string) {
        String string2;
        Map map = this.getFunctionNameMap();
        String string3 = string2 = null != map ? (String)map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map getFunctionNameMap();

    protected String mapToRealGLExtensionName(String string) {
        String string2;
        Map map = this.getExtensionNameMap();
        String string3 = string2 = null != map ? (String)map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map getExtensionNameMap();

    protected void resetProcAddressTable(ProcAddressTable procAddressTable) {
        procAddressTable.reset((DynamicLookupHelper)this.getDrawableImpl().getGLDynamicLookupHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setGLFunctionAvailability(boolean bl, int n, int n2, int n3) {
        if (null != this.gl && null != this.glProcAddressTable && !bl) {
            return;
        }
        if (null == this.gl || bl) {
            this.setGL(this.createGL(this.getGLDrawable().getGLProfile()));
        }
        this.updateGLXProcAddressTable();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! Context FQN: " + this.contextFQN);
        }
        if (null == this.gl) {
            throw new GLException("setGLFunctionAvailability not called yet");
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLProcAddress.get(this.contextFQN);
            if (null != procAddressTable && !this.verifyInstance(this.gl.getGLProfile(), "ProcAddressTable", procAddressTable)) {
                throw new InternalError("GLContext GL ProcAddressTable mapped key(" + this.contextFQN + ") -> " + procAddressTable.getClass().getName() + " not matching " + this.gl.getGLProfile().getGLImplBaseClassName());
            }
        }
        if (null != procAddressTable) {
            this.glProcAddressTable = procAddressTable;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": !!! GLContext GL ProcAddressTable reusing key(" + this.contextFQN + ") -> " + procAddressTable.hashCode());
            }
        } else {
            if (this.glProcAddressTable == null) {
                this.glProcAddressTable = (ProcAddressTable)this.createInstance(this.gl.getGLProfile(), "ProcAddressTable", new Class[]{FunctionAddressResolver.class}, new Object[]{new GLProcAddressResolver()});
            }
            this.resetProcAddressTable(this.getGLProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLProcAddress.put(this.contextFQN, this.getGLProcAddressTable());
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": !!! GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + this.getGLProcAddressTable().hashCode());
                }
            }
        }
        this.setContextVersion(n, n2, n3);
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = (ExtensionAvailabilityCache)mappedExtensionAvailabilityCache.get(this.contextFQN);
        }
        if (null != object) {
            this.extensionAvailability = object;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": !!! GLContext GL ExtensionAvailabilityCache reusing key(" + this.contextFQN + ") -> " + object.hashCode());
            }
        } else {
            if (null == this.extensionAvailability) {
                this.extensionAvailability = new ExtensionAvailabilityCache(this);
            }
            this.extensionAvailability.reset();
            object2 = mappedContextTypeObjectLock;
            synchronized (object2) {
                mappedExtensionAvailabilityCache.put(this.contextFQN, this.extensionAvailability);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": !!! GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + this.extensionAvailability.hashCode());
                }
            }
        }
        this.hasNativeES2Methods = this.isGLES2() || this.isExtensionAvailable("GL_ARB_ES2_compatibility");
    }

    protected abstract void updateGLXProcAddressTable();

    public final boolean hasNativeES2Methods() {
        return this.hasNativeES2Methods;
    }

    public boolean isFunctionAvailable(String string) {
        ProcAddressTable procAddressTable = this.getGLProcAddressTable();
        if (null != procAddressTable) {
            try {
                if (0L != procAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (procAddressTable = this.getPlatformExtProcAddressTable())) {
            try {
                if (0L != procAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        String string2 = GLExtensionNames.normalizeVEN(GLExtensionNames.normalizeARB(string, true), true);
        long l = 0L;
        int n = GLExtensionNames.getFuncNamePermutationNumber(string2);
        for (int i = 0; 0L == l && i < n; ++i) {
            String string3 = GLExtensionNames.getFuncNamePermutation(string2, i);
            try {
                l = gLDynamicLookupHelper.dynamicLookupFunction(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L != l;
    }

    public boolean isExtensionAvailable(String string) {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
        }
        return false;
    }

    public String getPlatformExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getPlatformExtensionsString();
        }
        return null;
    }

    public String getGLExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getGLExtensionsString();
        }
        return null;
    }

    public final boolean isExtensionCacheInitialized() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isInitialized();
        }
        return false;
    }

    protected static String getContextFQN(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3) {
        return abstractGraphicsDevice.getUniqueID() + "-" + GLContextImpl.toHexString(GLContextImpl.compose8bit(n, n2, n3, 0));
    }

    protected String getContextFQN() {
        return this.contextFQN;
    }

    public int getFloatingPointMode() throws GLException {
        throw new GLException("Not supported on non-pbuffer contexts");
    }

    public abstract boolean offscreenImageNeedsVerticalFlip();

    public abstract int getOffscreenContextPixelDataType();

    public void setBufferSizeTracker(GLBufferSizeTracker gLBufferSizeTracker) {
        this.bufferSizeTracker = gLBufferSizeTracker;
    }

    public GLBufferSizeTracker getBufferSizeTracker() {
        return this.bufferSizeTracker;
    }

    public GLBufferStateTracker getBufferStateTracker() {
        return this.bufferStateTracker;
    }

    public GLStateTracker getGLStateTracker() {
        return this.glStateTracker;
    }

    public boolean hasWaiters() {
        return this.lock.hasWaiters();
    }
}

