/*
 * Decompiled with CFR 0.152.
 */
package com.iabcinc.mapping.voronoi.test;

import com.iabcinc.mapping.voronoi.Point;
import com.iabcinc.mapping.voronoi.QuadEdge;
import com.iabcinc.mapping.voronoi.Triangulation;
import com.iabcinc.mapping.voronoi.VoronoiPolygon;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;

public class VoronoiPanel
extends JPanel {
    private static final long serialVersionUID = -3169934243814043533L;
    Vector points = null;
    Vector<VoronoiPolygon> voronoiPolygons = null;
    Vector voronoiEdges = null;
    Vector delaunayEdges = null;
    Triangulation tri = null;
    private double scalex = 20.0;
    private double scaley = -20.0;
    private double offsetx = 122.009224;
    private double offsety = -47.608307;

    public void setViewPort(double offsetx, double offsety, double scalex, double scaley) {
        this.scalex = scalex;
        this.scaley = scaley;
        this.offsetx = offsetx;
        this.offsety = offsety;
    }

    protected void paintComponent(Graphics g) {
        double ty;
        double tx;
        QuadEdge edge;
        Iterator<Object> i;
        super.paintComponent(g);
        Insets insets = this.getInsets();
        Graphics2D g2d = (Graphics2D)g.create();
        Rectangle clipRect = new Rectangle();
        g.getClipBounds(clipRect);
        int sizex = this.getWidth() - insets.right - insets.left - 1;
        int sizey = this.getHeight() - insets.bottom - insets.top - 1;
        int centerx = sizex / 2;
        int centery = sizey / 2;
        if (this.points != null) {
            for (Point p : this.points) {
                g2d.fill(new Ellipse2D.Double(this.scalex * (p.getX() + this.offsetx) + (double)centerx - 3.0, this.scaley * (p.getY() + this.offsety) + (double)centery - 3.0, 6.0, 6.0));
            }
        }
        if (this.voronoiPolygons != null) {
            for (VoronoiPolygon polygon : this.voronoiPolygons) {
                Iterator j = polygon.edges().iterator();
                Point f = null;
                Point t = null;
                QuadEdge edge2 = null;
                while (j.hasNext()) {
                    edge2 = (QuadEdge)j.next();
                    f = edge2.getOrg();
                    t = edge2.getDest();
                    g2d.draw(new Line2D.Double(this.scalex * (f.getX() + this.offsetx) + (double)centerx, this.scaley * (f.getY() + this.offsety) + (double)centery, this.scalex * (t.getX() + this.offsetx) + (double)centerx, this.scaley * (t.getY() + this.offsety) + (double)centery));
                    f = t;
                }
            }
        }
        if (this.voronoiEdges != null) {
            i = this.voronoiEdges.iterator();
            g2d.setColor(Color.blue);
            while (i.hasNext()) {
                edge = (QuadEdge)i.next();
                double fx = edge.getOrg().getX();
                double fy = edge.getOrg().getY();
                tx = edge.getDest().getX();
                ty = edge.getDest().getY();
                g2d.draw(new Line2D.Double(this.scalex * (fx + this.offsetx) + (double)centerx, this.scaley * (fy + this.offsety) + (double)centery, this.scalex * (tx + this.offsetx) + (double)centerx, this.scaley * (ty + this.offsety) + (double)centery));
            }
        }
        if (this.delaunayEdges != null) {
            i = this.delaunayEdges.iterator();
            g2d.setColor(Color.red);
            while (i.hasNext()) {
                edge = (QuadEdge)i.next();
                double fx = edge.getOrg().getX();
                double fy = edge.getOrg().getY();
                tx = edge.getDest().getX();
                ty = edge.getDest().getY();
                g2d.draw(new Line2D.Double(this.scalex * (fx + this.offsetx) + (double)centerx, this.scaley * (fy + this.offsety) + (double)centery, this.scalex * (tx + this.offsetx) + (double)centerx, this.scaley * (ty + this.offsety) + (double)centery));
            }
        }
        g2d.dispose();
    }

    public VoronoiPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(422, 329);
    }

    public void setTriangulation(Triangulation triangulation) {
        this.voronoiPolygons = triangulation.getVoronoiPolygons();
        this.delaunayEdges = triangulation.getDelaunayEdges();
        this.tri = triangulation;
    }

    public void setPoints(Vector points) {
    }
}

