/*
 * Decompiled with CFR 0.152.
 */
package com.iabcinc.mapping.voronoi;

import com.iabcinc.common.FlagableImpl;
import com.iabcinc.mapping.voronoi.QuadEdge;
import java.util.HashMap;
import java.util.Map;

public class Point
extends FlagableImpl {
    private Map<String, String> properties = null;
    private double x;
    private double y;
    static final double TOLLERANCE = 0.0;

    public Point(double a, double b) {
        this.x = a;
        this.y = b;
    }

    public Point(Point pt) {
        this(pt.x, pt.y);
    }

    public Point() {
    }

    public void setProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point p = (Point)o;
        return Math.abs(this.x - p.x) < 0.0 && Math.abs(this.y - p.y) < 0.0;
    }

    boolean isOn(QuadEdge e) {
        return false;
    }

    boolean isRightOf(QuadEdge e) {
        return Point.calculateTriArea(this, e.getDest(), e.getOrg()) > 0.0;
    }

    boolean isLeftOf(QuadEdge e) {
        return Point.calculateTriArea(this, e.getOrg(), e.getDest()) > 0.0;
    }

    private static double calculateTriArea(Point p1, Point p2, Point p3) {
        return (p2.x - p1.x) * (p3.y - p1.y) - (p3.x - p1.x) * (p2.y - p1.y);
    }

    boolean isInCircle(Point a, Point b, Point c) {
        return ((a.x - this.x) * (a.x - this.x) + (a.y - this.y) * (a.y - this.y)) * Point.calculateTriArea(b, c, this) - ((b.x - this.x) * (b.x - this.x) + (b.y - this.y) * (b.y - this.y)) * Point.calculateTriArea(a, c, this) + ((c.x - this.x) * (c.x - this.x) + (c.y - this.y) * (c.y - this.y)) * Point.calculateTriArea(a, b, this) > 0.0;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

