/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.mmd2javie;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.widgets.FrameRateComboUtil;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.TimeCode;
import ch.kuramo.javie.core.Util;
import ch.kuramo.mmd2javie.MMD2Javie2;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class MMD2Javie2WizardPage
extends WizardPage {
    private final MMD2Javie2 m2j2;
    private final ProjectManager pm;
    private Combo fpsCombo;
    private Label durationLabel;
    private Text scaleText;
    private Combo originCombo;
    private Text xoffText;
    private Text yoffText;
    private Text zoffText;
    private Button newCompRadio;
    private Text newCompText;
    private Button addCameraRadio;
    private Combo addCameraCombo;
    private Text widthText;
    private Text heightText;
    private Button freezeRatioCheck;
    private List<LayerComposition> compositions;
    private int widthRatio;
    private int heightRatio;
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            MMD2Javie2WizardPage.this.doValidate((Control)e.getSource());
        }
    };
    private final SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            MMD2Javie2WizardPage.this.doValidate((Control)e.getSource());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            MMD2Javie2WizardPage.this.doValidate((Control)e.getSource());
        }
    };

    MMD2Javie2WizardPage(MMD2Javie2 m2j2, ProjectManager pm) {
        super("MMD2Javie2WizardPage", "\u8aad\u307f\u8fbc\u307f\u8a2d\u5b9a", null);
        this.m2j2 = m2j2;
        this.pm = pm;
    }

    public void createControl(Composite parent) {
        GridBuilder gb = new GridBuilder(parent, 1, false);
        ((GridLayout)gb.getComposite().getLayout()).verticalSpacing = 0;
        this.createCameraDataGroup(gb);
        gb.size(10, 10).composite(0);
        this.createCompositionGroup(gb);
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        this.setControl((Control)grid);
        this.doValidate(null);
    }

    private void createCameraDataGroup(GridBuilder gb) {
        String[] originComboItems = new String[]{"\u539f\u70b9", "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306e\u4e2d\u5fc3", "\u30ab\u30b9\u30bf\u30e0"};
        Group group = gb.hAlign(4).hGrab().group(0, "\u30ab\u30e1\u30e9\u30c7\u30fc\u30bf");
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        GridBuilder gb2 = new GridBuilder((Composite)group, 9, false);
        gb2.hSpan(1).hAlign(131072).label(0, "\u30d5\u30ec\u30fc\u30e0\u6570:");
        gb2.hSpan(8).hAlign(16384).label(0, String.valueOf(this.m2j2.getFrameCount()));
        gb2.hSpan(1).hAlign(131072).label(0, "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8:");
        this.fpsCombo = gb2.hSpan(2).hAlign(4).combo(0, 0, FrameRateComboUtil.getComboItems(), FrameRateComboUtil.toComboItem(FrameDuration.FPS_30));
        gb2.hSpan(6).hAlign(16384).label(0, "\u30d5\u30ec\u30fc\u30e0\uff0f\u79d2");
        gb2.hSpan(1).hAlign(131072).label(0, "\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3:");
        this.durationLabel = gb2.hSpan(8).hAlign(4).hGrab().label(0, "");
        gb2.hSpan(9).size(10, 10).composite(0);
        gb2.hSpan(1).hAlign(131072).label(0, "\u30b9\u30b1\u30fc\u30eb:");
        this.scaleText = gb2.hSpan(2).hAlign(4).width(70).text(2048, "2000");
        gb2.hSpan(6).hAlign(16384).label(0, "%");
        gb2.hSpan(1).hAlign(131072).label(0, "\u4f4d\u7f6e\u306e\u57fa\u6e96:");
        this.originCombo = gb2.hSpan(8).hAlign(16384).combo(8, originComboItems, originComboItems[1]);
        gb2.hSpan(1).size(10, 10).composite(0);
        gb2.hSpan(1).hAlign(16384).label(0, "x =");
        this.xoffText = gb2.hSpan(2).hAlign(4).width(70).text(2048, "");
        gb2.hSpan(1).hAlign(16384).label(0, "  y =");
        this.yoffText = gb2.hSpan(1).hAlign(4).width(70).text(2048, "");
        gb2.hSpan(1).hAlign(16384).label(0, "  z =");
        this.zoffText = gb2.hSpan(1).hAlign(4).width(70).text(2048, "");
        gb2.hSpan(1).hAlign(16384).label(0, "");
        this.fpsCombo.addModifyListener(this.modifyListener);
        this.fpsCombo.addSelectionListener(this.selectionListener);
        this.scaleText.addModifyListener(this.modifyListener);
        this.originCombo.addSelectionListener(this.selectionListener);
        this.xoffText.addModifyListener(this.modifyListener);
        this.yoffText.addModifyListener(this.modifyListener);
        this.zoffText.addModifyListener(this.modifyListener);
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void createCompositionGroup(GridBuilder gb) {
        List compNames = Util.newList();
        this.compositions = Util.newList();
        for (Item item : this.pm.getProject().getItems()) {
            Composition comp;
            if (!(item instanceof CompositionItem) || !((comp = ((CompositionItem)item).getComposition()) instanceof LayerComposition)) continue;
            compNames.add(item.getName());
            this.compositions.add((LayerComposition)comp);
        }
        Group group = gb.hAlign(4).hGrab().group(0, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3");
        FillLayout layout = new FillLayout(256);
        layout.marginHeight = 5;
        group.setLayout((Layout)layout);
        GridBuilder gb2 = new GridBuilder((Composite)group, 4, false);
        this.newCompRadio = gb2.hSpan(1).hAlign(16384).button(16, "\u65b0\u898f\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3:");
        this.newCompText = gb2.hSpan(3).hAlign(4).hGrab().text(2048, this.pm.getUnusedItemName("\u30b3\u30f3\u30dd"));
        this.newCompRadio.setSelection(true);
        if (compNames.isEmpty()) {
            this.addCameraRadio = gb2.hSpan(2).hAlign(16384).button(16, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306b\u30ab\u30e1\u30e9\u3092\u8ffd\u52a0:");
            this.addCameraCombo = gb2.hSpan(2).hAlign(16384).combo(8, new String[]{""});
            this.addCameraRadio.setEnabled(false);
            this.addCameraCombo.setEnabled(false);
        } else {
            this.addCameraRadio = gb2.hSpan(2).hAlign(16384).button(16, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306b\u30ab\u30e1\u30e9\u3092\u8ffd\u52a0:");
            this.addCameraCombo = gb2.hSpan(2).hAlign(16384).combo(8, 20, compNames.toArray(new String[compNames.size()]), (String)compNames.get(0));
            this.addCameraCombo.setEnabled(false);
        }
        gb2.hSpan(4).size(10, 10).composite(0);
        gb2.hSpan(1).hAlign(131072).label(0, "\u5e45:");
        this.widthText = gb2.hSpan(2).hAlign(4).width(70).text(2048, "512");
        this.freezeRatioCheck = gb2.span(1, 2).hAlign(16384).hGrab().button(32, "\u7e26\u6a2a\u6bd4\u3092\u56fa\u5b9a");
        gb2.hSpan(1).hAlign(131072).label(0, "\u9ad8\u3055:");
        this.heightText = gb2.hSpan(2).hAlign(4).width(70).tabAfter((Control)this.widthText).text(2048, "384");
        this.newCompRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MMD2Javie2WizardPage.this.newCompText.setEnabled(true);
                MMD2Javie2WizardPage.this.addCameraCombo.setEnabled(false);
                MMD2Javie2WizardPage.this.widthText.setEnabled(true);
                MMD2Javie2WizardPage.this.heightText.setEnabled(true);
                MMD2Javie2WizardPage.this.freezeRatioCheck.setEnabled(true);
                MMD2Javie2WizardPage.this.doValidate((Control)e.getSource());
            }
        });
        this.addCameraRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MMD2Javie2WizardPage.this.newCompText.setEnabled(false);
                MMD2Javie2WizardPage.this.addCameraCombo.setEnabled(true);
                MMD2Javie2WizardPage.this.widthText.setEnabled(false);
                MMD2Javie2WizardPage.this.heightText.setEnabled(false);
                MMD2Javie2WizardPage.this.freezeRatioCheck.setEnabled(false);
                MMD2Javie2WizardPage.this.doValidate((Control)e.getSource());
            }
        });
        this.newCompText.addModifyListener(this.modifyListener);
        this.addCameraCombo.addSelectionListener(this.selectionListener);
        this.widthText.addModifyListener(this.modifyListener);
        this.heightText.addModifyListener(this.modifyListener);
        this.freezeRatioCheck.addSelectionListener(this.selectionListener);
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
    }

    private void doValidate(Control control) {
        double scale;
        double fps;
        this.setPageComplete(false);
        String fpsStr = this.fpsCombo.getText().trim();
        try {
            fps = Double.parseDouble(fpsStr);
        }
        catch (NumberFormatException numberFormatException) {
            fps = 0.0;
        }
        if (fps >= 1.0) {
            Time frameDuration = FrameRateComboUtil.toFrameDuration(fpsStr);
            String timeCode = TimeCode.toTimeCode((Time)Time.fromFrameNumber((long)this.m2j2.getFrameCount(), (Time)frameDuration), (Time)frameDuration);
            int base = (int)Math.round((double)frameDuration.timeScale / (double)frameDuration.timeValue);
            boolean drop = timeCode.indexOf(59) != -1;
            this.durationLabel.setText(String.format("%s (\u30d9\u30fc\u30b9 %d%s)", timeCode, base, drop ? "\u30c9\u30ed\u30c3\u30d7" : ""));
        } else {
            this.durationLabel.setText("");
        }
        String scaleStr = this.scaleText.getText().trim();
        try {
            scale = Double.parseDouble(scaleStr);
        }
        catch (NumberFormatException numberFormatException) {
            scale = 0.0;
        }
        String wStr = null;
        String hStr = null;
        int width = 0;
        int height = 0;
        if (this.newCompRadio.getSelection()) {
            wStr = this.widthText.getText().trim();
            try {
                width = Integer.parseInt(wStr);
            }
            catch (NumberFormatException numberFormatException) {
                width = 0;
            }
            hStr = this.heightText.getText().trim();
            try {
                height = Integer.parseInt(hStr);
            }
            catch (NumberFormatException numberFormatException) {
                height = 0;
            }
            boolean frozen = this.freezeRatioCheck.getSelection();
            if (frozen) {
                if (control == this.widthText && width > 0) {
                    height = Math.max(1, width * this.heightRatio / this.widthRatio);
                    this.heightText.removeModifyListener(this.modifyListener);
                    this.heightText.setText(String.valueOf(height));
                    this.heightText.addModifyListener(this.modifyListener);
                } else if (control == this.heightText && height > 0) {
                    width = Math.max(1, height * this.widthRatio / this.heightRatio);
                    this.widthText.removeModifyListener(this.modifyListener);
                    this.widthText.setText(String.valueOf(width));
                    this.widthText.addModifyListener(this.modifyListener);
                }
            } else if ((control == null || control == this.widthText || control == this.heightText) && width > 0 && height > 0) {
                int gcd = this.gcd(width, height);
                this.widthRatio = width / gcd;
                this.heightRatio = height / gcd;
                this.freezeRatioCheck.setText(String.format("\u7e26\u6a2a\u6bd4\u3092%d:%d\u306b\u56fa\u5b9a", this.widthRatio, this.heightRatio));
                this.freezeRatioCheck.getParent().layout(new Control[]{this.freezeRatioCheck});
            }
        } else {
            LayerComposition comp = this.compositions.get(this.addCameraCombo.getSelectionIndex());
            Size2i size = comp.getSize();
            width = size.width;
            height = size.height;
            this.widthText.removeModifyListener(this.modifyListener);
            this.widthText.setText(String.valueOf(width));
            this.widthText.addModifyListener(this.modifyListener);
            this.heightText.removeModifyListener(this.modifyListener);
            this.heightText.setText(String.valueOf(height));
            this.heightText.addModifyListener(this.modifyListener);
            int gcd = this.gcd(width, height);
            this.widthRatio = width / gcd;
            this.heightRatio = height / gcd;
            this.freezeRatioCheck.setText(String.format("\u7e26\u6a2a\u6bd4\u3092%d:%d\u306b\u56fa\u5b9a", this.widthRatio, this.heightRatio));
            this.freezeRatioCheck.getParent().layout(new Control[]{this.freezeRatioCheck});
        }
        this.xoffText.removeModifyListener(this.modifyListener);
        this.yoffText.removeModifyListener(this.modifyListener);
        this.zoffText.removeModifyListener(this.modifyListener);
        switch (this.originCombo.getSelectionIndex()) {
            case 0: {
                this.xoffText.setEnabled(false);
                this.xoffText.setText("0");
                this.yoffText.setEnabled(false);
                this.yoffText.setText("0");
                this.zoffText.setEnabled(false);
                this.zoffText.setText("0");
                break;
            }
            case 1: {
                this.xoffText.setEnabled(false);
                this.xoffText.setText(width > 0 ? String.valueOf((double)width * 0.5) : "");
                this.yoffText.setEnabled(false);
                this.yoffText.setText(height > 0 ? String.valueOf((double)height * 0.5) : "");
                this.zoffText.setEnabled(false);
                this.zoffText.setText("0");
                break;
            }
            case 2: {
                boolean focus = !this.xoffText.isEnabled();
                this.xoffText.setEnabled(true);
                this.yoffText.setEnabled(true);
                this.zoffText.setEnabled(true);
                if (!focus) break;
                this.xoffText.setFocus();
            }
        }
        this.xoffText.addModifyListener(this.modifyListener);
        this.yoffText.addModifyListener(this.modifyListener);
        this.zoffText.addModifyListener(this.modifyListener);
        String warnMsg = null;
        String errMsg = null;
        if (errMsg == null && fpsStr.length() == 0) {
            errMsg = "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        }
        if (errMsg == null && fps < 1.0) {
            errMsg = "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u306b\u306f1\u4ee5\u4e0a\u306e\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        }
        if (errMsg == null && scaleStr.length() == 0) {
            errMsg = "\u30b9\u30b1\u30fc\u30eb\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
        }
        if (errMsg == null && scale <= 0.0) {
            errMsg = "\u30b9\u30b1\u30fc\u30eb\u306b\u306f0\u3088\u308a\u5927\u304d\u3044\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
        }
        if (this.newCompRadio.getSelection()) {
            if (errMsg == null && this.newCompText.getText().trim().length() == 0) {
                errMsg = "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            if (errMsg == null && wStr.length() == 0) {
                errMsg = "\u5e45\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            if (errMsg == null && (width < 1 || width > 8192)) {
                errMsg = String.format("\u5e45\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192);
            }
            if (errMsg == null && hStr.length() == 0) {
                errMsg = "\u9ad8\u3055\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            if (errMsg == null && (height < 1 || height > 8192)) {
                errMsg = String.format("\u9ad8\u3055\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192);
            }
        }
        if (this.originCombo.getSelectionIndex() == 2) {
            String xStr = this.xoffText.getText().trim();
            String yStr = this.yoffText.getText().trim();
            String zStr = this.zoffText.getText().trim();
            double x = Double.NaN;
            double y = Double.NaN;
            double z = Double.NaN;
            try {
                x = Double.parseDouble(xStr);
                y = Double.parseDouble(yStr);
                z = Double.parseDouble(zStr);
            }
            catch (NumberFormatException numberFormatException) {}
            if (errMsg == null && (xStr.length() == 0 || yStr.length() == 0 || zStr.length() == 0)) {
                errMsg = "\u4f4d\u7f6e\u306e\u57fa\u6e96\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            }
            if (errMsg == null && (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z))) {
                errMsg = "\u4f4d\u7f6e\u306e\u57fa\u6e96\u306b\u306f\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
        }
        this.setMessage(warnMsg, 2);
        this.setErrorMessage(errMsg);
        this.setPageComplete(errMsg == null);
    }

    private int gcd(int x, int y) {
        while (y != 0) {
            int t = x % y;
            x = y;
            y = t;
        }
        return x;
    }

    Time getFrameDuration() {
        if (this.isPageComplete()) {
            return FrameRateComboUtil.toFrameDuration(this.fpsCombo.getText().trim());
        }
        throw new IllegalStateException();
    }

    double getScale() {
        if (this.isPageComplete()) {
            return Double.parseDouble(this.scaleText.getText().trim()) * 0.01;
        }
        throw new IllegalStateException();
    }

    Vec3d getOffset() {
        if (this.isPageComplete()) {
            double x = Double.parseDouble(this.xoffText.getText().trim());
            double y = Double.parseDouble(this.yoffText.getText().trim());
            double z = Double.parseDouble(this.zoffText.getText().trim());
            return new Vec3d(x, y, z);
        }
        throw new IllegalStateException();
    }

    String getNewCompositionName() {
        if (this.isPageComplete()) {
            return this.newCompRadio.getSelection() ? this.newCompText.getText().trim() : null;
        }
        throw new IllegalStateException();
    }

    LayerComposition getComposition() {
        if (this.isPageComplete()) {
            return this.newCompRadio.getSelection() ? null : this.compositions.get(this.addCameraCombo.getSelectionIndex());
        }
        throw new IllegalStateException();
    }

    Size2i getCompositionSize() {
        if (this.isPageComplete()) {
            if (this.newCompRadio.getSelection()) {
                return new Size2i(Integer.parseInt(this.widthText.getText().trim()), Integer.parseInt(this.heightText.getText().trim()));
            }
            return this.getComposition().getSize();
        }
        throw new IllegalStateException();
    }
}

