/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.wizards;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.widgets.FrameRateComboUtil;
import ch.kuramo.javie.app.widgets.GridBuilder;
import ch.kuramo.javie.app.wizards.CompositionSettings;
import ch.kuramo.javie.core.TimeCode;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CompositionWizardPage
extends WizardPage {
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    public static final int MAX_SIZE = 8192;
    private CompositionSettings _settings;
    private Text _nameText;
    private Text _widthText;
    private Text _heightText;
    private Button _freezeRatio;
    private Combo _fpsCombo;
    private Text _durationText;
    private Label _duration2;
    private Combo _colorModeCombo;
    private Button _fpsPreserved;
    private Text _mblurAngleText;
    private Text _mblurPhaseText;
    private Text _mblurSamplesText;
    private ModifyListener _modifyListener;
    private int _widthRatio;
    private int _heightRatio;

    public CompositionWizardPage(CompositionSettings settings, boolean newComp) {
        super("CompositionWizardPage", newComp ? "\u65b0\u898f\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3" : "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u8a2d\u5b9a", null);
        this._settings = settings;
    }

    public void createControl(Composite parent) {
        String[] colorModeItems = new String[]{"8 bit/\u30c1\u30e3\u30f3\u30cd\u30eb", "16 bit/\u30c1\u30e3\u30f3\u30cd\u30eb", "16 bit/\u30c1\u30e3\u30f3\u30cd\u30eb\uff08\u6d6e\u52d5\u5c0f\u6570\u70b9\uff09", "32 bit/\u30c1\u30e3\u30f3\u30cd\u30eb\uff08\u6d6e\u52d5\u5c0f\u6570\u70b9\uff09"};
        GridBuilder gb = new GridBuilder(parent, 16, true);
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u540d\u524d:");
        this._nameText = gb.hSpan(12).hAlign(4).hGrab().text(2048, this._settings.name);
        gb.hSpan(16).size(10, 10).composite(0);
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u5e45:");
        this._widthText = gb.hSpan(3).hAlign(4).hGrab().text(2048, String.valueOf(this._settings.size.width));
        this._freezeRatio = gb.span(9, 2).hAlign(16384).hGrab().button(32, "\u7e26\u6a2a\u6bd4\u3092\u56fa\u5b9a");
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u9ad8\u3055:");
        this._heightText = gb.hSpan(3).hAlign(4).hGrab().tabAfter((Control)this._widthText).text(2048, String.valueOf(this._settings.size.height));
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8:");
        this._fpsCombo = gb.hSpan(3).hAlign(4).hGrab().combo(0, 0, FrameRateComboUtil.getComboItems(), FrameRateComboUtil.toComboItem(this._settings.frameDuration));
        gb.hSpan(9).hGrab().label(0, "\u30d5\u30ec\u30fc\u30e0\uff0f\u79d2");
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3:");
        this._durationText = gb.hSpan(3).hAlign(4).hGrab().text(2048, TimeCode.toTimeCode((Time)this._settings.duration, (Time)this._settings.frameDuration));
        this._duration2 = gb.hSpan(9).hAlign(4).hGrab().label(0, "");
        if (COCOA) {
            gb.hSpan(16).size(0, 0).composite(0);
        }
        gb.hSpan(4).hAlign(131072).hGrab().label(0, "\u8272\u6df1\u5ea6:");
        this._colorModeCombo = gb.hSpan(12).hGrab().combo(8, colorModeItems, this._settings.colorMode.ordinal());
        gb.hSpan(16).size(10, 10).composite(0);
        gb.hSpan(4).size(10, 10).composite(0);
        this._fpsPreserved = gb.hSpan(12).hAlign(16384).hGrab().button(32, "\u30cd\u30b9\u30c8\u6642\u306b\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u3092\u4fdd\u6301");
        gb.hSpan(16).size(10, 10).composite(0);
        Group mblurGroup = gb.hSpan(16).hAlign(4).hGrab().group(0, "\u30e2\u30fc\u30b7\u30e7\u30f3\u30d6\u30e9\u30fc");
        mblurGroup.setLayout((Layout)new FillLayout(256));
        GridBuilder gb2 = new GridBuilder((Composite)mblurGroup, 16, true);
        gb2.hSpan(4).hAlign(131072).hGrab().label(0, "\u30b7\u30e3\u30c3\u30bf\u30fc\u89d2\u5ea6:");
        this._mblurAngleText = gb2.hSpan(3).hAlign(4).hGrab().text(2048, String.valueOf(this._settings.motionBlurShutterAngle));
        gb2.hSpan(9).hGrab().label(0, "\u00b0");
        gb2.hSpan(4).hAlign(131072).hGrab().label(0, "\u30b7\u30e3\u30c3\u30bf\u30fc\u30d5\u30a7\u30fc\u30ba:");
        this._mblurPhaseText = gb2.hSpan(3).hAlign(4).hGrab().text(2048, String.valueOf(this._settings.motionBlurShutterPhase));
        gb2.hSpan(9).hGrab().label(0, "\u00b0");
        gb2.hSpan(4).hAlign(131072).hGrab().label(0, "\u30b5\u30f3\u30d7\u30eb\u6570:");
        this._mblurSamplesText = gb2.hSpan(3).hAlign(4).hGrab().text(2048, String.valueOf(this._settings.motionBlurSamples));
        gb2.hSpan(9).hGrab().label(0, "\u30b5\u30f3\u30d7\u30eb\uff0f\u30d5\u30ec\u30fc\u30e0");
        this._modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositionWizardPage.this.doValidate((Control)e.getSource());
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompositionWizardPage.this.doValidate((Control)e.getSource());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompositionWizardPage.this.doValidate((Control)e.getSource());
            }
        };
        this._nameText.addModifyListener(this._modifyListener);
        this._widthText.addModifyListener(this._modifyListener);
        this._heightText.addModifyListener(this._modifyListener);
        this._freezeRatio.addSelectionListener(selectionListener);
        this._fpsCombo.addModifyListener(this._modifyListener);
        this._fpsCombo.addSelectionListener(selectionListener);
        this._durationText.addModifyListener(this._modifyListener);
        this._mblurAngleText.addModifyListener(this._modifyListener);
        this._mblurPhaseText.addModifyListener(this._modifyListener);
        this._mblurSamplesText.addModifyListener(this._modifyListener);
        Composite grid = gb.getComposite();
        grid.setTabList(gb.getTabList());
        Composite grid2 = gb2.getComposite();
        grid2.setTabList(gb2.getTabList());
        this.doValidate(null);
        this.setControl((Control)grid);
    }

    private void doValidate(Control control) {
        double fps;
        int height;
        int width;
        this.setPageComplete(false);
        String wStr = this._widthText.getText().trim();
        try {
            width = Integer.parseInt(wStr);
        }
        catch (NumberFormatException numberFormatException) {
            width = 0;
        }
        String hStr = this._heightText.getText().trim();
        try {
            height = Integer.parseInt(hStr);
        }
        catch (NumberFormatException numberFormatException) {
            height = 0;
        }
        boolean frozen = this._freezeRatio.getSelection();
        if (frozen) {
            if (control == this._widthText && width > 0) {
                height = Math.max(1, width * this._heightRatio / this._widthRatio);
                this._heightText.removeModifyListener(this._modifyListener);
                this._heightText.setText(String.valueOf(height));
                this._heightText.addModifyListener(this._modifyListener);
            } else if (control == this._heightText && height > 0) {
                width = Math.max(1, height * this._widthRatio / this._heightRatio);
                this._widthText.removeModifyListener(this._modifyListener);
                this._widthText.setText(String.valueOf(width));
                this._widthText.addModifyListener(this._modifyListener);
            }
        } else if ((control == null || control == this._widthText || control == this._heightText) && width > 0 && height > 0) {
            int gcd = this.gcd(width, height);
            this._widthRatio = width / gcd;
            this._heightRatio = height / gcd;
            this._freezeRatio.setText(String.format("\u7e26\u6a2a\u6bd4\u3092%d:%d\u306b\u56fa\u5b9a", this._widthRatio, this._heightRatio));
            this._freezeRatio.getParent().layout(new Control[]{this._freezeRatio});
        }
        String fpsStr = this._fpsCombo.getText().trim();
        try {
            fps = Double.parseDouble(fpsStr);
        }
        catch (NumberFormatException numberFormatException) {
            fps = 0.0;
        }
        String durationStr = this._durationText.getText().trim();
        long frames = 0L;
        if (fps >= 1.0 && durationStr.length() > 0) {
            Time frameDuration = FrameRateComboUtil.toFrameDuration(fpsStr);
            frames = TimeCode.parseTimeCode((String)durationStr, (Time)frameDuration);
            String timeCode = TimeCode.toTimeCode((Time)Time.fromFrameNumber((long)frames, (Time)frameDuration), (Time)frameDuration);
            int base = (int)Math.round((double)frameDuration.timeScale / (double)frameDuration.timeValue);
            boolean drop = timeCode.indexOf(59) != -1;
            this._duration2.setText(String.format("= %s (\u30d9\u30fc\u30b9 %d%s) , %d\u30d5\u30ec\u30fc\u30e0", timeCode, base, drop ? "\u30c9\u30ed\u30c3\u30d7" : "", frames));
            if (control == this._fpsCombo && !durationStr.matches("[\\d]+")) {
                this._durationText.removeModifyListener(this._modifyListener);
                this._durationText.setText(timeCode);
                this._durationText.addModifyListener(this._modifyListener);
            }
        }
        if (this._nameText.getText().trim().length() == 0) {
            this.setErrorMessage("\u540d\u524d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (wStr.length() == 0) {
            this.setErrorMessage("\u5e45\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (width < 1 || width > 8192) {
            this.setErrorMessage(String.format("\u5e45\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192));
            return;
        }
        if (hStr.length() == 0) {
            this.setErrorMessage("\u9ad8\u3055\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (height < 1 || height > 8192) {
            this.setErrorMessage(String.format("\u9ad8\u3055\u306b\u306f1\u304b\u3089%d\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002", 8192));
            return;
        }
        if (fpsStr.length() == 0) {
            this.setErrorMessage("\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (fps < 1.0) {
            this.setErrorMessage("\u30d5\u30ec\u30fc\u30e0\u30ec\u30fc\u30c8\u306b\u306f1\u4ee5\u4e0a\u306e\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        if (durationStr.length() == 0) {
            this.setErrorMessage("\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return;
        }
        if (frames <= 0L) {
            this.setErrorMessage("\u30c7\u30e5\u30ec\u30fc\u30b7\u30e7\u30f3\u306f1\u30d5\u30ec\u30fc\u30e0\u4ee5\u4e0a\u5fc5\u8981\u3067\u3059\u3002");
            return;
        }
        String angleStr = this._mblurAngleText.getText().trim();
        double angle = Double.NaN;
        try {
            angle = Double.parseDouble(angleStr);
        }
        catch (NumberFormatException numberFormatException) {}
        if (Double.isNaN(angle) || angle < 0.0 || angle > 720.0) {
            this.setErrorMessage("\u30b7\u30e3\u30c3\u30bf\u30fc\u89d2\u5ea6\u306b\u306f0\u304b\u3089720\u307e\u3067\u306e\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        String phaseStr = this._mblurPhaseText.getText().trim();
        double phase = Double.NaN;
        try {
            phase = Double.parseDouble(phaseStr);
        }
        catch (NumberFormatException numberFormatException) {}
        if (Double.isNaN(phase) || phase < -360.0 || phase > 360.0) {
            this.setErrorMessage("\u30b7\u30e3\u30c3\u30bf\u30fc\u30d5\u30a7\u30fc\u30ba\u306b\u306f-360\u304b\u3089360\u307e\u3067\u306e\u6570\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        String samplesStr = this._mblurSamplesText.getText().trim();
        int samples = 0;
        try {
            samples = Integer.parseInt(samplesStr);
        }
        catch (NumberFormatException numberFormatException) {}
        if (samples < 2 || samples > 64) {
            this.setErrorMessage("\u30b5\u30f3\u30d7\u30eb\u6570\u306b\u306f2\u304b\u308964\u307e\u3067\u306e\u6574\u6570\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private int gcd(int x, int y) {
        while (y != 0) {
            int t = x % y;
            x = y;
            y = t;
        }
        return x;
    }

    public CompositionSettings getResult() {
        if (!this.isPageComplete()) {
            return null;
        }
        CompositionSettings result = new CompositionSettings();
        Time frameDuration = FrameRateComboUtil.toFrameDuration(this._fpsCombo.getText().trim());
        long frames = TimeCode.parseTimeCode((String)this._durationText.getText().trim(), (Time)frameDuration);
        result.name = this._nameText.getText().trim();
        result.size = new Size2i(Integer.parseInt(this._widthText.getText().trim()), Integer.parseInt(this._heightText.getText().trim()));
        result.frameDuration = frameDuration;
        result.duration = Time.fromFrameNumber((long)frames, (Time)frameDuration);
        result.colorMode = ColorMode.values()[this._colorModeCombo.getSelectionIndex()];
        result.frameDurationPreserved = this._fpsPreserved.getSelection();
        result.motionBlurShutterAngle = Double.parseDouble(this._mblurAngleText.getText().trim());
        result.motionBlurShutterPhase = Double.parseDouble(this._mblurPhaseText.getText().trim());
        result.motionBlurSamples = Integer.parseInt(this._mblurSamplesText.getText().trim());
        return result;
    }
}

