/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.layercomp.AnimatableStringElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.widgets.InPlaceEditorShell;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.Util;
import java.util.regex.Pattern;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class TextSourceElementDelegate
extends AnimatableStringElementDelegate {
    private static final Pattern LF = Pattern.compile("\\n");
    private static final Pattern CR_OR_CRLF = Pattern.compile("\\r\\n?");
    private Point editorSize = new Point(300, 200);

    public TextSourceElementDelegate(AnimatableValueElement element, String name, AnimatableString avalue) {
        super(element, name, avalue);
    }

    protected void openInPlaceEditor() {
        final Shell shell = InPlaceEditorShell.create((Control)this.element.viewer.getTree(), (Rectangle)this.valueArea.get(this.valueIndex), this.editorSize.x, this.editorSize.y, true);
        shell.setMinimumSize(100, 100);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 5;
        fillLayout.marginHeight = 5;
        shell.setLayout((Layout)fillLayout);
        final Text text = new Text((Composite)shell, 2818);
        text.setTabs(4);
        String str = LF.matcher((CharSequence)this.valueWithoutExpr).replaceAll(Text.DELIMITER);
        text.setText(str);
        text.selectAll();
        text.addModifyListener(new ModifyListener(){
            private final String relation = Util.randomId();

            public void modifyText(ModifyEvent e) {
                String value = CR_OR_CRLF.matcher(text.getText()).replaceAll("\n");
                TextSourceElementDelegate.this.modifyValue(value, this.relation);
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TextSourceElementDelegate.this.editorSize = shell.getSize();
            }
        });
        shell.open();
    }

    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return false;
        }
        return super.canEdit(columnIndex);
    }
}

