/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.ClearEffectKeyframesOperation;
import ch.kuramo.javie.app.project.ModifyEffectAnimatableValueOperation;
import ch.kuramo.javie.app.project.ModifyEffectExpressionOperation;
import ch.kuramo.javie.app.project.ModifyEffectKeyframeOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.app.views.layercomp.AngleElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableBooleanElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableColorElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableDoubleElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableEnumElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableIntegerElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableLayerReferenceElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableStringElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableVec2dElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableVec3dElementDelegate;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.Tiny2DManipulatorElementDelegate;
import ch.kuramo.javie.app.views.layercomp.XYLinkableVec2dElementDelegate;
import ch.kuramo.javie.core.AnimatableBoolean;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableEnum;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableLayerReference;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.AnimatableVec3d;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.PropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectAnimatableValueElement
extends AnimatableValueElement {
    protected final EffectableLayer layer;
    protected final Effect effect;
    protected final PropertyDescriptor descriptor;

    public EffectAnimatableValueElement(Element parent, EffectableLayer layer, Effect effect, PropertyDescriptor descriptor) {
        super(parent);
        this.layer = layer;
        this.effect = effect;
        this.descriptor = descriptor;
    }

    @Override
    protected AnimatableValueElementDelegate<?> createDelegate() {
        AnimatableValue avalue = (AnimatableValue)this.descriptor.get(this.effect);
        String label = this.descriptor.getLabel();
        String unit = this.descriptor.getString("unit");
        double increment = 1.0;
        String incStr = this.descriptor.getString("increment");
        if (incStr != null) {
            try {
                increment = Double.parseDouble(incStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int displayPrecision = 1;
        String dpStr = this.descriptor.getString("displayPrecision");
        if (dpStr != null) {
            try {
                displayPrecision = Integer.parseInt(dpStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int editorPrecision = 4;
        String epStr = this.descriptor.getString("editorPrecision");
        if (epStr != null) {
            try {
                editorPrecision = Integer.parseInt(epStr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (avalue instanceof AnimatableVec3d) {
            return new AnimatableVec3dElementDelegate(this, label, (AnimatableVec3d)avalue, true, increment, displayPrecision, editorPrecision, unit);
        }
        if (avalue instanceof AnimatableVec2d) {
            if (Boolean.valueOf(this.descriptor.getString("tiny2DManipulator")).booleanValue()) {
                return new Tiny2DManipulatorElementDelegate(this, label, (AnimatableVec2d)avalue, increment, displayPrecision, editorPrecision, unit);
            }
            if (Boolean.valueOf(this.descriptor.getString("xyLinkable")).booleanValue()) {
                return new XYLinkableVec2dElementDelegate(this, label, (AnimatableVec2d)avalue, increment, displayPrecision, editorPrecision, unit);
            }
            return new AnimatableVec2dElementDelegate(this, label, (AnimatableVec2d)avalue, increment, displayPrecision, editorPrecision, unit);
        }
        if (avalue instanceof AnimatableDouble) {
            if (Boolean.valueOf(this.descriptor.getString("angleControl")).booleanValue()) {
                return new AngleElementDelegate(this, label, (AnimatableDouble)avalue, increment, displayPrecision, editorPrecision, unit);
            }
            return new AnimatableDoubleElementDelegate(this, label, (AnimatableDouble)avalue, increment, displayPrecision, editorPrecision, unit);
        }
        if (avalue instanceof AnimatableInteger) {
            return new AnimatableIntegerElementDelegate(this, label, (AnimatableInteger)avalue, (int)increment, unit);
        }
        if (avalue instanceof AnimatableString) {
            return new AnimatableStringElementDelegate((AnimatableValueElement)this, label, (AnimatableString)avalue);
        }
        if (avalue instanceof AnimatableBoolean) {
            return new AnimatableBooleanElementDelegate((AnimatableValueElement)this, label, (AnimatableBoolean)avalue);
        }
        if (avalue instanceof AnimatableColor) {
            return new AnimatableColorElementDelegate((AnimatableValueElement)this, label, (AnimatableColor)avalue);
        }
        if (avalue instanceof AnimatableEnum) {
            AnimatableEnumElementDelegate delegate = new AnimatableEnumElementDelegate((AnimatableValueElement)this, label, (AnimatableEnum)avalue);
            return delegate;
        }
        if (avalue instanceof AnimatableLayerReference) {
            return new AnimatableLayerReferenceElementDelegate((AnimatableValueElement)this, label, (AnimatableLayerReference)avalue);
        }
        throw new JavieRuntimeException("unsupported property type: " + avalue.getClass().getName());
    }

    @Override
    protected ProjectOperation createModifyValueOperation(ProjectManager pm, Object newValue, String relation) {
        return new ModifyEffectAnimatableValueOperation<Object>(pm, this.layer, this.layer.getEffects().indexOf(this.effect), this.descriptor.getName(), newValue, relation, this.descriptor.getLabel());
    }

    @Override
    protected ProjectOperation createModifyExpressionOperation(ProjectManager pm, String newExpr) {
        return new ModifyEffectExpressionOperation(pm, this.layer, this.layer.getEffects().indexOf(this.effect), this.descriptor.getName(), newExpr);
    }

    @Override
    protected ProjectOperation createModifyKeyframeOperation(ProjectManager pm, Time time, Object newValue, String relation) {
        return new ModifyEffectKeyframeOperation<Object>(pm, this.layer, this.layer.getEffects().indexOf(this.effect), this.descriptor.getName(), time, newValue, relation, this.descriptor.getLabel());
    }

    @Override
    protected ProjectOperation createClearKeyframesOperation(ProjectManager pm) {
        return new ClearEffectKeyframesOperation(pm, this.layer, this.layer.getEffects().indexOf(this.effect), this.descriptor.getName());
    }

    @Override
    protected String getDefaultExpression() {
        return "thisEffect." + this.descriptor.getName();
    }

    public EffectableLayer getLayer() {
        return this.layer;
    }

    public int getEffectIndex() {
        return this.layer.getEffects().indexOf(this.effect);
    }

    public String getProperty() {
        return this.descriptor.getName();
    }
}

