/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftLayerTimesOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Entry> _entries = Util.newList();
    private volatile Time _deltaTime;

    public ShiftLayerTimesOperation(ProjectManager projectManager, LayerComposition comp, List<Layer> layers, Time deltaTime, String relation) {
        super(projectManager, "\u30ec\u30a4\u30e4\u30fc\u6642\u9593\u306e\u5909\u66f4", relation);
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._deltaTime = deltaTime;
        for (Layer layer : layers) {
            if (projectManager.checkLayer(layer) != comp) {
                throw new IllegalArgumentException();
            }
            this._entries.add(new Entry(layer));
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.shiftOrRestore(true, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.shiftOrRestore(false, project, pm);
        return Status.OK_STATUS;
    }

    private void shiftOrRestore(boolean shift, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List layers = Util.newList();
        for (Entry e : this._entries) {
            Layer layer = comp.getLayer(e.layerId);
            layer.setStartTime(shift ? this._deltaTime.add(e.startTime) : e.startTime);
            layer.setInPoint(shift ? this._deltaTime.add(e.inPoint) : e.inPoint);
            layer.setOutPoint(shift ? this._deltaTime.add(e.outPoint) : e.outPoint);
            Iterator<Set<Keyframe<?>>> it = e.keyframes.iterator();
            for (String property : PropertyUtil.getLayerPropertyNames(layer)) {
                Object o = PropertyUtil.getProperty(layer, property);
                if (!(o instanceof AnimatableValue)) continue;
                AnimatableValue avalue = (AnimatableValue)o;
                Set origKeyframes = it.next();
                if (shift) {
                    this.shiftKeyframes(avalue, origKeyframes);
                    continue;
                }
                this.restore(avalue, origKeyframes);
            }
            if (layer instanceof EffectableLayer) {
                for (Effect effect : ((EffectableLayer)layer).getEffects()) {
                    for (PropertyDescriptor pd : effect.getEffectDescriptor().getPropertyDescriptors()) {
                        Object o = pd.get(effect);
                        if (!(o instanceof AnimatableValue)) continue;
                        AnimatableValue avalue = (AnimatableValue)o;
                        Set origKeyframes = it.next();
                        if (shift) {
                            this.shiftKeyframes(avalue, origKeyframes);
                            continue;
                        }
                        this.restore(avalue, origKeyframes);
                    }
                }
            }
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
    }

    private <V> void shiftKeyframes(AnimatableValue<V> avalue, Set<Keyframe<V>> origKeyframes) {
        avalue.clearKeyframes(avalue.getStaticValue());
        for (Keyframe<V> kf : origKeyframes) {
            avalue.putKeyframe(new Keyframe(this._deltaTime.add(kf.time), kf.value, kf.interpolation));
        }
    }

    private <V> void restore(AnimatableValue<V> avalue, Set<Keyframe<V>> origKeyframes) {
        avalue.clearKeyframes(avalue.getStaticValue());
        for (Keyframe<V> kf : origKeyframes) {
            avalue.putKeyframe(kf);
        }
    }

    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            try {
                this.executeOrRedo(monitor, info, project, null);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            return true;
        }
        ShiftLayerTimesOperation newOp = (ShiftLayerTimesOperation)operation;
        if (!newOp._deltaTime.equals((Object)this._deltaTime)) {
            this._deltaTime = newOp._deltaTime;
            try {
                this.executeOrRedo(monitor, info, project, pm);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            this._noEffect = this._deltaTime.timeValue == 0L;
        }
        return true;
    }

    private static class Entry {
        final String layerId;
        final Time startTime;
        final Time inPoint;
        final Time outPoint;
        final List<Set<Keyframe<?>>> keyframes = Util.newList();

        Entry(Layer layer) {
            this.layerId = layer.getId();
            this.startTime = layer.getStartTime();
            this.inPoint = layer.getInPoint();
            this.outPoint = layer.getOutPoint();
            for (String property : PropertyUtil.getLayerPropertyNames(layer)) {
                Object o = PropertyUtil.getProperty(layer, property);
                if (!(o instanceof AnimatableValue)) continue;
                AnimatableValue avalue = (AnimatableValue)o;
                this.keyframes.add(Util.newSet(avalue.getKeyframeMap().values()));
            }
            if (layer instanceof EffectableLayer) {
                for (Effect effect : ((EffectableLayer)layer).getEffects()) {
                    for (PropertyDescriptor pd : effect.getEffectDescriptor().getPropertyDescriptors()) {
                        Object o = pd.get(effect);
                        if (!(o instanceof AnimatableValue)) continue;
                        AnimatableValue avalue = (AnimatableValue)o;
                        this.keyframes.add(Util.newSet(avalue.getKeyframeMap().values()));
                    }
                }
            }
        }
    }
}

