/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftKeyframesOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Entry<?>> _entries;
    private volatile Time _deltaTime;

    public ShiftKeyframesOperation(ProjectManager projectManager, LayerComposition comp, Object[][] keyframeData, Time deltaTime, String relation) {
        super(projectManager, "\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306e\u79fb\u52d5", relation);
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._deltaTime = deltaTime;
        List entries = null;
        if (keyframeData != null) {
            if (this._deltaTime.timeValue != 0L) {
                entries = Util.newList();
                Object[][] objectArray = keyframeData;
                int n = keyframeData.length;
                int n2 = 0;
                while (n2 < n) {
                    Object[] data = objectArray[n2];
                    Layer layer = (Layer)data[0];
                    if (projectManager.checkLayer(layer) != comp) {
                        throw new IllegalArgumentException();
                    }
                    Entry entry = new Entry(layer, data);
                    entries.add(entry);
                    ++n2;
                }
            } else {
                this._noEffect = true;
            }
        }
        this._entries = entries;
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.shiftKeyframesOrRestore(true, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.shiftKeyframesOrRestore(false, project, pm);
        return Status.OK_STATUS;
    }

    private void shiftKeyframesOrRestore(boolean shift, Project project, ProjectManager pm) throws ExecutionException {
        if (this._entries == null) {
            throw new IllegalStateException();
        }
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        boolean fire = pm != null;
        List data = fire ? Util.newList() : null;
        for (Entry<?> e : this._entries) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer(e.layerId);
            if (e.effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, e.property);
            } else {
                AnimatableValue tmp;
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(e.effectIndex);
                PropertyDescriptor pd = effect.getEffectDescriptor().getPropertyDescriptor(e.property);
                avalue = tmp = (AnimatableValue)pd.get(effect);
            }
            Entry<?> eo = e;
            List<Time> times = shift ? this.shiftKeyframesOrRestore(true, avalue, eo, fire) : this.shiftKeyframesOrRestore(false, avalue, eo, fire);
            if (!fire) continue;
            data.add(new Object[]{layer, e.effectIndex, e.property, times});
        }
        if (fire) {
            pm.fireKeyframesChange(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
    }

    private <V> List<Time> shiftKeyframesOrRestore(boolean shift, AnimatableValue<V> avalue, Entry<V> entry, boolean returnTimes) {
        ArrayList<Time> tmp;
        avalue.clearKeyframes(avalue.getStaticValue());
        for (Keyframe kf : entry.restOfKeyframes) {
            avalue.putKeyframe(kf);
        }
        ArrayList<Time> times = returnTimes ? new ArrayList(entry.keyframesToShift.size()) : (tmp = new ArrayList<Time>(){

            @Override
            public boolean add(Time o) {
                return false;
            }
        });
        if (shift) {
            for (Keyframe kf : entry.keyframesToShift) {
                Time time = this._deltaTime.add(kf.time);
                avalue.putKeyframe(new Keyframe(time, kf.value, kf.interpolation));
                times.add(time);
            }
        } else {
            for (Keyframe kf : entry.keyframesToShift) {
                avalue.putKeyframe(kf);
                times.add(kf.time);
            }
        }
        return returnTimes ? times : null;
    }

    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            try {
                this.executeOrRedo(monitor, info, project, null);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            return true;
        }
        ShiftKeyframesOperation newOp = (ShiftKeyframesOperation)operation;
        if (newOp._entries != null) {
            throw new IllegalStateException();
        }
        if (!newOp._deltaTime.equals((Object)this._deltaTime)) {
            this._deltaTime = newOp._deltaTime;
            try {
                this.executeOrRedo(monitor, info, project, pm);
            }
            catch (ExecutionException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            this._noEffect = this._deltaTime.timeValue == 0L;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<V> {
        final String layerId;
        final int effectIndex;
        final String property;
        final Set<Keyframe<V>> keyframesToShift;
        final Set<Keyframe<V>> restOfKeyframes;

        Entry(Layer layer, Object[] data) {
            AnimatableValue avalue;
            Set tmp;
            this.layerId = layer.getId();
            this.effectIndex = (Integer)data[1];
            this.property = (String)data[2];
            this.keyframesToShift = tmp = (Set)data[3];
            if (this.effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, this.property);
            } else {
                AnimatableValue tmp2;
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(this.effectIndex);
                PropertyDescriptor pd = effect.getEffectDescriptor().getPropertyDescriptor(this.property);
                avalue = tmp2 = (AnimatableValue)pd.get(effect);
            }
            this.restOfKeyframes = Util.newSet(avalue.getKeyframeMap().values());
            this.restOfKeyframes.removeAll(this.keyframesToShift);
        }
    }
}

