/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseLayerTimeOperation
extends ProjectOperation {
    private final String _compId;
    private final Set<LayerEntry> _layers = Util.newSet();
    private final Set<PropertyEntry> _properties = Util.newSet();
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public ReverseLayerTimeOperation(ProjectManager pm, Set<Layer> layers) {
        super(pm, "\u30ec\u30a4\u30e4\u30fc\u306e\u6642\u9593\u53cd\u8ee2");
        InjectorHolder.getInjector().injectMembers((Object)this);
        if (layers.isEmpty()) {
            this._compId = null;
            this._noEffect = true;
            return;
        }
        LayerComposition comp = pm.checkLayer(layers.iterator().next());
        this._compId = comp.getId();
        for (Layer layer : layers) {
            if (pm.checkLayer(layer) != comp) {
                throw new IllegalArgumentException();
            }
            this._layers.add(new LayerEntry(layer.getId(), layer.getStartTime(), layer.getRate()));
            for (String property : PropertyUtil.getLayerPropertyNames(layer)) {
                AnimatableValue avalue;
                Object o = PropertyUtil.getProperty(layer, property);
                if (!(o instanceof AnimatableValue) || !(avalue = (AnimatableValue)o).hasKeyframe()) continue;
                this._properties.add(new PropertyEntry(layer.getId(), -1, property, this._encoder.encodeElement((Object)avalue)));
            }
            if (!(layer instanceof EffectableLayer)) continue;
            List effects = ((EffectableLayer)layer).getEffects();
            int i = 0;
            while (i < effects.size()) {
                Effect e = (Effect)effects.get(i);
                for (PropertyDescriptor pd : e.getEffectDescriptor().getPropertyDescriptors()) {
                    AnimatableValue avalue;
                    Object o = pd.get(e);
                    if (!(o instanceof AnimatableValue) || !(avalue = (AnimatableValue)o).hasKeyframe()) continue;
                    this._properties.add(new PropertyEntry(layer.getId(), i, pd.getName(), this._encoder.encodeElement((Object)avalue)));
                }
                ++i;
            }
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.reverseKeyframes(project, pm);
        this.reverseLayers(project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.restoreKeyframes(project, pm);
        this.restoreLayers(project, pm);
        return Status.OK_STATUS;
    }

    private void reverseKeyframes(Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List data = pm != null ? Util.newList() : null;
        for (PropertyEntry e : this._properties) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer(e.layerId);
            if (e.effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, e.property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(e.effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, e.property);
            }
            Time inPoint = layer.getInPoint();
            Time outPoint = layer.getOutPoint();
            List keyframes = Util.newList(avalue.getKeyframeMap().values());
            avalue.clearKeyframes(avalue.getStaticValue());
            for (Keyframe kf : keyframes) {
                avalue.putKeyframe(outPoint.subtract(kf.time.subtract(inPoint)), kf.value, kf.interpolation);
            }
            if (pm == null) continue;
            Object[] objectArray = new Object[4];
            objectArray[0] = layer;
            objectArray[1] = e.effectIndex;
            objectArray[2] = e.property;
            data.add(objectArray);
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
    }

    private void restoreKeyframes(Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        List data = pm != null ? Util.newList() : null;
        for (PropertyEntry e : this._properties) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer(e.layerId);
            if (e.effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, e.property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(e.effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, e.property);
            }
            this.restore(e.data, avalue);
            if (pm == null) continue;
            Object[] objectArray = new Object[4];
            objectArray[0] = layer;
            objectArray[1] = e.effectIndex;
            objectArray[2] = e.property;
            data.add(objectArray);
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
    }

    private <A extends AnimatableValue<V>, V> void restore(String data, A dst) throws ExecutionException {
        try {
            AnimatableValue src = (AnimatableValue)this._decoder.decodeElement((CharSequence)data, dst.getClass());
            dst.reset(src.getStaticValue());
            dst.setExpression(src.getExpression());
            for (Keyframe kf : src.getKeyframeMap().values()) {
                dst.putKeyframe(kf);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding AnimatableValue data", (Throwable)e);
        }
    }

    private void reverseLayers(Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Set layers = Util.newSet();
        for (LayerEntry e : this._layers) {
            MediaInput mi;
            Time duration;
            Layer layer = comp.getLayer(e.layerId);
            Time newStartTime = null;
            Time oldStartTime = layer.getStartTime();
            Time inPoint = layer.getInPoint();
            Time outPoint = layer.getOutPoint();
            if (layer instanceof MediaLayer && (duration = (mi = ((MediaLayer)layer).getMediaInput()).getDuration()) != null) {
                Time endTime = oldStartTime.add(new Time((long)((double)duration.timeValue / Math.abs(e.rate)), duration.timeScale));
                newStartTime = inPoint.subtract(endTime.subtract(outPoint));
            }
            if (newStartTime == null) {
                newStartTime = outPoint.add(inPoint.subtract(oldStartTime));
            }
            layer.setStartTime(newStartTime);
            layer.setRate(-e.rate);
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
    }

    private void restoreLayers(Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Set layers = Util.newSet();
        for (LayerEntry e : this._layers) {
            Layer layer = comp.getLayer(e.layerId);
            layer.setStartTime(e.startTime);
            layer.setRate(e.rate);
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
    }

    private static class LayerEntry {
        private final String layerId;
        private final Time startTime;
        private final double rate;

        private LayerEntry(String layerId, Time startTime, double rate) {
            this.layerId = layerId;
            this.startTime = startTime;
            this.rate = rate;
        }
    }

    private static class PropertyEntry {
        private final String layerId;
        private final int effectIndex;
        private final String property;
        private final String data;

        public PropertyEntry(String layerId, int effectIndex, String property, String data) {
            this.layerId = layerId;
            this.effectIndex = effectIndex;
            this.property = property;
            this.data = data;
        }
    }
}

