/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.TASelector;
import ch.kuramo.javie.core.TextAnimator;
import ch.kuramo.javie.core.TextLayer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RenameTASelectorOperation
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final int _animatorIndex;
    private final int _selectorIndex;
    private final String _oldName;
    private final String _newName;

    public RenameTASelectorOperation(ProjectManager pm, TextLayer layer, TextAnimator animator, TASelector selector, String newName) {
        super(pm, "\u30bb\u30ec\u30af\u30bf\u306e\u540d\u524d\u3092\u5909\u66f4");
        LayerComposition comp = pm.checkLayer((Layer)layer);
        int animatorIndex = layer.getTextAnimators().indexOf(animator);
        if (animatorIndex == -1) {
            throw new IllegalArgumentException("no such TextAnimator found in the layer");
        }
        int selectorIndex = animator.getSelectors().indexOf(selector);
        if (selectorIndex == -1) {
            throw new IllegalArgumentException("no such TASelector found in the TextAnimator");
        }
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._animatorIndex = animatorIndex;
        this._selectorIndex = selectorIndex;
        this._oldName = selector.getName();
        this._newName = newName;
        this._noEffect = newName.equals(this._oldName);
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setSelectorName(this._newName, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.setSelectorName(this._oldName, project, pm);
        return Status.OK_STATUS;
    }

    private void setSelectorName(String name, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        TextLayer layer = (TextLayer)comp.getLayer(this._layerId);
        TextAnimator animator = (TextAnimator)layer.getTextAnimators().get(this._animatorIndex);
        TASelector selector = (TASelector)animator.getSelectors().get(this._selectorIndex);
        selector.setName(name);
        if (pm != null) {
            pm.fireLayerPropertyChange((Layer)layer, String.format("textAnimators[%d].selectors[%d].name", this._animatorIndex, this._selectorIndex));
        }
    }
}

