/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveEffectsOperation
extends ProjectOperation {
    private final String _compId;
    private final List<int[]> _srcData;
    private final String _dstLayerId;
    private final int _dstIndex;

    public MoveEffectsOperation(ProjectManager pm, List<EffectableLayer> srcLayers, List<Effect> effects, EffectableLayer dstLayer, int moveBefore) {
        super(pm, "\u30a8\u30d5\u30a7\u30af\u30c8\u306e\u79fb\u52d5");
        if (srcLayers.size() != effects.size()) {
            throw new IllegalArgumentException();
        }
        if (srcLayers.isEmpty()) {
            this._noEffect = true;
            this._compId = null;
            this._srcData = null;
            this._dstLayerId = null;
            this._dstIndex = 0;
            return;
        }
        LayerComposition comp = pm.checkLayer((Layer)srcLayers.get(0));
        if (pm.checkLayer((Layer)dstLayer) != comp) {
            throw new IllegalArgumentException();
        }
        this._compId = comp.getId();
        this._srcData = Util.newList();
        this._dstLayerId = dstLayer.getId();
        int dstEffectCount = dstLayer.getEffects().size();
        int dstIndex = moveBefore < 0 || moveBefore > dstEffectCount ? (moveBefore = dstEffectCount) : moveBefore;
        ListIterator<EffectableLayer> it = srcLayers.listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            EffectableLayer srcLayer = it.next();
            int layerIndex = comp.getLayers().indexOf(srcLayer);
            if (layerIndex == -1) {
                throw new IllegalArgumentException();
            }
            int effectIndex = srcLayer.getEffects().indexOf(effects.get(i));
            if (effectIndex == -1) {
                throw new IllegalArgumentException();
            }
            this._srcData.add(new int[]{layerIndex, effectIndex});
            if (srcLayer != dstLayer || effectIndex >= moveBefore) continue;
            --dstIndex;
        }
        this._dstIndex = dstIndex;
        Collections.sort(this._srcData, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                int compare = o1[0] - o2[0];
                return compare != 0 ? compare : o2[1] - o1[1];
            }
        });
        List tmp = Util.newList((Collection)dstLayer.getEffects());
        tmp.removeAll(effects);
        tmp.addAll(this._dstIndex, effects);
        this._noEffect = dstLayer.getEffects().equals(tmp);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        EffectableLayer dstLayer = (EffectableLayer)comp.getLayer(this._dstLayerId);
        List data1 = null;
        List data2 = null;
        if (pm != null) {
            data1 = Util.newList();
            data2 = Util.newList();
        }
        List effects = Util.newList();
        for (int[] srcData : this._srcData) {
            EffectableLayer srcLayer = (EffectableLayer)comp.getLayers().get(srcData[0]);
            effects.add(0, (Effect)srcLayer.getEffects().remove(srcData[1]));
            if (pm == null) continue;
            data1.add(new Object[]{srcLayer, -1});
            data2.add(new Object[]{dstLayer, this._dstIndex + data2.size()});
        }
        if (pm != null) {
            pm.fireEffectsRemove(comp, (Object[][])data1.toArray((T[])new Object[data1.size()][]));
        }
        dstLayer.getEffects().addAll(this._dstIndex, effects);
        if (pm != null) {
            pm.fireEffectsAdd(comp, (Object[][])data2.toArray((T[])new Object[data2.size()][]));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        EffectableLayer dstLayer = (EffectableLayer)comp.getLayer(this._dstLayerId);
        List data = null;
        if (pm != null) {
            data = Util.newList();
        }
        List sublist = dstLayer.getEffects().subList(this._dstIndex, this._dstIndex + this._srcData.size());
        List effects = Util.newList(sublist);
        sublist.clear();
        if (pm != null) {
            pm.fireEffectsRemove(comp, new Object[][]{{dstLayer, -1}});
        }
        ListIterator<int[]> it = this._srcData.listIterator(this._srcData.size());
        while (it.hasPrevious()) {
            int[] srcData = it.previous();
            EffectableLayer srcLayer = (EffectableLayer)comp.getLayers().get(srcData[0]);
            srcLayer.getEffects().add(srcData[1], (Effect)effects.remove(0));
            if (pm == null) continue;
            data.add(new Object[]{srcLayer, srcData[1]});
        }
        if (pm != null) {
            pm.fireEffectsAdd(comp, (Object[][])data.toArray((T[])new Object[data.size()][]));
        }
        return Status.OK_STATUS;
    }
}

