/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.misc;

import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.widgets.GridBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.arnx.jsonic.JSON;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.TwitterApi;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class Twitter {
    private static final String TWITTER_TOKEN = "TWITTER_TOKEN";
    private static final String TWITTER_SECRET = "TWITTER_SECRET";
    private static final String TWITTER_COMP_PROGRESS_ENABLED = "TWITTER_COMP_PROGRESS_ENABLED";
    private static final String TWITTER_COMP_PROGRESS_TEMPLATE = "TWITTER_COMP_PROGRESS_TEMPLATE";
    private static final String TWITTER_COMP_PROGRESS_INTERVAL = "TWITTER_COMP_PROGRESS_INTERVAL";
    private static final String TWITTER_FINISH_COMP_ENABLED = "TWITTER_FINISH_COMP_ENABLED";
    private static final String TWITTER_FINISH_COMP_TEMPLATE = "TWITTER_FINISH_COMP_TEMPLATE";
    private static final String TWITTER_FINISH_BATCH_ENABLED = "TWITTER_FINISH_BATCH_ENABLED";
    private static final String TWITTER_FINISH_BATCH_TEMPLATE = "TWITTER_FINISH_BATCH_TEMPLATE";
    private static IPreferenceStore prefStore;
    private static OAuthService oauthService;
    private static ExecutorService executorService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OAuthService getOAuthService() {
        Class<Twitter> clazz = Twitter.class;
        synchronized (Twitter.class) {
            if (oauthService == null) {
                oauthService = new ServiceBuilder().provider(TwitterApi.class).apiKey("lGTFxMSmzFATgw1Qf1Mnq").apiSecret("kMuOAuAse8jJFMOPqyUktojMyRfTf0qEGoYw1L4FvS").build();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return oauthService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getExecutorService() {
        Class<Twitter> clazz = Twitter.class;
        synchronized (Twitter.class) {
            if (executorService == null) {
                executorService = Executors.newSingleThreadExecutor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }

    public static int getCompProgressInterval() {
        return prefStore.getInt(TWITTER_COMP_PROGRESS_INTERVAL);
    }

    public static void compProgress(String compName, String fileName, double progressInPercent) {
        if (compName == null) {
            throw new NullPointerException();
        }
        if (fileName == null) {
            throw new NullPointerException();
        }
        Twitter.updateStatus(compName, fileName, progressInPercent);
    }

    public static void finishComp(String compName, String fileName, long timeInSeconds) {
        if (compName == null) {
            throw new NullPointerException();
        }
        if (fileName == null) {
            throw new NullPointerException();
        }
        Twitter.updateStatus(compName, fileName, timeInSeconds);
    }

    public static void finishBatch(long timeInSeconds) {
        Twitter.updateStatus(null, null, timeInSeconds);
    }

    public static void updateStatus(final String compName, final String fileName, final Number timeOrPercent) {
        Twitter.getExecutorService().submit(new Runnable(){

            public void run() {
                try {
                    Response response;
                    OAuthRequest request;
                    String token = prefStore.getString(Twitter.TWITTER_TOKEN);
                    String secret = prefStore.getString(Twitter.TWITTER_SECRET);
                    if (token.length() == 0 || secret.length() == 0) {
                        return;
                    }
                    boolean prog = timeOrPercent instanceof Double;
                    boolean comp = compName != null;
                    if (!prefStore.getBoolean(prog ? Twitter.TWITTER_COMP_PROGRESS_ENABLED : (comp ? Twitter.TWITTER_FINISH_COMP_ENABLED : Twitter.TWITTER_FINISH_BATCH_ENABLED))) {
                        return;
                    }
                    OAuthService oauth = Twitter.getOAuthService();
                    Token accessToken = new Token(token, secret);
                    String status = prefStore.getString(prog ? Twitter.TWITTER_COMP_PROGRESS_TEMPLATE : (comp ? Twitter.TWITTER_FINISH_COMP_TEMPLATE : Twitter.TWITTER_FINISH_BATCH_TEMPLATE));
                    if (status.contains("$screen_name")) {
                        request = new OAuthRequest(Verb.GET, "http://api.twitter.com/1/account/verify_credentials.json");
                        oauth.signRequest(accessToken, request);
                        response = request.send();
                        if (!response.isSuccessful()) {
                            return;
                        }
                        Map map = (Map)JSON.decode((String)response.getBody());
                        status = status.replaceAll("\\$screen_name", map.get("screen_name").toString());
                    }
                    if (prog) {
                        status = status.replaceAll("\\$percent", String.format("%.1f", timeOrPercent.doubleValue()));
                    } else {
                        long s = timeOrPercent.longValue();
                        long h = s / 3600L;
                        long m = (s %= 3600L) / 60L;
                        status = status.replaceAll("\\$time", h > 0L ? String.format("%d:%02d:%02d", h, m, s) : String.format("%d:%02d", m, s %= 60L));
                    }
                    if (comp) {
                        status = status.replaceAll("\\$comp_name", compName);
                        status = status.replaceAll("\\$file_name", fileName);
                    }
                    request = new OAuthRequest(Verb.POST, "https://api.twitter.com/1/statuses/update.json");
                    request.addBodyParameter("status", status);
                    oauth.signRequest(accessToken, request);
                    response = request.send();
                    response.isSuccessful();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public static class TwitterPreferenceInitializer
    extends AbstractPreferenceInitializer {
        public void initializeDefaultPreferences() {
            prefStore = Activator.getDefault().getPreferenceStore();
            prefStore.setDefault(Twitter.TWITTER_TOKEN, "");
            prefStore.setDefault(Twitter.TWITTER_SECRET, "");
            prefStore.setDefault(Twitter.TWITTER_COMP_PROGRESS_ENABLED, true);
            prefStore.setDefault(Twitter.TWITTER_COMP_PROGRESS_TEMPLATE, "\u51fa\u529b\u4e2d\uff1a$comp_name => $file_name ($percent%) #JavieOutput");
            prefStore.setDefault(Twitter.TWITTER_COMP_PROGRESS_INTERVAL, 10);
            prefStore.setDefault(Twitter.TWITTER_FINISH_COMP_ENABLED, true);
            prefStore.setDefault(Twitter.TWITTER_FINISH_COMP_TEMPLATE, "\u51fa\u529b\u5b8c\u4e86\uff1a$comp_name => $file_name ($time) #JavieOutput");
            prefStore.setDefault(Twitter.TWITTER_FINISH_BATCH_ENABLED, true);
            prefStore.setDefault(Twitter.TWITTER_FINISH_BATCH_TEMPLATE, "\u30d0\u30c3\u30c1\u51fa\u529b\u5b8c\u4e86 ($time) #JavieOutput");
        }
    }

    public static class TwitterPreferencePage
    extends PreferencePage
    implements IWorkbenchPreferencePage {
        private Button enabledButton;
        private Button progButton;
        private Text progText;
        private Label intervalLabel1;
        private Combo intervalCombo;
        private Label intervalLabel2;
        private Button compButton;
        private Text compText;
        private Button batchButton;
        private Text batchText;
        private String token;
        private String secret;

        public void init(IWorkbench workbench) {
        }

        protected Control createContents(Composite parent) {
            GridBuilder gb1 = new GridBuilder(parent, 1, false);
            ((GridLayout)gb1.getComposite().getLayout()).verticalSpacing = 0;
            this.enabledButton = gb1.hAlign(16384).button(32, "Twitter\u9023\u643a\u3092\u4f7f\u7528\u3059\u308b");
            Group group = gb1.hAlign(4).hGrab().group(0, null);
            FillLayout layout = new FillLayout(256);
            group.setLayout((Layout)layout);
            GridBuilder gb2 = new GridBuilder((Composite)group, 4, false);
            this.progButton = gb2.hSpan(1).hAlign(16384).button(32, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u51fa\u529b\u4e2d:");
            this.progText = gb2.hSpan(3).hAlign(4).hGrab().text(2048, "");
            gb2.hSpan(1).size(10, 10).composite(0);
            this.intervalLabel1 = gb2.hSpan(1).hAlign(131072).label(0, "\u6295\u7a3f\u9593\u9694:");
            this.intervalCombo = gb2.hSpan(1).hAlign(4).combo(8, 6, new String[]{"10", "20", "30", "40", "50", "60"}, "10");
            this.intervalLabel2 = gb2.hSpan(1).hAlign(16384).hGrab().label(0, "\u5206");
            this.compButton = gb2.hSpan(1).hAlign(16384).button(32, "\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u51fa\u529b\u5b8c\u4e86\u6642:");
            this.compText = gb2.hSpan(3).hAlign(4).hGrab().text(2048, "");
            this.batchButton = gb2.hSpan(1).hAlign(16384).button(32, "\u30d0\u30c3\u30c1\u51fa\u529b\u5b8c\u4e86\u6642:");
            this.batchText = gb2.hSpan(3).hAlign(4).hGrab().text(2048, "");
            this.performReset();
            this.enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = TwitterPreferencePage.this.enabledButton.getSelection();
                    if (enabled && (TwitterPreferencePage.this.token.length() == 0 || TwitterPreferencePage.this.secret.length() == 0) && !TwitterPreferencePage.this.authorize()) {
                        enabled = false;
                        TwitterPreferencePage.this.enabledButton.setSelection(false);
                    }
                    TwitterPreferencePage.this.enableControls(enabled);
                }
            });
            Composite grid2 = gb2.getComposite();
            grid2.setTabList(gb2.getTabList());
            Composite grid1 = gb1.getComposite();
            grid1.setTabList(gb1.getTabList());
            return grid1;
        }

        private void enableControls(boolean enabled) {
            this.progButton.setEnabled(enabled);
            this.progText.setEnabled(enabled);
            this.intervalLabel1.setEnabled(enabled);
            this.intervalCombo.setEnabled(enabled);
            this.intervalLabel2.setEnabled(enabled);
            this.compButton.setEnabled(enabled);
            this.compText.setEnabled(enabled);
            this.batchButton.setEnabled(enabled);
            this.batchText.setEnabled(enabled);
        }

        private void performReset() {
            this.token = prefStore.getString(Twitter.TWITTER_TOKEN);
            this.secret = prefStore.getString(Twitter.TWITTER_SECRET);
            boolean enabled = this.token.length() != 0 && this.secret.length() != 0;
            this.enabledButton.setSelection(enabled);
            this.enableControls(enabled);
            this.progButton.setSelection(prefStore.getBoolean(Twitter.TWITTER_COMP_PROGRESS_ENABLED));
            this.progText.setText(prefStore.getString(Twitter.TWITTER_COMP_PROGRESS_TEMPLATE));
            this.intervalCombo.select(prefStore.getInt(Twitter.TWITTER_COMP_PROGRESS_INTERVAL) / 10 - 1);
            this.compButton.setSelection(prefStore.getBoolean(Twitter.TWITTER_FINISH_COMP_ENABLED));
            this.compText.setText(prefStore.getString(Twitter.TWITTER_FINISH_COMP_TEMPLATE));
            this.batchButton.setSelection(prefStore.getBoolean(Twitter.TWITTER_FINISH_BATCH_ENABLED));
            this.batchText.setText(prefStore.getString(Twitter.TWITTER_FINISH_BATCH_TEMPLATE));
        }

        protected void performDefaults() {
            this.enabledButton.setSelection(false);
            this.enableControls(false);
            this.progButton.setSelection(prefStore.getDefaultBoolean(Twitter.TWITTER_COMP_PROGRESS_ENABLED));
            this.progText.setText(prefStore.getDefaultString(Twitter.TWITTER_COMP_PROGRESS_TEMPLATE));
            this.intervalCombo.select(prefStore.getDefaultInt(Twitter.TWITTER_COMP_PROGRESS_INTERVAL) / 10 - 1);
            this.compButton.setSelection(prefStore.getDefaultBoolean(Twitter.TWITTER_FINISH_COMP_ENABLED));
            this.compText.setText(prefStore.getDefaultString(Twitter.TWITTER_FINISH_COMP_TEMPLATE));
            this.batchButton.setSelection(prefStore.getDefaultBoolean(Twitter.TWITTER_FINISH_BATCH_ENABLED));
            this.batchText.setText(prefStore.getDefaultString(Twitter.TWITTER_FINISH_BATCH_TEMPLATE));
        }

        public boolean performOk() {
            if (this.enabledButton.getSelection()) {
                prefStore.setValue(Twitter.TWITTER_TOKEN, this.token);
                prefStore.setValue(Twitter.TWITTER_SECRET, this.secret);
            } else {
                if (this.token.length() != 0) {
                    this.secret.length();
                }
                this.token = "";
                this.secret = "";
                prefStore.setValue(Twitter.TWITTER_TOKEN, "");
                prefStore.setValue(Twitter.TWITTER_SECRET, "");
            }
            prefStore.setValue(Twitter.TWITTER_COMP_PROGRESS_ENABLED, this.progButton.getSelection());
            prefStore.setValue(Twitter.TWITTER_COMP_PROGRESS_TEMPLATE, this.progText.getText().trim());
            prefStore.setValue(Twitter.TWITTER_COMP_PROGRESS_INTERVAL, (this.intervalCombo.getSelectionIndex() + 1) * 10);
            prefStore.setValue(Twitter.TWITTER_FINISH_COMP_ENABLED, this.compButton.getSelection());
            prefStore.setValue(Twitter.TWITTER_FINISH_COMP_TEMPLATE, this.compText.getText().trim());
            prefStore.setValue(Twitter.TWITTER_FINISH_BATCH_ENABLED, this.batchButton.getSelection());
            prefStore.setValue(Twitter.TWITTER_FINISH_BATCH_TEMPLATE, this.batchText.getText().trim());
            return true;
        }

        private boolean authorize() {
            this.token = "";
            this.secret = "";
            OAuthService oauth = Twitter.getOAuthService();
            final Token requestToken = oauth.getRequestToken();
            String authUrl = oauth.getAuthorizationUrl(requestToken);
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = browserSupport.getExternalBrowser();
                browser.openURL(new URL(authUrl));
            }
            catch (PartInitException e) {
                e.printStackTrace();
                return false;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return false;
            }
            Dialog dialog = new Dialog(this.getShell()){
                private String pin;
                {
                    super($anonymous0);
                    this.pin = "";
                }

                protected void configureShell(Shell newShell) {
                    super.configureShell(newShell);
                    newShell.setText("Twitter / \u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u8a8d\u8a3c");
                }

                protected Control createDialogArea(Composite parent) {
                    Composite composite = (Composite)super.createDialogArea(parent);
                    GridBuilder gb = new GridBuilder(composite, 2, false);
                    String msg = "\u30d6\u30e9\u30a6\u30b6\u306b\u8868\u793a\u3055\u308c\u305f\u5185\u5bb9\u3092\u3088\u304f\u304a\u8aad\u307f\u306b\u306a\u308a\u3001Javie\u304c\u3042\u306a\u305f\u306e\u30a2\u30ab\u30a6\u30f3\u30c8\n\u3092\u5229\u7528\u3059\u308b\u3053\u3068\u3092\u8a31\u53ef\u3059\u308b\u5834\u5408\u306f\u300c\u9023\u643a\u30a2\u30d7\u30ea\u3092\u8a8d\u8a3c\u300d\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n\u305d\u3057\u3066\u3001\u8868\u793a\u3055\u308c\u305fPIN\u3092\u4ee5\u4e0b\u306b\u5165\u529b\u3057OK\u30dc\u30bf\u30f3\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002\n";
                    gb.hSpan(2).hAlign(4).label(0, msg);
                    gb.hSpan(1).hAlign(131072).label(0, "PIN:");
                    final Text pinText = gb.hSpan(1).hAlign(4).text(2048, "");
                    pinText.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            pin = pinText.getText().trim();
                        }
                    });
                    Composite grid = gb.getComposite();
                    grid.setTabList(gb.getTabList());
                    parent.pack();
                    return composite;
                }

                protected void okPressed() {
                    if (this.pin.length() == 0) {
                        Display.getCurrent().beep();
                        return;
                    }
                    try {
                        Token accessToken = Twitter.getOAuthService().getAccessToken(requestToken, new Verifier(this.pin));
                        TwitterPreferencePage.this.token = accessToken.getToken();
                        TwitterPreferencePage.this.secret = accessToken.getSecret();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)this.getShell(), (String)"\u30a8\u30e9\u30fc", (String)"\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u8a8d\u8a3c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    }
                    super.okPressed();
                }
            };
            dialog.open();
            return this.token.length() != 0 && this.secret.length() != 0;
        }
    }
}

