/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.BatchStore;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.misc.Twitter;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.output.Output;
import ch.kuramo.javie.core.output.ProgressMonitor;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutputAction<T extends Output>
extends Action {
    private static File defaultFolder;
    private final LayerCompositionView view;
    @Inject
    private Injector injector;
    @Inject
    private ProjectEncoder encoder;
    @Inject
    private ProjectDecoder decoder;

    public AbstractOutputAction(String text, LayerCompositionView view) {
        super(text);
        InjectorHolder.getInjector().injectMembers((Object)this);
        this.view = view;
    }

    protected IWorkbenchWindow getWindow() {
        return this.view.getSite().getWorkbenchWindow();
    }

    protected Composition getComposition() {
        return this.view.getCompositionItem().getComposition();
    }

    public void run() {
        File file;
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getWindow());
        if (pm == null) {
            return;
        }
        if (defaultFolder == null && (file = pm.getFile()) != null) {
            defaultFolder = file.getParentFile();
        }
        CompositionItem compItem = this.view.getCompositionItem();
        String fileName = compItem.getName();
        String defaultExtension = this.getDefaultExtension();
        if (defaultExtension != null && defaultExtension.length() > 0) {
            fileName = defaultExtension.startsWith(".") ? String.valueOf(fileName) + defaultExtension : String.valueOf(fileName) + "." + defaultExtension;
        }
        T output = this.createOutput(this.injector);
        output.setFile(new File(defaultFolder, fileName));
        Wizard wizard = this.createWizard(output);
        if (wizard != null) {
            WizardDialog dialog = new WizardDialog(this.getWindow().getShell(), (IWizard)wizard);
            if (dialog.open() != 0) {
                return;
            }
        } else {
            FileDialog dialog = this.createFileDialog(defaultFolder, fileName);
            String path = dialog.open();
            if (path == null) {
                return;
            }
            output.setFile(new File(path));
        }
        defaultFolder = output.getFile().getParentFile();
        if (output.isBatch()) {
            BatchStore.addBatch(pm, compItem.getId(), output);
        } else {
            this.doOutput(pm.getProject(), compItem.getId(), output);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doOutput(Project project, String compItemId, T output) {
        block11: {
            block10: {
                block12: {
                    copy = null;
                    try {
                        try {
                            start = System.currentTimeMillis();
                            copy = (Project)this.decoder.decodeElement((CharSequence)this.encoder.encodeElement((Object)project), Project.class);
                            copy.afterDecode();
                            compItem = (CompositionItem)copy.getItem(compItemId);
                            output.setComposition(compItem.getComposition());
                            dialog = new ProgressMonitorDialog(this.getWindow().getShell());
                            dialog.create();
                            dialog.getShell().setText("\u66f8\u304d\u51fa\u3057");
                            dialog.run(true, true, new IRunnableWithProgress((Output)output, compItem){
                                private final /* synthetic */ Output val$output;
                                private final /* synthetic */ CompositionItem val$compItem;
                                {
                                    this.val$output = output;
                                    this.val$compItem = compositionItem;
                                }

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    this.val$output.doOutput(AbstractOutputAction.this.createProgressMonitor(monitor, this.val$compItem.getName(), this.val$output.getFile().getName()));
                                    if (monitor.isCanceled()) {
                                        throw new InterruptedException();
                                    }
                                }
                            });
                            Twitter.finishComp(compItem.getName(), output.getFile().getName(), (System.currentTimeMillis() - start) / 1000L);
                            break block10;
                        }
                        catch (ProjectDecodeException e) {
                            throw new JavieRuntimeException((Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new JavieRuntimeException((Throwable)e);
                        }
                        catch (InterruptedException v0) {
                            if (copy == null) break block11;
                            ** for (i : copy.getItems())
                        }
                    }
                    catch (Throwable var9_16) {
                        if (copy == null) break block12;
                        ** for (i : copy.getItems())
                    }
lbl-1000:
                    // 1 sources

                    {
                        i.dispose();
                        continue;
lbl24:
                        // 1 sources

                        break block11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        i.dispose();
                        continue;
                    }
                }
                throw var9_16;
            }
            if (copy != null) {
                for (Item i : copy.getItems()) {
                    i.dispose();
                }
            }
        }
    }

    private ProgressMonitor createProgressMonitor(final IProgressMonitor monitor, final String compName, final String fileName) {
        return new ProgressMonitor(){
            private int totalWork;
            private int currentWork;
            private final long startTime = System.currentTimeMillis();
            private final int tweetInterval = Twitter.getCompProgressInterval();
            private int tweetCount = 0;

            public void beginTask(int totalWork) {
                monitor.beginTask(String.format("\u66f8\u304d\u51fa\u3057: %s => %s", compName, fileName), totalWork);
                this.totalWork = totalWork;
            }

            public void currentWork(int currentWork) {
                long time;
                if (currentWork > this.currentWork) {
                    monitor.worked(currentWork - this.currentWork);
                    monitor.subTask(AbstractOutputAction.this.getSubTaskText(currentWork, this.totalWork));
                    this.currentWork = currentWork;
                }
                if ((time = (System.currentTimeMillis() - this.startTime) / 60000L) >= (long)(this.tweetInterval * (this.tweetCount + 1))) {
                    Twitter.compProgress(compName, fileName, 100.0 * (double)currentWork / (double)this.totalWork);
                    ++this.tweetCount;
                }
            }

            public void done() {
                monitor.done();
            }

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
    }

    protected abstract String getDefaultExtension();

    protected abstract T createOutput(Injector var1);

    protected Wizard createWizard(T output) {
        return null;
    }

    protected FileDialog createFileDialog(File folder, String fileName) {
        String[] filterNames = new String[]{"\u3059\u3079\u3066\u306e\u30d5\u30a1\u30a4\u30eb"};
        String[] filterExtensions = new String[]{"*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterExtensions[filterExtensions.length - 1] = "*.*";
        }
        FileDialog dialog = new FileDialog(this.getWindow().getShell(), 8192);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(folder != null ? folder.getAbsolutePath() : null);
        dialog.setFileName(fileName);
        dialog.setOverwrite(true);
        return dialog;
    }

    protected String getSubTaskText(int currentWork, int totalWork) {
        return String.format("%.1f%%", 100.0 * (double)currentWork / (double)totalWork);
    }
}

