/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.app.Perspective;
import ch.kuramo.javie.app.RecentProjects;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveUtil {
    public static SaveStatus save(ProjectManager pm) {
        try {
            if (pm.getFile() != null) {
                pm.save();
                Perspective.saveForProject(pm);
                return SaveStatus.SAVED;
            }
            File file = SaveUtil.saveProjectDialog(SaveUtil.shell(pm), null, "\u540d\u79f0\u672a\u8a2d\u5b9a\u30d7\u30ed\u30b8\u30a7\u30af\u30c8.jvp");
            if (file != null) {
                pm.saveAs(file);
                Perspective.saveForProject(pm);
                RecentProjects.add(pm);
                return SaveStatus.SAVED;
            }
            return SaveStatus.CANCELED;
        }
        catch (IOException e) {
            UIUtil.errorDialog(SaveUtil.shell(pm), "Error", (Throwable)e);
            return SaveStatus.ERROR;
        }
    }

    public static SaveStatus saveAs(ProjectManager pm) {
        File file = pm.getFile();
        file = file == null ? SaveUtil.saveProjectDialog(SaveUtil.shell(pm), null, "\u540d\u79f0\u672a\u8a2d\u5b9a\u30d7\u30ed\u30b8\u30a7\u30af\u30c8.jvp") : SaveUtil.saveProjectDialog(SaveUtil.shell(pm), file.getParentFile().getAbsolutePath(), file.getName());
        if (file == null) {
            return SaveStatus.CANCELED;
        }
        try {
            pm.saveAs(file);
            Perspective.saveForProject(pm);
            RecentProjects.add(pm);
            return SaveStatus.SAVED;
        }
        catch (IOException e) {
            UIUtil.errorDialog(SaveUtil.shell(pm), "Error", (Throwable)e);
            return SaveStatus.ERROR;
        }
    }

    public static SaveStatus saveCopy(ProjectManager pm) {
        File file = pm.getFile();
        if (file == null) {
            file = SaveUtil.saveProjectDialog(SaveUtil.shell(pm), null, "\u540d\u79f0\u672a\u8a2d\u5b9a\u30d7\u30ed\u30b8\u30a7\u30af\u30c8.jvp");
        } else {
            String defaultName = file.getName().replaceFirst("^(.+?)(.[jJ][vV][pP])?$", "$1\u306e\u30b3\u30d4\u30fc$2");
            file = SaveUtil.saveProjectDialog(SaveUtil.shell(pm), file.getParentFile().getAbsolutePath(), defaultName);
        }
        if (file == null) {
            return SaveStatus.CANCELED;
        }
        try {
            pm.saveCopy(file);
            return SaveStatus.SAVED;
        }
        catch (IOException e) {
            UIUtil.errorDialog(SaveUtil.shell(pm), "Error", (Throwable)e);
            return SaveStatus.ERROR;
        }
    }

    public static SaveStatus saveIfDirty(ProjectManager pm) {
        if (!pm.isDirty()) {
            if (pm.getFile() != null) {
                Perspective.saveForProject(pm);
            }
            return SaveStatus.NOT_DIRTY;
        }
        File file = pm.getFile();
        String name = file != null ? file.getName() : "\u540d\u79f0\u672a\u8a2d\u5b9a\u30d7\u30ed\u30b8\u30a7\u30af\u30c8.jvp";
        String dialogMessage = String.format("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8 \u201c%s\u201d \u306b\u52a0\u3048\u305f\u5909\u66f4\u3092\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f", name);
        String[] buttonLabels = new String[]{"\u4fdd\u5b58", "\u4fdd\u5b58\u3057\u306a\u3044", "\u30ad\u30e3\u30f3\u30bb\u30eb"};
        MessageDialog dialog = new MessageDialog(SaveUtil.shell(pm), null, null, dialogMessage, 3, buttonLabels, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        switch (dialog.open()) {
            case 0: {
                return SaveUtil.save(pm);
            }
            case 1: {
                return SaveStatus.UNSAVED;
            }
        }
        return SaveStatus.CANCELED;
    }

    private static Shell shell(ProjectManager pm) {
        return pm.getWorkbenchWindow().getShell();
    }

    private static File saveProjectDialog(Shell parent, String defaultFolder, String defaultName) {
        String[] filterNames = new String[]{"Javie Project Files", "All Files (*)"};
        String[] filterExtensions = new String[]{"*.jvp", "*"};
        String platform = SWT.getPlatform();
        if (platform.equals("win32") || platform.equals("wpf")) {
            filterNames = new String[]{"Javie Project Files", "All Files (*.*)"};
            filterExtensions = new String[]{"*.jvp", "*.*"};
        }
        FileDialog dialog = new FileDialog(parent, 0x10002000);
        dialog.setFilterNames(filterNames);
        dialog.setFilterExtensions(filterExtensions);
        dialog.setFilterPath(defaultFolder);
        dialog.setFileName(defaultName);
        dialog.setOverwrite(true);
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveStatus {
        NOT_DIRTY,
        SAVED,
        UNSAVED,
        CANCELED,
        ERROR;

    }
}

