/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.identity;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.GUID;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.LongID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.NamespacePermission;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.identity.Activator;
import org.eclipse.osgi.util.NLS;

public class IDFactory
implements IIDFactory {
    public static final String SECURITY_PROPERTY;
    private static final int IDENTITY_CREATION_ERRORCODE = 2001;
    private static Hashtable namespaces;
    private static boolean securityEnabled;
    protected static IIDFactory instance;
    private static boolean initialized;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SECURITY_PROPERTY = String.valueOf(clazz.getName()) + ".security";
        namespaces = new Hashtable();
        securityEnabled = false;
        instance = null;
        instance = new IDFactory();
        IDFactory.addNamespace0(new StringID.StringIDNamespace());
        IDFactory.addNamespace0(new GUID.GUIDNamespace());
        IDFactory.addNamespace0(new LongID.LongNamespace());
        initialized = false;
    }

    private static synchronized void initialize() {
        if (!initialized) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", clazz, "initialize");
            Activator a = Activator.getDefault();
            if (a != null) {
                a.setupNamespaceExtensionPoint();
            }
            initialized = true;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.exiting("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", clazz2, "initialize");
        }
    }

    public static synchronized IIDFactory getDefault() {
        return instance;
    }

    private IDFactory() {
    }

    public Namespace addNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", (Class)clazz, "addNamespace", namespace);
        IDFactory.checkPermission(new NamespacePermission(namespace.toString(), "add"));
        IDFactory.initialize();
        Namespace result = IDFactory.addNamespace0(namespace);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/exiting", clazz2, "addNamespace", result);
        return result;
    }

    public static final Namespace addNamespace0(Namespace namespace) {
        if (namespace == null) {
            return null;
        }
        return namespaces.put(namespace.getName(), namespace);
    }

    protected static final void checkPermission(NamespacePermission namespacepermission) throws SecurityException {
        if (securityEnabled) {
            AccessController.checkPermission(namespacepermission);
        }
    }

    public boolean containsNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", (Class)clazz, "containsNamespace", namespace);
        IDFactory.checkPermission(new NamespacePermission(namespace.toString(), "contains"));
        IDFactory.initialize();
        boolean result = IDFactory.containsNamespace0(namespace);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/exiting", clazz2, "containsNamespace", new Boolean(result));
        return result;
    }

    public List getNamespaces() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", clazz, "getNamespaces");
        IDFactory.initialize();
        return new ArrayList(namespaces.values());
    }

    public static final boolean containsNamespace0(Namespace n) {
        if (n == null) {
            return false;
        }
        return namespaces.containsKey(n.getName());
    }

    public Namespace getNamespace(Namespace namespace) throws SecurityException {
        if (namespace == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", (Class)clazz, "getNamespace", namespace);
        IDFactory.checkPermission(new NamespacePermission(namespace.toString(), "get"));
        IDFactory.initialize();
        Namespace result = IDFactory.getNamespace0(namespace);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/exiting", clazz2, "getNamespace", result);
        return result;
    }

    public Namespace getNamespaceByName(String name) throws SecurityException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", (Class)clazz, "getNamespaceByName", name);
        IDFactory.initialize();
        Namespace result = IDFactory.getNamespace0(name);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/exiting", clazz2, "getNamespaceByName", result);
        return result;
    }

    protected static final Namespace getNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return (Namespace)namespaces.get(n.getName());
    }

    protected static final Namespace getNamespace0(String name) {
        if (name == null) {
            return null;
        }
        return (Namespace)namespaces.get(name);
    }

    public ID createGUID() throws IDCreateException {
        return this.createGUID(20);
    }

    public ID createGUID(int length) throws IDCreateException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", clazz, "createGUID", new Integer(length));
        GUID.GUIDNamespace namespace = new GUID.GUIDNamespace();
        ID result = this.createID((Namespace)namespace, (Object[])new Integer[]{new Integer(length)});
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/exiting", clazz2, "createGUID", result);
        return result;
    }

    protected static void logAndThrow(String s, Throwable t) throws IDCreateException {
        IDCreateException e = null;
        e = t != null ? new IDCreateException(String.valueOf(s) + ": " + t.getClass().getName() + ": " + t.getMessage(), t) : new IDCreateException(s);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.throwing("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/exceptions/throwing", clazz, "logAndThrow", e);
        Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.identity", 2001, s, (Throwable)e));
        throw e;
    }

    public ID createID(Namespace n, Object[] args) throws IDCreateException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", clazz, "createID", new Object[]{n, Trace.getArgumentsString(args)});
        if (n == null) {
            IDFactory.logAndThrow("Namespace cannot be null", null);
        }
        IDFactory.initialize();
        Namespace ns = IDFactory.getNamespace0(n);
        if (ns == null) {
            IDFactory.logAndThrow(NLS.bind((String)"Namespace {0} not found", (Object)n.getName()), null);
        }
        ID result = ns.createInstance(args);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/exiting", clazz2, "createID", result);
        return result;
    }

    public ID createID(String namespaceName, Object[] args) throws IDCreateException {
        Namespace n = this.getNamespaceByName(namespaceName);
        if (n == null) {
            throw new IDCreateException(NLS.bind((String)"Namespace {0} not found", (Object)namespaceName));
        }
        return this.createID(n, args);
    }

    public ID createID(Namespace namespace, String uri) throws IDCreateException {
        return this.createID(namespace, new Object[]{uri});
    }

    public ID createID(String namespace, String uri) throws IDCreateException {
        return this.createID(namespace, new Object[]{uri});
    }

    public ID createStringID(String idstring) throws IDCreateException {
        if (idstring == null) {
            throw new IDCreateException("StringID cannot be null");
        }
        StringID.StringIDNamespace n = new StringID.StringIDNamespace();
        return this.createID((Namespace)n, (Object[])new String[]{idstring});
    }

    public ID createLongID(long l) throws IDCreateException {
        LongID.LongNamespace n = new LongID.LongNamespace();
        return this.createID((Namespace)n, (Object[])new Long[]{new Long(l)});
    }

    public Namespace removeNamespace(Namespace n) throws SecurityException {
        if (n == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/entering", (Class)clazz, "removeNamespace", n);
        IDFactory.checkPermission(new NamespacePermission(n.toString(), "remove"));
        IDFactory.initialize();
        Namespace result = IDFactory.removeNamespace0(n);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.core.identity.IDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting("org.eclipse.ecf.identity", "org.eclipse.ecf.identity/debug/methods/exiting", clazz2, "removeNamespace", result);
        return result;
    }

    protected static final Namespace removeNamespace0(Namespace n) {
        if (n == null) {
            return null;
        }
        return (Namespace)namespaces.remove(n.getName());
    }
}

