/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.output.PushSourceOutput;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class JavaSoundWaveOutput
extends PushSourceOutput {
    private PipedOutputStream outputStream;
    private WaveOutputThread outputThread;
    @Inject
    private IArrayPools _arrayPools;

    protected void initialize() {
        Composition comp = this.getComposition();
        AudioMode audioMode = this.getAudioMode();
        File file = this.getFile();
        if (audioMode != AudioMode.STEREO_48KHZ_INT16) {
            throw new UnsupportedOperationException("STEREO_48KHZ_INT16 is only supported.");
        }
        if (file.exists()) {
            file.delete();
        }
        Time duration = comp.getDuration();
        long totalFrames = duration.toFrameNumber(audioMode.sampleDuration);
        this.outputStream = new PipedOutputStream();
        try {
            this.outputThread = new WaveOutputThread(this.outputStream, audioMode, totalFrames, file);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        this.outputThread.start();
    }

    protected void finish() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        try {
            this.outputThread.join();
        }
        catch (InterruptedException e) {
            throw new JavieRuntimeException(e);
        }
        Exception e = this.outputThread.exception;
        if (e != null) {
            throw new JavieRuntimeException(e);
        }
    }

    public boolean isVideoEnabled() {
        return false;
    }

    public void setVideoEnabled(boolean videoEnabled) {
        throw new UnsupportedOperationException("can't change videoEnabled");
    }

    public boolean isAudioEnabled() {
        return true;
    }

    public void setAudioEnabled(boolean audioEnabled) {
        throw new UnsupportedOperationException("can't change audioEnabled");
    }

    protected void writeVideo(long frameNumber, Time time, IVideoBuffer vb) {
        throw new UnsupportedOperationException();
    }

    protected void writeAudio(long frameNumber, Time time, IAudioBuffer ab) {
        try {
            this.writeAudio(ab);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private void writeAudio(IAudioBuffer ab) throws IOException {
        AudioMode audioMode = ab.getAudioMode();
        int dataLen = ab.getDataLength();
        int dataLenInBytes = dataLen * audioMode.sampleSize;
        IArray pa = this._arrayPools.getByteArray(dataLenInBytes);
        byte[] outBuf = (byte[])pa.getArray();
        switch (audioMode.dataType) {
            case SHORT: {
                ByteBuffer.wrap(outBuf, 0, dataLenInBytes).order(ByteOrder.nativeOrder()).asShortBuffer().put((short[])ab.getData(), 0, dataLen);
                break;
            }
            case INT: {
                int[] data = (int[])ab.getData();
                int i = 0;
                while (i < dataLen) {
                    outBuf[i * 2] = (byte)(data[i] >>> 16 & 0xFF);
                    outBuf[i * 2 + 1] = (byte)(data[i] >>> 24 & 0xFF);
                    ++i;
                }
                break;
            }
            case FLOAT: {
                float[] data = (float[])ab.getData();
                int i = 0;
                while (i < dataLen) {
                    short shortVal = (short)(Math.min(Math.max((double)data[i], -1.0), 1.0) * 32767.0);
                    outBuf[i * 2] = (byte)(shortVal & 0xFF);
                    outBuf[i * 2 + 1] = (byte)(shortVal >>> 8 & 0xFF);
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
            }
        }
        this.outputStream.write(outBuf, 0, dataLenInBytes);
        pa.release();
    }

    private static class WaveOutputThread
    extends Thread {
        private final PipedInputStream inputStream;
        private final AudioMode audioMode;
        private final long totalFrames;
        private final File file;
        private Exception exception;

        private WaveOutputThread(PipedOutputStream src, AudioMode audioMode, long totalFrames, File file) throws IOException {
            this.inputStream = new PipedInputStream(src);
            this.audioMode = audioMode;
            this.totalFrames = totalFrames;
            this.file = file;
        }

        public void run() {
            AudioFormat format = new AudioFormat(this.audioMode.sampleRate, this.audioMode.sampleSize * 8, this.audioMode.channels, true, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
            AudioInputStream ais = new AudioInputStream(this.inputStream, format, this.totalFrames);
            try {
                try {
                    AudioSystem.write(ais, AudioFileFormat.Type.WAVE, this.file);
                }
                catch (IOException e) {
                    this.exception = e;
                    try {
                        ais.close();
                    }
                    catch (IOException e2) {
                        this.exception = e2;
                    }
                }
            }
            finally {
                try {
                    ais.close();
                }
                catch (IOException e) {
                    this.exception = e;
                }
            }
        }
    }
}

