/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.misc;

import ch.kuramo.javie.core.JavieRuntimeException;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import org.scannotation.ClasspathUrlFinder;

public class ScannotationBugFix {
    public static void patch() {
        try {
            ClassLoader loader = ClasspathUrlFinder.class.getClassLoader();
            ClassPool pool = new ClassPool();
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass targetClass = pool.get("org.scannotation.archiveiterator.FileProtocolIteratorFactory");
            CtClass urlClass = pool.get("java.net.URL");
            CtClass filterClass = pool.get("org.scannotation.archiveiterator.Filter");
            CtMethod method = targetClass.getDeclaredMethod("create", new CtClass[]{urlClass, filterClass});
            method.instrument(new ExprEditor(){

                public void edit(MethodCall m) throws CannotCompileException {
                    if (m.getClassName().equals("java.net.URL") && m.getMethodName().equals("getPath")) {
                        m.replace("$_ = $0.toURI().getPath();");
                    }
                }
            });
            targetClass.toClass(loader, null);
        }
        catch (NotFoundException e) {
            throw new JavieRuntimeException(e);
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private ScannotationBugFix() {
    }
}

