/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.services.IPerlinNoise;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.internal.services.NoiseTexture;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import noise.ImprovedNoise;

public class PerlinNoiseImpl
implements IPerlinNoise {
    @Inject
    public PerlinNoiseImpl(IShaderRegistry shaders) {
        String[] source = this.getSource();
        shaders.registerShader("ch.kuramo.javie.api.services.INoiseTexture.vs_func", ShaderType.VERTEX_SHADER, source);
        shaders.registerShader("ch.kuramo.javie.api.services.INoiseTexture.fs_func", ShaderType.FRAGMENT_SHADER, source);
    }

    private String[] getSource() {
        String[] source;
        String name = "/ch/kuramo/javie/core/shaders/noise.glsl";
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            throw new JavieRuntimeException("no such resource found: " + name);
        }
        try {
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            finally {
                br.close();
            }
            source = lines.toArray(new String[lines.size()]);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        if (source.length == 0) {
            throw new JavieRuntimeException("Source is empty.");
        }
        int i = 0;
        while (i < source.length) {
            if (!source[i].endsWith("\n")) {
                int n = i;
                source[n] = String.valueOf(source[n]) + "\n";
            }
            ++i;
        }
        return source;
    }

    public int getPermTexture() {
        return NoiseTexture.getPermTexture();
    }

    public double noise(double x, double y, double z) {
        return ImprovedNoise.noise(x, y, z);
    }
}

