/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.core.internal.services.AntiAliasSupportImpl;
import com.google.inject.Inject;
import com.google.inject.Injector;

public class AntiAliasSupportProxy
implements IAntiAliasSupport {
    private static final ThreadLocal<AntiAliasSupportImpl> _threadLocal = new ThreadLocal();

    private AntiAliasSupportImpl getImpl() {
        AntiAliasSupportImpl impl = _threadLocal.get();
        if (impl == null) {
            throw new IllegalStateException("No AntiAliasSupportImpl exist on this thread.");
        }
        return impl;
    }

    public void antiAlias(int width, int height, boolean depthTest, Color clearColor, Runnable operation) {
        this.getImpl().antiAlias(width, height, depthTest, clearColor, operation);
    }

    public void antiAlias(int width, int height, Runnable operation) {
        this.getImpl().antiAlias(width, height, operation);
    }

    static class Lifecycle {
        private final Injector _injector;

        @Inject
        Lifecycle(Injector injector) {
            this._injector = injector;
        }

        void createImpl() {
            if (_threadLocal.get() != null) {
                throw new IllegalStateException("AntiAliasSupportImpl already exists on this thread.");
            }
            AntiAliasSupportImpl impl = (AntiAliasSupportImpl)this._injector.getInstance(AntiAliasSupportImpl.class);
            _threadLocal.set(impl);
        }

        void disposeImpl() {
            AntiAliasSupportImpl impl = (AntiAliasSupportImpl)_threadLocal.get();
            if (impl != null) {
                impl.dispose();
                _threadLocal.set(null);
            }
        }
    }
}

