/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import javax.media.opengl.GL2;

public class AntiAliasSupportImpl
implements IAntiAliasSupport {
    private static final boolean MACOSX = System.getProperty("os.name").toLowerCase().replaceAll("\\s+", "").contains("macosx");
    private final RenderContext context;
    private final int samples;
    private int frameBuffer;
    private final int[] renderBuffer = new int[2];
    private final int[] internalFormat = new int[2];
    private final int[] width = new int[2];
    private final int[] height = new int[2];

    @Inject
    public AntiAliasSupportImpl(RenderContext context, GLGlobal glGlobal) {
        this.context = context;
        int samples = Math.min(glGlobal.getMaxSamples(), 8);
        this.samples = samples > 1 ? samples : 0;
    }

    void dispose() {
        GL2 gl = this.context.getGL().getGL2();
        int i = 0;
        while (i < 2) {
            this.internalFormat[i] = 0;
            this.width[i] = 0;
            this.height[i] = 0;
            if (this.renderBuffer[i] != 0) {
                gl.glDeleteRenderbuffers(1, new int[]{this.renderBuffer[i]}, 0);
                this.renderBuffer[i] = 0;
            }
            ++i;
        }
        if (this.frameBuffer != 0) {
            gl.glDeleteFramebuffers(1, new int[]{this.frameBuffer}, 0);
            this.frameBuffer = 0;
        }
    }

    private int getFrameBuffer(GL2 gl) {
        if (this.frameBuffer == 0) {
            int[] fb = new int[1];
            gl.glGenFramebuffers(1, fb, 0);
            this.frameBuffer = fb[0];
        }
        return this.frameBuffer;
    }

    private int getRenderBuffer(GL2 gl, int i, int internalFormat, int width, int height) {
        if (this.renderBuffer[i] == 0) {
            int[] rb = new int[1];
            gl.glGenRenderbuffers(1, rb, 0);
            this.renderBuffer[i] = rb[0];
        }
        if (internalFormat != this.internalFormat[i] || width != this.width[i] || height != this.height[i]) {
            gl.glBindRenderbuffer(36161, this.renderBuffer[i]);
            if (this.samples > 1) {
                gl.glRenderbufferStorageMultisample(36161, this.samples, internalFormat, width, height);
            } else {
                gl.glRenderbufferStorage(36161, internalFormat, width, height);
            }
            this.internalFormat[i] = internalFormat;
            this.width[i] = width;
            this.height[i] = height;
        }
        return this.renderBuffer[i];
    }

    private int getColorRenderBuffer(GL2 gl, int width, int height) {
        width = Math.max(width, this.width[0]);
        height = Math.max(height, this.height[0]);
        return this.getRenderBuffer(gl, 0, this.context.getColorMode().glInternalFormat, width, height);
    }

    private int getDepthRenderBuffer(GL2 gl) {
        int internalFormat = this.context.getColorMode() == ColorMode.RGBA32_FLOAT ? 33191 : 6402;
        return this.getRenderBuffer(gl, 1, internalFormat, this.width[0], this.height[0]);
    }

    private int getDepthRenderBuffer(GL2 gl, int width, int height) {
        int internalFormat = this.context.getColorMode() == ColorMode.RGBA32_FLOAT ? 33191 : 6402;
        width = Math.max(width, this.width[1]);
        height = Math.max(height, this.height[1]);
        return this.getRenderBuffer(gl, 1, internalFormat, width, height);
    }

    private void clear(GL2 gl, boolean clearDepth, Color clearColor) {
        int bits = 0;
        if (clearDepth) {
            gl.glClearDepth(1.0);
            bits |= 0x100;
        }
        if (clearColor != null) {
            float a = (float)clearColor.a;
            float r = (float)clearColor.r * a;
            float g = (float)clearColor.g * a;
            float b = (float)clearColor.b * a;
            gl.glClearColor(r, g, b, a);
            bits |= 0x4000;
        }
        if (bits != 0) {
            gl.glClear(bits);
        }
    }

    public void antiAlias(int width, int height, boolean depthTest, Color clearColor, Runnable operation) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (this.samples == 0) {
            this.runWithoutMultisample(width, height, depthTest, clearColor, operation);
            return;
        }
        GL2 gl = this.context.getGL().getGL2();
        int[] current = new int[3];
        gl.glGetIntegerv(36006, current, 0);
        gl.glGetIntegerv(36010, current, 1);
        gl.glGetIntegerv(36007, current, 2);
        try {
            int fb = this.getFrameBuffer(gl);
            gl.glBindFramebuffer(36009, fb);
            gl.glPushAttrib(0x4000 | (depthTest ? 8448 : 0));
            try {
                gl.glFramebufferRenderbuffer(36009, 36064, 36161, this.getColorRenderBuffer(gl, width, height));
                gl.glDrawBuffer(36064);
                if (depthTest) {
                    gl.glFramebufferRenderbuffer(36009, 36096, 36161, this.getDepthRenderBuffer(gl));
                    gl.glEnable(2929);
                } else if (MACOSX && this.renderBuffer[1] != 0) {
                    gl.glFramebufferRenderbuffer(36009, 36096, 36161, this.getDepthRenderBuffer(gl));
                }
                this.clear(gl, depthTest, clearColor);
                operation.run();
                gl.glBindFramebuffer(36008, fb);
                gl.glBindFramebuffer(36009, current[0]);
                gl.glBlitFramebuffer(0, 0, width, height, 0, 0, width, height, 16384, 9728);
            }
            finally {
                gl.glFramebufferRenderbuffer(36009, 36096, 36161, 0);
                gl.glFramebufferRenderbuffer(36009, 36064, 36161, 0);
                gl.glPopAttrib();
            }
        }
        finally {
            gl.glBindRenderbuffer(36161, current[2]);
            gl.glBindFramebuffer(36008, current[1]);
            gl.glBindFramebuffer(36009, current[0]);
        }
    }

    public void antiAlias(int width, int height, Runnable operation) {
        this.antiAlias(width, height, false, Color.COLORLESS_TRANSPARENT, operation);
    }

    private void runWithoutMultisample(int width, int height, boolean depthTest, Color clearColor, Runnable operation) {
        GL2 gl = this.context.getGL().getGL2();
        gl.glPushAttrib(0x4000 | (depthTest ? 8448 : 0));
        try {
            if (depthTest) {
                gl.glFramebufferRenderbuffer(36009, 36096, 36161, this.getDepthRenderBuffer(gl, width, height));
                gl.glEnable(2929);
            }
            this.clear(gl, depthTest, clearColor);
            operation.run();
        }
        finally {
            if (depthTest) {
                gl.glFramebufferRenderbuffer(36009, 36096, 36161, 0);
            }
            gl.glPopAttrib();
        }
    }
}

