/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsMediaFoundationSource
implements MediaSource {
    private static final Logger logger = LoggerFactory.getLogger(WindowsMediaFoundationSource.class);
    private static final boolean disabled = Boolean.getBoolean("javie.mfsrc.disabled");
    private static final boolean sysMem = !Boolean.getBoolean("javie.mfsrc.noSysMem");
    private static final int bufferFrames = Math.max(1, Integer.getInteger("javie.mfsrc.bufferFrames", 2));
    private static final int cacheFrames = Math.max(1, Integer.getInteger("javie.mfsrc.cacheFrames", 3)) + bufferFrames;
    private VideoThread videoThread;
    private VideoBounds bounds;
    private boolean topDown;
    private Time duration;
    private Time videoFrameDuration;
    private AudioThread audioThread;
    private AudioFormat audioFormat;
    private boolean audioFloat;
    private AudioMode audioMode;
    private AudioInputStream audioStream;
    private long audioStreamPosition;
    private final RenderContext context;
    private final IVideoRenderSupport vrSupport;
    private final GLGlobal glGlobal;
    private final AudioRenderSupport arSupport;
    private final IArrayPools arrayPools;

    static {
        System.loadLibrary("MediaFoundationSource");
    }

    @Inject
    public WindowsMediaFoundationSource(RenderContext context, IVideoRenderSupport vrSupport, GLGlobal glGlobal, AudioRenderSupport arSupport, IArrayPools arrayPools) {
        this.context = context;
        this.vrSupport = vrSupport;
        this.glGlobal = glGlobal;
        this.arSupport = arSupport;
        this.arrayPools = arrayPools;
    }

    public boolean initialize(File file) {
        AudioThread at;
        if (disabled) {
            return false;
        }
        VideoThread vt = new VideoThread();
        if (!vt.initialize(file)) {
            vt = null;
            String name = file.getName().toLowerCase();
            if (name.endsWith(".avi")) {
                return false;
            }
        }
        if (!(at = new AudioThread()).initialize(file)) {
            at = null;
        }
        if (vt == null && at == null) {
            return false;
        }
        this.videoThread = vt;
        this.audioThread = at;
        return true;
    }

    public void dispose() {
        if (this.videoThread != null) {
            this.videoThread.shutdown();
            this.videoThread = null;
        }
        if (this.audioThread != null) {
            this.closeAudioStream();
            this.audioThread.shutdown();
            this.audioThread = null;
        }
    }

    private void closeAudioStream() {
        if (this.audioStream != null) {
            try {
                this.audioStream.close();
            }
            catch (IOException e) {
                logger.warn("failed to close AudioInputStream", (Throwable)e);
            }
            this.audioStream = null;
        }
        this.audioStreamPosition = 0L;
    }

    public boolean isVideoAvailable() {
        return this.videoThread != null;
    }

    public boolean isAudioAvailable() {
        return this.audioThread != null;
    }

    public Time getDuration(MediaOptions options) {
        return this.duration;
    }

    public Time getVideoFrameDuration(MediaOptions options) {
        return this.videoFrameDuration;
    }

    public VideoBounds getVideoFrameBounds(MediaOptions options) {
        return this.bounds;
    }

    public IVideoBuffer getVideoFrame(Time mediaTime, MediaOptions options) {
        if (this.videoThread == null) {
            return null;
        }
        if (mediaTime.timeValue < 0L || !mediaTime.before(this.duration)) {
            IVideoBuffer vb = this.vrSupport.createVideoBuffer(this.bounds, ColorMode.RGBA8);
            vb.clear();
            return vb;
        }
        FrameSurface fs = this.videoThread.lockFrame(mediaTime.toFrameNumber(this.videoFrameDuration));
        if (fs == null) {
            IVideoBuffer vb = this.vrSupport.createVideoBuffer(this.bounds, ColorMode.RGBA8);
            vb.clear();
            return vb;
        }
        int pitch = fs.buffer.capacity() / 4 / this.bounds.height;
        IVideoBuffer vb = this.vrSupport.createVideoBuffer(new VideoBounds(pitch, this.bounds.height), ColorMode.RGBA8);
        try {
            int dstTexture = vb.getTexture();
            GL2 gl = this.context.getGL().getGL2();
            if (this.glGlobal.isIntel()) {
                int[] current = new int[1];
                gl.glGetIntegerv(32873, current, 0);
                try {
                    gl.glBindTexture(3553, dstTexture);
                    gl.glTexSubImage2D(3553, 0, 0, 0, pitch, this.bounds.height, 32993, 5121, (Buffer)fs.buffer);
                }
                finally {
                    gl.glBindTexture(3553, current[0]);
                }
            }
            int[] pbo = new int[1];
            int[] current = new int[2];
            gl.glGetIntegerv(35055, current, 0);
            gl.glGetIntegerv(32873, current, 1);
            try {
                gl.glGenBuffers(1, pbo, 0);
                gl.glBindBuffer(35052, pbo[0]);
                gl.glBindTexture(3553, dstTexture);
                gl.glBufferData(35052, (long)fs.buffer.capacity(), null, sysMem ? 35040 : 35042);
                ByteBuffer mappedPBO = gl.glMapBuffer(35052, 35001);
                mappedPBO.put(fs.buffer);
                gl.glUnmapBuffer(35052);
                gl.glTexImage2D(3553, 0, 32856, pitch, this.bounds.height, 0, 32993, 5121, 0L);
                this.videoThread.unlockFrame(fs);
                fs = null;
            }
            finally {
                gl.glBindTexture(3553, current[1]);
                gl.glBindBuffer(35052, current[0]);
                if (pbo[0] != 0) {
                    gl.glDeleteBuffers(1, pbo, 0);
                }
            }
            Resolution resolution = this.context.getVideoResolution();
            boolean flipVert = options.isFlipVertical() ^ !this.topDown;
            if (pitch != this.bounds.width || resolution.scale != 1.0 || flipVert) {
                IVideoBuffer iVideoBuffer = this.convertByResolutionAndOptions(vb, pitch, resolution, flipVert);
                return iVideoBuffer;
            }
            IVideoBuffer result = vb;
            vb = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (fs != null) {
                this.videoThread.unlockFrame(fs);
            }
            if (vb != null) {
                vb.dispose();
            }
        }
    }

    private IVideoBuffer convertByResolutionAndOptions(IVideoBuffer srcBuffer, int srcPitch, Resolution resolution, final boolean flipVert) {
        final VideoBounds srcBounds = srcBuffer.getBounds();
        final VideoBounds dstBounds = resolution.scale(this.bounds);
        final float scale = (float)resolution.scale;
        final float texCood = (float)srcBounds.width / (float)srcPitch;
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = WindowsMediaFoundationSource.this.context.getGL().getGL2();
                GLU glu = WindowsMediaFoundationSource.this.context.getGLU();
                gl.glViewport(0, 0, dstBounds.width, dstBounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadIdentity();
                if (flipVert) {
                    glu.gluOrtho2D(0.0f, (float)dstBounds.width, (float)dstBounds.height, 0.0f);
                } else {
                    glu.gluOrtho2D(0.0f, (float)dstBounds.width, 0.0f, (float)dstBounds.height);
                }
                gl.glMatrixMode(5888);
                gl.glLoadIdentity();
                gl.glScalef(scale, scale, 1.0f);
                gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                gl.glBegin(7);
                gl.glTexCoord2f(0.0f, 0.0f);
                gl.glVertex2f(0.0f, 0.0f);
                gl.glTexCoord2f(texCood, 0.0f);
                gl.glVertex2f((float)srcBounds.width, 0.0f);
                gl.glTexCoord2f(texCood, 1.0f);
                gl.glVertex2f((float)srcBounds.width, (float)srcBounds.height);
                gl.glTexCoord2f(0.0f, 1.0f);
                gl.glVertex2f(0.0f, (float)srcBounds.height);
                gl.glEnd();
            }
        };
        IVideoBuffer buffer = null;
        try {
            buffer = this.vrSupport.createVideoBuffer(dstBounds);
            int pushAttribs = 1;
            this.vrSupport.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[]{srcBuffer});
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    public IAudioBuffer getAudioChunk(Time mediaTime, MediaOptions options) {
        if (this.audioThread == null) {
            return null;
        }
        try {
            AudioMode am = this.context.getAudioMode();
            long frameNumber = mediaTime.toFrameNumber(am.sampleDuration);
            if (-frameNumber >= (long)this.context.getAudioFrameCount() || !mediaTime.before(this.duration)) {
                IAudioBuffer ab = this.arSupport.createAudioBuffer();
                this.arSupport.clear(ab);
                return ab;
            }
            if (am != this.audioMode || (long)am.frameSize * frameNumber != this.audioStreamPosition) {
                this.closeAudioStream();
            }
            if (this.audioStream == null) {
                this.audioStream = this.createAudioInputStream();
            }
            return this.readAudioData(frameNumber);
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    private AudioInputStream createAudioInputStream() throws IOException, UnsupportedAudioFileException {
        this.audioMode = this.context.getAudioMode();
        int bits = this.audioMode.sampleSize * 8;
        int ch = this.audioMode.channels;
        long length = this.duration.toFrameNumber(new Time(1L, (int)this.audioFormat.getFrameRate()));
        AudioInputStream s1 = AudioSystem.getAudioInputStream(this.audioFormat, new AudioInputStream(new MFAudioInputStream(this.audioFormat), this.audioFormat, length));
        AudioFormat f2 = new AudioFormat(s1.getFormat().getSampleRate(), bits, ch, true, false);
        AudioInputStream s2 = AudioSystem.getAudioInputStream(f2, s1);
        AudioFormat f3 = new AudioFormat(this.audioMode.sampleRate, bits, ch, true, false);
        return AudioSystem.getAudioInputStream(f3, s2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IAudioBuffer readAudioData(long frameNumber) throws IOException {
        IAudioBuffer ab = this.arSupport.createAudioBuffer();
        AudioMode audioMode = ab.getAudioMode();
        Object data = ab.getData();
        int dataOffset = 0;
        int dataLength = ab.getDataLength();
        int lengthInBytes = dataLength * audioMode.sampleSize;
        if (this.audioStreamPosition == 0L) {
            if (frameNumber > 0L) {
                long skipped;
                long skip = (long)audioMode.frameSize * frameNumber;
                this.audioStreamPosition = skipped = this.audioStream.skip(skip / (long)audioMode.sampleRate * (long)audioMode.sampleRate);
                if ((skip -= skipped) > 0L) {
                    IArray array = this.arrayPools.getByteArray((int)skip);
                    try {
                        do {
                            if ((skipped = (long)this.audioStream.read((byte[])array.getArray(), 0, (int)skip)) == -1L) continue;
                            this.audioStreamPosition += skipped;
                            skip -= skipped;
                        } while (skipped != -1L && skip > 0L);
                    }
                    finally {
                        array.release();
                    }
                }
                if (skip != 0L) {
                    logger.warn(String.format("skip failed: frameNumber=%d, skip=%d", frameNumber, skip));
                    this.closeAudioStream();
                    this.arSupport.clear(ab);
                    return ab;
                }
            } else if (frameNumber < 0L) {
                this.arSupport.clear(ab, 0, (int)(-frameNumber));
                dataOffset = (int)(-frameNumber) * audioMode.channels;
                dataLength -= dataOffset;
                lengthInBytes -= dataOffset * audioMode.sampleSize;
            }
        }
        IArray array = this.arrayPools.getByteArray(lengthInBytes);
        try {
            int n;
            byte[] buffer = (byte[])array.getArray();
            int readBytes = 0;
            do {
                if ((n = this.audioStream.read(buffer, readBytes, lengthInBytes - readBytes)) == -1) {
                    Arrays.fill(buffer, readBytes, lengthInBytes, (byte)0);
                    break;
                }
                this.audioStreamPosition += (long)n;
            } while ((readBytes += n) < lengthInBytes);
            switch (audioMode.dataType) {
                case SHORT: {
                    ByteBuffer.wrap(buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asShortBuffer().get((short[])data, dataOffset, dataLength);
                    return ab;
                }
                case INT: {
                    ByteBuffer.wrap(buffer, 0, lengthInBytes).order(ByteOrder.nativeOrder()).asIntBuffer().get((int[])data, dataOffset, dataLength);
                    return ab;
                }
                case FLOAT: {
                    int i = dataOffset;
                    while (i < dataLength) {
                        int value = buffer[i * 4] & 0xFF | (buffer[i * 4 + 1] & 0xFF) << 8 | (buffer[i * 4 + 2] & 0xFF) << 16 | (buffer[i * 4 + 3] & 0xFF) << 24;
                        ((float[])data)[i] = (float)value / 2.1474836E9f;
                        ++i;
                    }
                    return ab;
                }
            }
            throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
        }
        finally {
            array.release();
        }
    }

    public MediaOptions validateOptions(MediaOptions options) {
        MediaOptions.Option[] availableOptions = this.isVideoAvailable() ? new MediaOptions.Option[]{MediaOptions.Option.FLIP_VERTICAL} : new MediaOptions.Option[]{};
        if (options == null) {
            options = new MediaOptions(availableOptions);
        } else {
            options = options.clone();
            options.setAvailableOptions(availableOptions);
        }
        return options;
    }

    public static native int initDXVA2(long var0);

    private static native int openVideo(String var0, boolean var1, long[] var2);

    private static native void closeVideo(long var0);

    private static native int frameSurfaceAtTime(long var0, long[] var2, long var3, long[] var5);

    private static native int lockSurface(long var0, long var2, ByteBuffer[] var4);

    private static native int unlockSurface(long var0, long var2);

    private static native int releaseSurface(long var0, long var2);

    private static native int openAudio(String var0, long[] var1);

    private static native void closeAudio(long var0);

    private static native int readAudioBufferAtTime(long var0, long[] var2, long[] var3, int[] var4);

    private static native int copyAudioBuffer(long var0, int var2, byte[] var3, int var4, int[] var5);

    private static native int releaseAudioBuffer(long var0);

    static /* synthetic */ boolean access$2() {
        return sysMem;
    }

    static /* synthetic */ int access$3(String string, boolean bl, long[] lArray) {
        return WindowsMediaFoundationSource.openVideo(string, bl, lArray);
    }

    static /* synthetic */ void access$4(WindowsMediaFoundationSource windowsMediaFoundationSource, VideoBounds videoBounds) {
        windowsMediaFoundationSource.bounds = videoBounds;
    }

    static /* synthetic */ void access$5(WindowsMediaFoundationSource windowsMediaFoundationSource, boolean bl) {
        windowsMediaFoundationSource.topDown = bl;
    }

    static /* synthetic */ void access$6(WindowsMediaFoundationSource windowsMediaFoundationSource, Time time) {
        windowsMediaFoundationSource.duration = time;
    }

    static /* synthetic */ void access$7(WindowsMediaFoundationSource windowsMediaFoundationSource, Time time) {
        windowsMediaFoundationSource.videoFrameDuration = time;
    }

    static /* synthetic */ Time access$8(WindowsMediaFoundationSource windowsMediaFoundationSource) {
        return windowsMediaFoundationSource.duration;
    }

    static /* synthetic */ Time access$9(WindowsMediaFoundationSource windowsMediaFoundationSource) {
        return windowsMediaFoundationSource.videoFrameDuration;
    }

    static /* synthetic */ int access$10(long l, long[] lArray, long l2, long[] lArray2) {
        return WindowsMediaFoundationSource.frameSurfaceAtTime(l, lArray, l2, lArray2);
    }

    static /* synthetic */ Logger access$11() {
        return logger;
    }

    static /* synthetic */ int access$12() {
        return bufferFrames;
    }

    static /* synthetic */ int access$13(long l, long l2) {
        return WindowsMediaFoundationSource.unlockSurface(l, l2);
    }

    static /* synthetic */ int access$14(long l, long l2, ByteBuffer[] byteBufferArray) {
        return WindowsMediaFoundationSource.lockSurface(l, l2, byteBufferArray);
    }

    static /* synthetic */ void access$15(long l) {
        WindowsMediaFoundationSource.closeVideo(l);
    }

    static /* synthetic */ int access$18(String string, long[] lArray) {
        return WindowsMediaFoundationSource.openAudio(string, lArray);
    }

    static /* synthetic */ void access$19(WindowsMediaFoundationSource windowsMediaFoundationSource, AudioFormat audioFormat) {
        windowsMediaFoundationSource.audioFormat = audioFormat;
    }

    static /* synthetic */ void access$20(WindowsMediaFoundationSource windowsMediaFoundationSource, boolean bl) {
        windowsMediaFoundationSource.audioFloat = bl;
    }

    static /* synthetic */ int access$21(long l, long[] lArray, long[] lArray2, int[] nArray) {
        return WindowsMediaFoundationSource.readAudioBufferAtTime(l, lArray, lArray2, nArray);
    }

    static /* synthetic */ int access$22(long l, int n, byte[] byArray, int n2, int[] nArray) {
        return WindowsMediaFoundationSource.copyAudioBuffer(l, n, byArray, n2, nArray);
    }

    static /* synthetic */ void access$23(long l) {
        WindowsMediaFoundationSource.closeAudio(l);
    }

    private static class AudioSample {
        private final long position;
        private final byte[] buffer;
        private final int offset;
        private final int length;
        private boolean result;

        AudioSample(long p, byte[] b, int off, int len) {
            this.position = p;
            this.buffer = b;
            this.offset = off;
            this.length = len;
        }

        static /* synthetic */ long access$1(AudioSample audioSample) {
            return audioSample.position;
        }

        static /* synthetic */ int access$2(AudioSample audioSample) {
            return audioSample.offset;
        }

        static /* synthetic */ int access$3(AudioSample audioSample) {
            return audioSample.length;
        }

        static /* synthetic */ byte[] access$4(AudioSample audioSample) {
            return audioSample.buffer;
        }

        static /* synthetic */ void access$5(AudioSample audioSample, boolean bl) {
            audioSample.result = bl;
        }
    }

    private class AudioThread
    extends Thread {
        private File file;
        private final BlockingQueue<AudioSample> queue = new LinkedBlockingQueue<AudioSample>();
        private final SortedMap<Long, Long> buffer = new TreeMap<Long, Long>();
        private long position = Long.MIN_VALUE;

        private AudioThread() {
        }

        boolean initialize(File file) {
            this.file = file;
            this.start();
            return this.read(0L, new byte[1], 0, 1);
        }

        void shutdown() {
            try {
                this.queue.put(new AudioSample(Long.MIN_VALUE, null, 0, 0));
            }
            catch (InterruptedException interruptedException) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean read(long p, byte[] b, int off, int len) {
            AudioSample as;
            AudioSample audioSample = as = new AudioSample(p, b, off, len);
            synchronized (audioSample) {
                try {
                    this.queue.put(as);
                    as.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return as.result;
        }

        private void flush() {
            for (Long medbuf : this.buffer.values()) {
                WindowsMediaFoundationSource.releaseAudioBuffer(medbuf);
            }
            this.buffer.clear();
        }

        private void flushHead() {
            SortedMap<Long, Long> head = this.buffer.headMap((long)((float)this.position - 3.0f * WindowsMediaFoundationSource.this.audioFormat.getFrameRate()));
            for (Long medbuf : head.values()) {
                WindowsMediaFoundationSource.releaseAudioBuffer(medbuf);
            }
            head.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block31: {
                result = new long[6];
                hr = WindowsMediaFoundationSource.access$18(this.file.getAbsolutePath(), result);
                if (hr != 0) ** GOTO lbl-1000
                audioSource = result[0];
                if (WindowsMediaFoundationSource.access$8(WindowsMediaFoundationSource.this) != null) break block31;
                WindowsMediaFoundationSource.access$6(WindowsMediaFoundationSource.this, new Time(result[1], 10000000));
                break block31;
lbl-1000:
                // 1 sources

                {
                    var6_6 = as;
                    synchronized (var6_6) {
                        as.notify();
                        continue;
                    }
                }
lbl-1000:
                // 2 sources

                {
                    ** while ((as = (AudioSample)this.queue.poll()) != null)
                }
lbl17:
                // 1 sources

                return;
            }
            WindowsMediaFoundationSource.access$19(WindowsMediaFoundationSource.this, new AudioFormat(result[2], (int)result[3], (int)result[4], result[3] >= 16L, false));
            WindowsMediaFoundationSource.access$20(WindowsMediaFoundationSource.this, result[5] != 0L);
            this.setName(String.valueOf(WindowsMediaFoundationSource.this.getClass().getSimpleName()) + " (Audio): " + this.file.getName());
            frameRate = WindowsMediaFoundationSource.access$17(WindowsMediaFoundationSource.this).getFrameRate();
            frameSize = WindowsMediaFoundationSource.access$17(WindowsMediaFoundationSource.this).getFrameSize();
            shutdown = false;
            forward = false;
            prevPosition = 0L;
            while (this.queue.peek() != null || !shutdown) {
                as = (AudioSample)this.queue.poll();
                if (as == null) {
                    if (forward) {
                        ioTime = new long[1];
                        outMedbuf = new long[1];
                        outLen = new int[1];
                        while (this.queue.peek() == null && (float)(this.position - prevPosition) < frameRate) {
                            ioTime[0] = -9223372036854775808L;
                            hr = WindowsMediaFoundationSource.access$21(audioSource, ioTime, outMedbuf, outLen);
                            if (hr != 0) {
                                WindowsMediaFoundationSource.access$11().error("readAudioBufferAtTime: error " + hr);
                                forward = false;
                                break;
                            }
                            if (outLen[0] % frameSize != 0) {
                                WindowsMediaFoundationSource.access$16(outMedbuf[0]);
                                forward = false;
                                hr = -1;
                                WindowsMediaFoundationSource.access$11().error("readAudioBufferAtTime: invalid sample length: " + outLen[0]);
                                break;
                            }
                            old = this.buffer.put(this.position, outMedbuf[0]);
                            this.position += (long)(outLen[0] / frameSize);
                            if (old != null) {
                                WindowsMediaFoundationSource.access$16(old);
                            }
                            this.flushHead();
                        }
                    }
                    try {
                        as = this.queue.take();
                    }
                    catch (InterruptedException v1) {
                        continue;
                    }
                }
                if (AudioSample.access$1(as) == -9223372036854775808L) {
                    shutdown = true;
                    forward = false;
                    continue;
                }
                forward = AudioSample.access$1(as) > prevPosition;
                prevPosition = AudioSample.access$1(as);
                off = AudioSample.access$2(as);
                len = AudioSample.access$3(as);
                ioTime = null;
                if (!this.buffer.isEmpty() && AudioSample.access$1(as) >= this.buffer.firstKey() && AudioSample.access$1(as) < this.position) {
                    ioLen = new int[1];
                    fromKey = this.buffer.headMap(AudioSample.access$1(as) + 1L).lastKey();
                    for (Long key : this.buffer.tailMap(fromKey).keySet()) {
                        srcOff = AudioSample.access$1(as) > key ? (int)((AudioSample.access$1(as) - key) * (long)frameSize) : 0;
                        ioLen[0] = len;
                        hr = WindowsMediaFoundationSource.access$22((Long)this.buffer.get(key), srcOff, AudioSample.access$4(as), off, ioLen);
                        if (hr != 0) {
                            WindowsMediaFoundationSource.access$11().error("copyAudioBuffer: error " + hr);
                            break;
                        }
                        off += ioLen[0];
                        if ((len -= ioLen[0]) != 0) continue;
                    }
                    if (hr == 0 && len > 0) {
                        ioTime = new long[]{-9223372036854775808L};
                    }
                } else if (AudioSample.access$1(as) >= this.position && (float)AudioSample.access$1(as) < (float)this.position + frameRate) {
                    ioTime = new long[]{-9223372036854775808L};
                } else {
                    this.flush();
                    ioTime = new long[]{(long)((float)AudioSample.access$1(as) / frameRate * 1.0E7f)};
                }
                if (ioTime != null) {
                    outMedbuf = new long[1];
                    outLen = new int[1];
                    ioLen = new int[1];
                    while (len > 0) {
                        seek = ioTime[0] != -9223372036854775808L;
                        hr = WindowsMediaFoundationSource.access$21(audioSource, ioTime, outMedbuf, outLen);
                        if (hr != 0) {
                            WindowsMediaFoundationSource.access$11().error("readAudioBufferAtTime: error " + hr);
                            break;
                        }
                        if (outLen[0] % frameSize != 0) {
                            WindowsMediaFoundationSource.access$16(outMedbuf[0]);
                            hr = -1;
                            WindowsMediaFoundationSource.access$11().error("readAudioBufferAtTime: invalid sample length: " + outLen[0]);
                            break;
                        }
                        pos = seek != false ? (long)Math.round((float)ioTime[0] * frameRate / 1.0E7f) : this.position;
                        old = this.buffer.put(pos, outMedbuf[0]);
                        this.position = pos + (long)(outLen[0] / frameSize);
                        if (old != null) {
                            WindowsMediaFoundationSource.access$16(old);
                        }
                        this.flushHead();
                        v2 = srcOff = AudioSample.access$1(as) > pos ? (int)((AudioSample.access$1(as) - pos) * (long)frameSize) : 0;
                        if (srcOff < outLen[0]) {
                            ioLen[0] = len;
                            hr = WindowsMediaFoundationSource.access$22(outMedbuf[0], srcOff, AudioSample.access$4(as), off, ioLen);
                            if (hr != 0) {
                                WindowsMediaFoundationSource.access$11().error("copyAudioBuffer: error " + hr);
                                break;
                            }
                            off += ioLen[0];
                            len -= ioLen[0];
                        }
                        ioTime[0] = -9223372036854775808L;
                    }
                }
                var15_17 = as;
                synchronized (var15_17) {
                    AudioSample.access$5(as, hr == 0);
                    as.notify();
                }
            }
            this.flush();
            WindowsMediaFoundationSource.access$23(audioSource);
        }
    }

    private static class FrameSurface {
        private final long frameNumber;
        private long surface;
        private ByteBuffer buffer;

        FrameSurface(long frameNumber) {
            this.frameNumber = frameNumber;
        }

        static /* synthetic */ long access$1(FrameSurface frameSurface) {
            return frameSurface.frameNumber;
        }

        static /* synthetic */ void access$2(FrameSurface frameSurface, long l) {
            frameSurface.surface = l;
        }

        static /* synthetic */ void access$3(FrameSurface frameSurface, ByteBuffer byteBuffer) {
            frameSurface.buffer = byteBuffer;
        }
    }

    private class MFAudioInputStream
    extends InputStream {
        private final AudioFormat format;
        private long positionInBytes;

        private MFAudioInputStream(AudioFormat format) {
            this.format = format;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 0) != -1 ? b[0] : -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int frameSize = this.format.getFrameSize();
            if (len % frameSize != 0) {
                throw new IOException("can't read the length bytes that is not multiples of frameSize");
            }
            if (!WindowsMediaFoundationSource.this.audioThread.read(this.positionInBytes / (long)frameSize, b, off, len)) {
                Arrays.fill(b, off, off + len, (byte)0);
            }
            if (WindowsMediaFoundationSource.this.audioFloat) {
                int i = off;
                while (i < len) {
                    int bits = b[i] & 0xFF | (b[i + 1] & 0xFF) << 8 | (b[i + 2] & 0xFF) << 16 | (b[i + 3] & 0xFF) << 24;
                    int intValue = (int)(Float.intBitsToFloat(bits) * 2.1474836E9f);
                    b[i] = (byte)(intValue & 0xFF);
                    b[i + 1] = (byte)(intValue >>> 8 & 0xFF);
                    b[i + 2] = (byte)(intValue >>> 16 & 0xFF);
                    b[i + 3] = (byte)(intValue >>> 24 & 0xFF);
                    i += 4;
                }
            }
            this.positionInBytes += (long)len;
            return len;
        }

        public long skip(long n) throws IOException {
            long actualSkip = 0L;
            if (n > 0L) {
                int frameSize = this.format.getFrameSize();
                actualSkip = n / (long)frameSize * (long)frameSize;
                this.positionInBytes += actualSkip;
            }
            return actualSkip;
        }
    }

    private class VideoThread
    extends Thread {
        private File file;
        private final BlockingQueue<FrameSurface> queue = new LinkedBlockingQueue<FrameSurface>();
        private long videoSource;
        private final Map<Long, Long> buffer = new LinkedHashMap<Long, Long>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, Long> eldest) {
                if (this.size() > cacheFrames) {
                    this.remove(eldest.getKey());
                    WindowsMediaFoundationSource.releaseSurface(VideoThread.this.videoSource, eldest.getValue());
                }
                return false;
            }
        };
        private long position = Long.MIN_VALUE;

        private VideoThread() {
        }

        boolean initialize(File file) {
            this.file = file;
            this.start();
            FrameSurface fs = this.lockFrame(0L);
            if (fs != null) {
                this.unlockFrame(fs);
                return true;
            }
            return false;
        }

        void shutdown() {
            try {
                this.queue.put(new FrameSurface(Long.MIN_VALUE));
            }
            catch (InterruptedException interruptedException) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FrameSurface lockFrame(long frameNumber) {
            FrameSurface fs;
            FrameSurface frameSurface = fs = new FrameSurface(frameNumber);
            synchronized (frameSurface) {
                try {
                    this.queue.put(fs);
                    fs.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return fs.surface != 0L ? fs : null;
        }

        void unlockFrame(FrameSurface fs) {
            if (fs.surface == 0L) {
                throw new IllegalArgumentException();
            }
            try {
                this.queue.put(fs);
            }
            catch (InterruptedException interruptedException) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block33: {
                result = new long[7];
                hr = WindowsMediaFoundationSource.access$3(this.file.getAbsolutePath(), WindowsMediaFoundationSource.access$2(), result);
                if (hr != 0) ** GOTO lbl12
                break block33;
lbl-1000:
                // 1 sources

                {
                    var4_5 = fs;
                    synchronized (var4_5) {
                        fs.notify();
                        continue;
                    }
lbl12:
                    // 2 sources

                    ** while ((fs = (FrameSurface)this.queue.poll()) != null)
                }
lbl13:
                // 1 sources

                return;
            }
            this.videoSource = result[0];
            WindowsMediaFoundationSource.access$4(WindowsMediaFoundationSource.this, new VideoBounds((int)result[1], (int)result[2]));
            WindowsMediaFoundationSource.access$5(WindowsMediaFoundationSource.this, result[3] != 0L);
            WindowsMediaFoundationSource.access$6(WindowsMediaFoundationSource.this, new Time(result[4], 10000000));
            WindowsMediaFoundationSource.access$7(WindowsMediaFoundationSource.this, new Time(result[6], (int)result[5]));
            this.setName(String.valueOf(WindowsMediaFoundationSource.this.getClass().getSimpleName()) + " (Video): " + this.file.getName());
            estFrameDuration = NaN;
            if (WindowsMediaFoundationSource.access$8(WindowsMediaFoundationSource.this).toFrameNumber(WindowsMediaFoundationSource.access$9(WindowsMediaFoundationSource.this)) > 20L) {
                prev = 0L;
                sum = 0L;
                ioTime = new long[1];
                i = 0;
                while (i <= 10) {
                    ioTime[0] = -9223372036854775808L;
                    hr = WindowsMediaFoundationSource.access$10(this.videoSource, ioTime, 0L, null);
                    if (hr != 1) {
                        WindowsMediaFoundationSource.access$11().error("frameSurfaceAtTime: error " + hr);
                        break;
                    }
                    if (i > 0) {
                        sum += ioTime[0] - prev;
                    }
                    prev = ioTime[0];
                    ++i;
                }
                if (hr == 1) {
                    estFrameDuration = (double)sum / 1.0E8;
                }
            }
            if (Double.isNaN(estFrameDuration)) {
                estFrameDuration = WindowsMediaFoundationSource.access$9(WindowsMediaFoundationSource.this).toSecond();
            }
            shutdown = false;
            forward = false;
            prevNumber = 0L;
            while (this.queue.peek() != null || !shutdown) {
                fs = (FrameSurface)this.queue.poll();
                if (fs == null) {
                    if (forward) {
                        ioTime = new long[1];
                        newSurface = new long[1];
                        while (this.queue.peek() == null && !this.buffer.containsKey(this.position) && this.position - prevNumber <= (long)WindowsMediaFoundationSource.access$12()) {
                            ioTime[0] = -9223372036854775808L;
                            hr = WindowsMediaFoundationSource.access$10(this.videoSource, ioTime, -9223372036854775808L, newSurface);
                            if (hr != 0) {
                                WindowsMediaFoundationSource.access$11().error("frameSurfaceAtTime: error " + hr);
                                forward = false;
                                break;
                            }
                            frameNumber = Math.round((double)ioTime[0] / (1.0E7 * estFrameDuration));
                            this.position = frameNumber + 1L;
                            old = this.buffer.put(frameNumber, newSurface[0]);
                            if (old == null) continue;
                            WindowsMediaFoundationSource.access$1(this.videoSource, old);
                        }
                    }
                    try {
                        fs = this.queue.take();
                    }
                    catch (InterruptedException v1) {
                        continue;
                    }
                }
                if (FrameSurface.access$0(fs) != 0L) {
                    WindowsMediaFoundationSource.access$13(this.videoSource, FrameSurface.access$0(fs));
                    continue;
                }
                if (FrameSurface.access$1(fs) == -9223372036854775808L) {
                    shutdown = true;
                    forward = false;
                    continue;
                }
                forward = FrameSurface.access$1(fs) > prevNumber;
                prevNumber = FrameSurface.access$1(fs);
                bufferedSurface = this.buffer.get(FrameSurface.access$1(fs));
                if (bufferedSurface != null) {
                    surface = bufferedSurface;
                } else {
                    ioTime = FrameSurface.access$1(fs) < this.position || FrameSurface.access$1(fs) >= this.position + 10L ? new long[]{(long)(((double)FrameSurface.access$1(fs) + 0.5) * estFrameDuration * 1.0E7)} : new long[]{-9223372036854775808L};
                    limitTime = (long)(((double)(FrameSurface.access$1(fs) - (long)(WindowsMediaFoundationSource.access$0() - WindowsMediaFoundationSource.access$12())) + 0.5) * estFrameDuration * 1.0E7);
                    newSurface = new long[1];
                    while (true) {
                        if ((hr = WindowsMediaFoundationSource.access$10(this.videoSource, ioTime, limitTime, newSurface)) == 1) {
                            ioTime[0] = -9223372036854775808L;
                            continue;
                        }
                        if (hr != 0) {
                            WindowsMediaFoundationSource.access$11().error("frameSurfaceAtTime: error " + hr);
                            surface = 0L;
                            break;
                        }
                        frameNumber = Math.round((double)ioTime[0] / (1.0E7 * estFrameDuration));
                        this.position = frameNumber + 1L;
                        old = this.buffer.put(frameNumber, newSurface[0]);
                        if (old != null) {
                            WindowsMediaFoundationSource.access$1(this.videoSource, old);
                        }
                        if (frameNumber >= FrameSurface.access$1(fs)) {
                            surface = newSurface[0];
                            break;
                        }
                        ioTime[0] = -9223372036854775808L;
                    }
                }
                if (surface != 0L) {
                    buffer = new ByteBuffer[1];
                    hr = WindowsMediaFoundationSource.access$14(this.videoSource, surface, buffer);
                    if (hr != 0) {
                        WindowsMediaFoundationSource.access$11().error("lockSurface: error " + hr);
                    } else {
                        FrameSurface.access$2(fs, surface);
                        FrameSurface.access$3(fs, buffer[0]);
                    }
                }
                var13_18 = fs;
                synchronized (var13_18) {
                    fs.notify();
                }
            }
            for (long surface : this.buffer.values()) {
                WindowsMediaFoundationSource.access$1(this.videoSource, surface);
            }
            this.buffer.clear();
            WindowsMediaFoundationSource.access$15(this.videoSource);
            this.videoSource = 0L;
        }
    }
}

