/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.FrameDuration;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.internal.MacOSXOpenGLPixelFormat;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.SynchronousTaskThread;
import com.google.inject.Inject;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacOSXQTCoreVideoSource
implements MediaSource {
    private static final Logger _logger = LoggerFactory.getLogger(MacOSXQTCoreVideoSource.class);
    private GLContext _glContext;
    private int _fboId;
    private long _videoInput;
    private long _audioInput;
    private VideoBounds _bounds;
    private Time _duration;
    private Time _videoFrameDuration;
    private AudioMode _audioMode;
    @Inject
    private SynchronousTaskThread _videoThread;
    @Inject
    private SynchronousTaskThread _audioThread;
    @Inject
    private GLGlobal _glGlobal;
    @Inject
    private RenderContext _context;
    @Inject
    private IVideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderSupport _arSupport;

    static {
        System.loadLibrary("QTCoreVideoInput");
    }

    public boolean initialize(final File file) {
        this._videoThread.start();
        this._videoThread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                MacOSXQTCoreVideoSource.this.initializeVideo(file);
            }
        });
        if (this._videoInput == 0L) {
            this.disposeVideo();
        }
        this._audioThread.start();
        this._audioThread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                MacOSXQTCoreVideoSource.this.initializeAudio(file);
            }
        });
        if (this._audioInput == 0L) {
            this.disposeAudio();
        }
        return this._videoInput != 0L || this._audioInput != 0L;
    }

    private void initializeVideo(File file) {
        ReentrantLock lock = this._glGlobal.getGlobalLock();
        lock.lock();
        try {
            this._glContext = this._glGlobal.createContext();
            this._glContext.makeCurrent();
        }
        finally {
            lock.unlock();
        }
        GL2 gl = this._glContext.getGL().getGL2();
        int[] fboId = new int[1];
        gl.glGenBuffers(1, fboId, 0);
        this._fboId = fboId[0];
        gl.glBindFramebuffer(36160, this._fboId);
        long pixelFormat = MacOSXOpenGLPixelFormat.createPixelFormat(this._glContext);
        long[] result = this.openVideo(file.getAbsolutePath(), pixelFormat);
        MacOSXOpenGLPixelFormat.deletePixelFormat(pixelFormat);
        if (result != null) {
            this._videoInput = result[0];
            this._bounds = new VideoBounds((int)result[1], (int)result[2]);
            this._duration = new Time(result[4], (int)result[5]);
            this._videoFrameDuration = result[3] > 0L ? new Time(result[4] / result[3], (int)result[5]) : new Time(0L, (int)result[5]);
            this._videoThread.setName(String.valueOf(this.getClass().getSimpleName()) + " (Video): " + file.getName());
        }
    }

    private void initializeAudio(File file) {
        long[] result = this.openAudio(file.getAbsolutePath());
        if (result != null) {
            this._audioInput = result[0];
            if (this._duration == null) {
                this._duration = new Time(result[2], (int)result[3]);
            }
            this._audioThread.setName(String.valueOf(this.getClass().getSimpleName()) + " (Audio): " + file.getName());
        }
    }

    public void dispose() {
        this.disposeVideo();
        this.disposeAudio();
    }

    private void disposeVideo() {
        this._videoThread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (MacOSXQTCoreVideoSource.this._videoInput != 0L) {
                    MacOSXQTCoreVideoSource.this.closeVideo(MacOSXQTCoreVideoSource.this._videoInput);
                    MacOSXQTCoreVideoSource.this._videoInput = 0L;
                    MacOSXQTCoreVideoSource.this._bounds = null;
                }
                if (MacOSXQTCoreVideoSource.this._glContext != null) {
                    GL2 gl = MacOSXQTCoreVideoSource.this._glContext.getGL().getGL2();
                    gl.glBindFramebuffer(36160, 0);
                    gl.glDeleteBuffers(1, new int[]{MacOSXQTCoreVideoSource.this._fboId}, 0);
                    MacOSXQTCoreVideoSource.this._fboId = 0;
                    gl.glFinish();
                    ReentrantLock lock = MacOSXQTCoreVideoSource.this._glGlobal.getGlobalLock();
                    lock.lock();
                    try {
                        MacOSXQTCoreVideoSource.this._glContext.release();
                        MacOSXQTCoreVideoSource.this._glGlobal.destroyContext(MacOSXQTCoreVideoSource.this._glContext);
                    }
                    finally {
                        lock.unlock();
                    }
                    MacOSXQTCoreVideoSource.this._glContext = null;
                }
            }
        });
    }

    private void disposeAudio() {
        this._audioThread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (MacOSXQTCoreVideoSource.this._audioInput != 0L) {
                    MacOSXQTCoreVideoSource.this.closeAudio(MacOSXQTCoreVideoSource.this._audioInput);
                    MacOSXQTCoreVideoSource.this._audioInput = 0L;
                    MacOSXQTCoreVideoSource.this._audioMode = null;
                }
            }
        });
    }

    public boolean isVideoAvailable() {
        return this._videoInput != 0L;
    }

    public boolean isAudioAvailable() {
        return this._audioInput != 0L;
    }

    public Time getDuration(MediaOptions options) {
        if (options == null || !options.isAvailable(MediaOptions.Option.DURATION)) {
            return this._duration;
        }
        Time duration = options.getDuration();
        return duration != null ? duration : this._duration;
    }

    public Time getVideoFrameDuration(MediaOptions options) {
        return this._videoFrameDuration;
    }

    public VideoBounds getVideoFrameBounds(MediaOptions options) {
        return this._bounds;
    }

    public IVideoBuffer getVideoFrame(Time mediaTime, MediaOptions options) {
        int timeScale;
        long timeValue;
        if (this._videoInput == 0L) {
            return null;
        }
        final VideoBounds bounds = this._context.getVideoResolution().scale(this._bounds);
        IVideoBuffer vb = this._vrSupport.createVideoBuffer(bounds);
        if (mediaTime.timeValue < 0L || !mediaTime.before(this.getDuration(options))) {
            vb.clear();
            return vb;
        }
        if (this._videoFrameDuration.timeValue > 0L) {
            Time time = Time.fromFrameNumber((long)mediaTime.toFrameNumber(this._videoFrameDuration), (Time)this._videoFrameDuration);
            timeValue = time.timeValue + this._videoFrameDuration.timeValue / 2L;
            timeScale = time.timeScale;
        } else {
            timeValue = mediaTime.timeValue;
            timeScale = mediaTime.timeScale;
        }
        final int texture = vb.getTexture();
        final int alphaType = options.getAlphaType().ordinal();
        final Color colorMatte = options.getColorMatte();
        final boolean flipVert = options.isFlipVertical();
        int error = this._videoThread.invoke(new SynchronousTaskThread.Task<Integer>(){

            @Override
            public Integer run() throws Exception {
                int error = MacOSXQTCoreVideoSource.this.frameImageAtTime(MacOSXQTCoreVideoSource.this._videoInput, timeValue, timeScale, texture, bounds.width, bounds.height, alphaType, (float)colorMatte.r, (float)colorMatte.g, (float)colorMatte.b, flipVert);
                if (error != 0) {
                    _logger.error("frameImageAtTime: error " + error);
                }
                return error;
            }
        });
        if (error == 0) {
            return vb;
        }
        vb.dispose();
        return null;
    }

    public IAudioBuffer getAudioChunk(Time mediaTime, MediaOptions options) {
        int offset;
        long frameNumber;
        if (this._audioInput == 0L) {
            return null;
        }
        final IAudioBuffer ab = this._arSupport.createAudioBuffer();
        final AudioMode am = ab.getAudioMode();
        long fn = mediaTime.toFrameNumber(am.sampleDuration);
        if (-fn >= (long)ab.getFrameCount() || !mediaTime.before(this.getDuration(options))) {
            this._arSupport.clear(ab);
            return ab;
        }
        if (fn >= 0L) {
            frameNumber = fn;
            offset = 0;
        } else {
            frameNumber = 0L;
            offset = (int)(-fn);
            this._arSupport.clear(ab, 0, offset);
        }
        int error = this._audioThread.invoke(new SynchronousTaskThread.Task<Integer>(){

            @Override
            public Integer run() throws Exception {
                int error;
                if (am != MacOSXQTCoreVideoSource.this._audioMode) {
                    error = MacOSXQTCoreVideoSource.this.setAudioDescription(MacOSXQTCoreVideoSource.this._audioInput, am.channels, am.sampleRate, am.sampleSize, am.dataType == AudioMode.DataType.FLOAT);
                    if (error != 0) {
                        _logger.error("setAudioDescription: error " + error);
                        return error;
                    }
                    MacOSXQTCoreVideoSource.this._audioMode = am;
                }
                if ((error = MacOSXQTCoreVideoSource.this.audioChunkFromTime(MacOSXQTCoreVideoSource.this._audioInput, frameNumber, am.sampleRate, ab.getData(), offset, ab.getFrameCount() - offset)) != 0) {
                    _logger.error("audioChunkFromTime: error " + error);
                }
                return error;
            }
        });
        if (error == 0) {
            return ab;
        }
        ab.dispose();
        return null;
    }

    public MediaOptions validateOptions(MediaOptions options) {
        MediaOptions.Option[] availableOptions;
        Time defaultDuration = null;
        if (this.isVideoAvailable()) {
            if (this._videoFrameDuration.timeValue > 0L) {
                availableOptions = new MediaOptions.Option[]{MediaOptions.Option.IGNORE_ALPHA, MediaOptions.Option.STRAIGHT_ALPHA, MediaOptions.Option.PREMULTIPLIED_ALPHA, MediaOptions.Option.FLIP_VERTICAL};
            } else {
                availableOptions = new MediaOptions.Option[]{MediaOptions.Option.IGNORE_ALPHA, MediaOptions.Option.STRAIGHT_ALPHA, MediaOptions.Option.PREMULTIPLIED_ALPHA, MediaOptions.Option.DURATION, MediaOptions.Option.FLIP_VERTICAL};
                defaultDuration = Time.fromFrameNumber((long)3600L, (Time)FrameDuration.FPS_59_94);
            }
        } else {
            availableOptions = new MediaOptions.Option[]{};
        }
        if (options == null) {
            options = new MediaOptions(availableOptions);
        } else {
            options = options.clone();
            options.setAvailableOptions(availableOptions);
        }
        if (defaultDuration != null && options.getDuration() == null) {
            options.setDuration(defaultDuration);
        }
        return options;
    }

    private native long[] openVideo(String var1, long var2);

    private native long[] openAudio(String var1);

    private native void closeVideo(long var1);

    private native void closeAudio(long var1);

    private native int frameImageAtTime(long var1, long var3, int var5, int var6, int var7, int var8, int var9, float var10, float var11, float var12, boolean var13);

    private native int setAudioDescription(long var1, int var3, int var4, int var5, boolean var6);

    private native int audioChunkFromTime(long var1, long var3, int var5, Object var6, int var7, int var8);
}

