/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.TexCoords;
import ch.kuramo.javie.effects.keying.KeyingShaders;
import ch.kuramo.javie.effects.keying.Smoothing;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlueGreenScreenKeyBase {
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram keyingProgram;
    private final IShaderProgram maskOnlyProgram;
    private final IShaderProgram smoothingLowProgram;
    private final IShaderProgram smoothingHighProgram;

    protected BlueGreenScreenKeyBase(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders, boolean blue) {
        this.context = context;
        this.support = support;
        if (blue) {
            this.keyingProgram = shaders.getProgram(KeyingShaders.class, "BLUE_SCREEN_KEY");
            this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "BLUE_SCREEN_KEY_MASK_ONLY");
        } else {
            this.keyingProgram = shaders.getProgram(KeyingShaders.class, "GREEN_SCREEN_KEY");
            this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "GREEN_SCREEN_KEY_MASK_ONLY");
        }
        this.smoothingLowProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_LOW");
        this.smoothingHighProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_HIGH");
    }

    protected IVideoBuffer doKeying(IAnimatableDouble threshold, IAnimatableDouble cutoff, IAnimatableBoolean maskOnly, IAnimatableEnum<Smoothing> smoothing) {
        float[] neib;
        IShaderProgram program;
        IVideoBuffer buffer;
        double c;
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        double t = (Double)this.context.value((IAnimatableValue)threshold) / 100.0;
        double t_minus_c = t - (c = (Double)this.context.value((IAnimatableValue)cutoff) / 100.0);
        if (t_minus_c == 0.0) {
            if (t == 0.0) {
                t_minus_c = Double.POSITIVE_INFINITY;
            } else if (t == 1.0) {
                t = Double.POSITIVE_INFINITY;
            }
        }
        Smoothing sm = (Smoothing)((Object)this.context.value(smoothing));
        boolean mask = (Boolean)this.context.value((IAnimatableValue)maskOnly);
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("threshold", (float)t));
            uniforms.add(new GLUniformData("t_minus_c", (float)t_minus_c));
            IShaderProgram program2 = mask ? this.maskOnlyProgram : this.keyingProgram;
            buffer = this.support.useShaderProgram(program2, uniforms, null, new IVideoBuffer[]{input});
        }
        finally {
            input.dispose();
        }
        switch (sm) {
            case LOW: {
                program = this.smoothingLowProgram;
                neib = TexCoords.neighboringOffset8(bounds.width, bounds.height);
                break;
            }
            case HIGH: {
                program = this.smoothingHighProgram;
                neib = TexCoords.neighboringOffset24(bounds.width, bounds.height);
                break;
            }
            default: {
                return buffer;
            }
        }
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("neib[0]", 2, FloatBuffer.wrap(neib)));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program, uniforms, null, new IVideoBuffer[]{buffer});
            return iVideoBuffer;
        }
        finally {
            buffer.dispose();
        }
    }
}

